/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block;

import java.util.UUID;
import net.mehvahdjukaar.moonlight.api.client.IScreenProvider;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public interface IOnePlayerInteractable {
    public void setPlayerWhoMayEdit(@Nullable UUID var1);

    public UUID getPlayerWhoMayEdit();

    default public boolean isEditingPlayer(Player player) {
        if (player.level().isClientSide) {
            return this.isCloseEnoughToEdit(player);
        }
        this.validateEditingPlayer();
        UUID uuid = this.getPlayerWhoMayEdit();
        return uuid != null && uuid.equals(player.getUUID());
    }

    default public boolean isOtherPlayerEditing(Player player) {
        this.validateEditingPlayer();
        UUID uuid = this.getPlayerWhoMayEdit();
        return uuid != null && !uuid.equals(player.getUUID());
    }

    private void validateEditingPlayer() {
        Level level = ((BlockEntity)this).getLevel();
        if (level == null) {
            this.setPlayerWhoMayEdit(null);
            return;
        }
        UUID uuid = this.getPlayerWhoMayEdit();
        if (uuid == null) {
            return;
        }
        Player player = level.getPlayerByUUID(uuid);
        if (player == null || this.isCloseEnoughToEdit(player)) {
            this.setPlayerWhoMayEdit(null);
        }
    }

    private boolean isCloseEnoughToEdit(Player player) {
        BlockPos pos = ((BlockEntity)this).getBlockPos();
        return player.distanceToSqr((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()) > 64.0;
    }

    default public boolean tryOpeningEditGui(ServerPlayer player, BlockPos pos, ItemStack stack) {
        if (Utils.mayPerformBlockAction((Player)player, (BlockPos)pos, (ItemStack)stack) && !this.isOtherPlayerEditing((Player)player)) {
            this.setPlayerWhoMayEdit(player.getUUID());
            IOnePlayerInteractable iOnePlayerInteractable = this;
            if (iOnePlayerInteractable instanceof IScreenProvider) {
                IScreenProvider sp = (IScreenProvider)iOnePlayerInteractable;
                sp.sendOpenGuiPacket(player.level(), pos, (Player)player);
                return false;
            }
            iOnePlayerInteractable = this;
            if (iOnePlayerInteractable instanceof MenuProvider) {
                MenuProvider mp = (MenuProvider)iOnePlayerInteractable;
                PlatHelper.openCustomMenu((ServerPlayer)player, (MenuProvider)mp, (BlockPos)pos);
                return true;
            }
        }
        return false;
    }
}

