/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.tiles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.function.Function;
import net.mehvahdjukaar.moonlight.api.client.model.BakedQuadBuilder;
import net.mehvahdjukaar.moonlight.api.client.util.RotHlpr;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.blocks.BookPileBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.BookPileHorizontalBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.BookPileBlockTile;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.reg.ClientRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class BookPileBlockTileRenderer
implements BlockEntityRenderer<BookPileBlockTile> {
    private static ModelBlockRenderer renderer;
    private static ModelManager modelManager;

    public BookPileBlockTileRenderer(BlockEntityRendererProvider.Context context) {
    }

    public boolean shouldRender(BookPileBlockTile blockEntity, Vec3 cameraPos) {
        return ClientConfigs.Tweaks.BOOK_GLINT.get();
    }

    public void render(BookPileBlockTile tile, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn, int light, int overlay) {
        BlockState state = tile.getBlockState();
        BookPileBlockTileRenderer.renderBookPile(tile.horizontal, tile.booksVisuals, matrixStack, v -> v.getBuilder(bufferIn), light, overlay, state);
    }

    public static void renderBookPile(boolean horizontal, BookPileBlockTile.BooksList books, PoseStack matrixStack, Function<BookPileBlockTile.VisualBook, VertexConsumer> bufferIn, int light, int overlay, BlockState state) {
        if (horizontal) {
            BookPileBlockTileRenderer.renderHorizontal(books, state, matrixStack, bufferIn, light, overlay);
        } else {
            BookPileBlockTileRenderer.renderVertical(books, state, matrixStack, bufferIn, light, overlay);
        }
    }

    private static void renderHorizontal(BookPileBlockTile.BooksList visualBooks, BlockState state, PoseStack poseStack, Function<BookPileBlockTile.VisualBook, VertexConsumer> buffer, int light, int overlay) {
        int books = Math.min((Integer)state.getValue((Property)BookPileBlock.BOOKS), visualBooks.size());
        Direction dir = (Direction)state.getValue((Property)BookPileHorizontalBlock.FACING);
        poseStack.translate(0.5, 0.5, 0.5);
        poseStack.mulPose(RotHlpr.rot((Direction)dir));
        poseStack.translate(-0.5, -0.6875, -0.5);
        float angle = 0.19634955f;
        switch (books) {
            case 4: {
                poseStack.translate(-0.375f, 0.0f, 0.0f);
                BookPileBlockTileRenderer.renderBook(poseStack, buffer, light, overlay, visualBooks.get(0));
                poseStack.translate(0.25f, 0.0f, -0.0625f);
                BookPileBlockTileRenderer.renderBook(poseStack, buffer, light, overlay, visualBooks.get(1));
                poseStack.translate(0.25f, 0.0f, 0.0625f);
                BookPileBlockTileRenderer.renderBook(poseStack, buffer, light, overlay, visualBooks.get(2));
                poseStack.translate(0.25f, 0.0f, -0.0625f);
                BookPileBlockTileRenderer.renderBook(poseStack, buffer, light, overlay, visualBooks.get(3));
                break;
            }
            case 3: {
                poseStack.translate(-0.3125f, 0.0f, 0.0f);
                BookPileBlockTileRenderer.renderBook(poseStack, buffer, light, overlay, visualBooks.get(0));
                poseStack.translate(0.25f, 0.0f, -0.0625f);
                BookPileBlockTileRenderer.renderBook(poseStack, buffer, light, overlay, visualBooks.get(1));
                poseStack.translate(0.3125f, 0.0f, 0.0625f);
                BookPileBlockTileRenderer.renderBook(poseStack, buffer, light, overlay, visualBooks.get(2), 0.0f, angle);
                break;
            }
            case 2: {
                poseStack.translate(-0.1875f, 0.0f, 0.0f);
                BookPileBlockTileRenderer.renderBook(poseStack, buffer, light, overlay, visualBooks.get(0));
                poseStack.translate(0.3125f, 0.0f, 0.0625f);
                BookPileBlockTileRenderer.renderBook(poseStack, buffer, light, overlay, visualBooks.get(1), 0.0f, angle);
                break;
            }
            case 1: {
                BookPileBlockTileRenderer.renderBook(poseStack, buffer, light, overlay, visualBooks.get(0));
                break;
            }
        }
    }

    private static void renderVertical(BookPileBlockTile.BooksList booksList, BlockState state, PoseStack matrixStack, Function<BookPileBlockTile.VisualBook, VertexConsumer> builder, int light, int overlay) {
        int maxBooks = Math.min((Integer)state.getValue((Property)BookPileBlock.BOOKS), booksList.size());
        matrixStack.translate(0.0f, -0.375f, 0.0f);
        float zRot = -1.5707964f;
        for (int i = 0; i < maxBooks; ++i) {
            BookPileBlockTile.VisualBook b = booksList.get(i);
            BookPileBlockTileRenderer.renderBook(matrixStack, builder, light, overlay, b, b.getAngle(), zRot);
            matrixStack.translate(0.0f, 0.25f, 0.0f);
        }
    }

    private static void renderBook(PoseStack poseStack, Function<BookPileBlockTile.VisualBook, VertexConsumer> vertexBuilder, int light, int overlay, BookPileBlockTile.VisualBook b) {
        BookPileBlockTileRenderer.renderBook(poseStack, vertexBuilder, light, overlay, b, 0.0f, 0.0f);
    }

    private static void renderBook(PoseStack poseStack, Function<BookPileBlockTile.VisualBook, VertexConsumer> vertexBuilder, int light, int overlay, BookPileBlockTile.VisualBook b, float xRot, float zRot) {
        BakedModel model;
        VertexConsumer builder = vertexBuilder.apply(b);
        if (builder == null) {
            return;
        }
        poseStack.pushPose();
        poseStack.translate(0.5, 0.5, 0.5);
        if (zRot != 0.0f) {
            poseStack.mulPose(Axis.ZP.rotation(zRot));
        }
        if (xRot != 0.0f) {
            poseStack.mulPose(Axis.XP.rotation(xRot));
        }
        poseStack.translate(-0.5, -0.3125, -0.5);
        if (renderer == null) {
            renderer = Minecraft.getInstance().getBlockRenderer().getModelRenderer();
            modelManager = Minecraft.getInstance().getModelManager();
        }
        if ((model = ClientHelper.getModel((ModelManager)modelManager, (ModelResourceLocation)ClientRegistry.BOOK_MODELS.apply(b.getType()))) != null) {
            renderer.renderModel(poseStack.last(), builder, null, model, 1.0f, 1.0f, 1.0f, light, overlay);
        } else {
            Supplementaries.error("Book model not found", new Object[0]);
        }
        poseStack.popPose();
        if (builder instanceof BakedQuadBuilder) {
            BakedQuadBuilder ac = (BakedQuadBuilder)builder;
            try {
                ac.close();
            }
            catch (Exception e) {
                Supplementaries.error();
            }
        }
    }
}

