/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.items;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.mehvahdjukaar.moonlight.api.item.IItemDecoratorRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ProjectileWeaponOverlayRenderer
implements IItemDecoratorRenderer {
    private ItemStack clientCurrentAmmo = ItemStack.EMPTY;

    public ItemStack getAmmoForPreview(ItemStack cannon, @Nullable Level world, Player player) {
        if (world != null && world.getGameTime() % 10L == 0L) {
            this.clientCurrentAmmo = ItemStack.EMPTY;
            ItemStack findAmmo = player.getProjectile(cannon);
            if (findAmmo.getItem() != Items.ARROW) {
                this.clientCurrentAmmo = findAmmo;
            }
        }
        return this.clientCurrentAmmo;
    }

    public boolean render(GuiGraphics graphics, Font font, ItemStack stack, int x, int y) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && (player.getMainHandItem() == stack || player.getOffhandItem() == stack)) {
            ItemStack ammo = this.getAmmoForPreview(stack, (Level)Minecraft.getInstance().level, (Player)player);
            ProjectileWeaponOverlayRenderer.renderAmmo(graphics, x, y, ammo);
        }
        return true;
    }

    public static void renderAmmo(GuiGraphics graphics, int x, int y, ItemStack ammo) {
        if (!ammo.isEmpty()) {
            PoseStack poseStack = graphics.pose();
            poseStack.pushPose();
            float xOff = 22.0f;
            float yOff = 8.0f;
            poseStack.translate(-4.0 + (double)((xOff + (float)x) * 0.6f), 4.4 + (double)((yOff + (float)y) * 0.6f), 136.0);
            poseStack.scale(0.4f, 0.4f, 0.4f);
            RenderSystem.applyModelViewMatrix();
            graphics.renderFakeItem(ammo, x, y);
            poseStack.popPose();
            RenderSystem.applyModelViewMatrix();
        }
    }
}

