/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mehvahdjukaar.moonlight.api.client.util.RotHlpr;
import net.mehvahdjukaar.moonlight.api.client.util.VertexUtil;
import net.mehvahdjukaar.supplementaries.client.ModMaterials;
import net.mehvahdjukaar.supplementaries.client.renderers.color.ColorHelper;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;

public class VertexModels {
    public static int setColorForAge(float age, float phase) {
        float a = (age + phase) % 1.0f;
        float[] col = ColorHelper.getBubbleColor(a);
        return FastColor.ARGB32.color((int)255, (int)((int)(col[0] * 255.0f)), (int)((int)(col[1] * 255.0f)), (int)((int)(col[2] * 255.0f)));
    }

    public static void renderBubble(VertexConsumer builder, PoseStack poseStack, int combinedLightIn, BlockPos pos, Level level, float partialTicks) {
        TextureAtlasSprite sprite = ModMaterials.BUBBLE_BLOCK_MATERIAL.sprite();
        builder = sprite.wrap(builder);
        int lu = VertexUtil.lightU((int)combinedLightIn);
        int lv = VertexUtil.lightV((int)combinedLightIn);
        float minU = 0.0f;
        float minV = 0.0f;
        float maxU = 1.0f;
        float maxV = 1.0f;
        float w = 1.0f;
        long t = level == null ? System.currentTimeMillis() / 50L : level.getGameTime();
        float time = ((float)Math.floorMod((long)pos.getX() * 7L + (long)pos.getY() * 9L + (long)pos.getZ() * 13L + t, 100L) + partialTicks) / 100.0f;
        int cUnw = VertexModels.setColorForAge(time, 0.0f);
        int cUne = VertexModels.setColorForAge(time, 0.15f);
        int cUse = VertexModels.setColorForAge(time, 0.55f);
        int cUsw = VertexModels.setColorForAge(time, 0.35f);
        int cDnw = VertexModels.setColorForAge(time, 0.45f);
        int cDne = VertexModels.setColorForAge(time, 0.85f);
        int cDse = VertexModels.setColorForAge(time, 1.0f);
        int cDsw = VertexModels.setColorForAge(time, 0.65f);
        float amp = (float)(ClientConfigs.Blocks.BUBBLE_BLOCK_WOBBLE.get() / 10.0);
        w -= 2.0f * amp;
        float unw = amp * Mth.cos((float)((float)Math.PI * 2 * (time + 0.0f)));
        float une = amp * Mth.cos((float)((float)Math.PI * 2 * (time + 0.25f)));
        float use = amp * Mth.cos((float)((float)Math.PI * 2 * (time + 0.5f)));
        float usw = amp * Mth.cos((float)((float)Math.PI * 2 * (time + 0.75f)));
        float dnw = use;
        float dne = usw;
        float dse = unw;
        float dsw = une;
        float l = w / 2.0f;
        VertexModels.vert(builder, poseStack, -l - usw, l + usw, l + usw, minU, maxV, cUsw, lu, lv, 0.0f, 1.0f, 0.0f);
        VertexModels.vert(builder, poseStack, l + use, l + use, l + use, maxU, maxV, cUse, lu, lv, 0.0f, 1.0f, 0.0f);
        VertexModels.vert(builder, poseStack, l + une, l + une, -l - une, maxU, minV, cUne, lu, lv, 0.0f, 1.0f, 0.0f);
        VertexModels.vert(builder, poseStack, -l - unw, l + unw, -l - unw, minU, minV, cUnw, lu, lv, 0.0f, 1.0f, 0.0f);
        VertexModels.vert(builder, poseStack, -l - dnw, -l - dnw, -l - dnw, minU, maxV, cDnw, lu, lv, 0.0f, -1.0f, 0.0f);
        VertexModels.vert(builder, poseStack, l + dne, -l - dne, -l - dne, maxU, maxV, cDne, lu, lv, 0.0f, -1.0f, 0.0f);
        VertexModels.vert(builder, poseStack, l + dse, -l - dse, l + dse, maxU, minV, cDse, lu, lv, 0.0f, -1.0f, 0.0f);
        VertexModels.vert(builder, poseStack, -l - dsw, -l - dsw, l + dsw, minU, minV, cDsw, lu, lv, 0.0f, -1.0f, 0.0f);
        VertexModels.vert(builder, poseStack, l + dne, -l - dne, -l - dne, minU, maxV, cDne, lu, lv, 0.0f, 0.0f, -1.0f);
        VertexModels.vert(builder, poseStack, -l - dnw, -l - dnw, -l - dnw, maxU, maxV, cDnw, lu, lv, 0.0f, 0.0f, -1.0f);
        VertexModels.vert(builder, poseStack, -l - unw, l + unw, -l - unw, maxU, minV, cUnw, lu, lv, 0.0f, 0.0f, -1.0f);
        VertexModels.vert(builder, poseStack, l + une, l + une, -l - une, minU, minV, cUne, lu, lv, 0.0f, 0.0f, -1.0f);
        VertexModels.vert(builder, poseStack, -l - dnw, -l - dnw, -l - dnw, minU, maxV, cDnw, lu, lv, -1.0f, 0.0f, 0.0f);
        VertexModels.vert(builder, poseStack, -l - dsw, -l - dsw, l + dsw, maxU, maxV, cDsw, lu, lv, -1.0f, 0.0f, 0.0f);
        VertexModels.vert(builder, poseStack, -l - usw, l + usw, l + usw, maxU, minV, cUsw, lu, lv, -1.0f, 0.0f, 0.0f);
        VertexModels.vert(builder, poseStack, -l - unw, l + unw, -l - unw, minU, minV, cUnw, lu, lv, -1.0f, 0.0f, 0.0f);
        VertexModels.vert(builder, poseStack, -l - dsw, -l - dsw, l + dsw, minU, maxV, cDsw, lu, lv, 0.0f, 0.0f, 1.0f);
        VertexModels.vert(builder, poseStack, l + dse, -l - dse, l + dse, maxU, maxV, cDse, lu, lv, 0.0f, 0.0f, 1.0f);
        VertexModels.vert(builder, poseStack, l + use, l + use, l + use, maxU, minV, cUse, lu, lv, 0.0f, 0.0f, 1.0f);
        VertexModels.vert(builder, poseStack, -l - usw, l + usw, l + usw, minU, minV, cUsw, lu, lv, 0.0f, 0.0f, 1.0f);
        VertexModels.vert(builder, poseStack, l + dse, -l - dse, l + dse, minU, maxV, cDse, lu, lv, 1.0f, 0.0f, 0.0f);
        VertexModels.vert(builder, poseStack, l + dne, -l - dne, -l - dne, maxU, maxV, cDne, lu, lv, 1.0f, 0.0f, 0.0f);
        VertexModels.vert(builder, poseStack, l + une, l + une, -l - une, maxU, minV, cUne, lu, lv, 1.0f, 0.0f, 0.0f);
        VertexModels.vert(builder, poseStack, l + use, l + use, l + use, minU, minV, cUse, lu, lv, 1.0f, 0.0f, 0.0f);
    }

    public static void vert(VertexConsumer builder, PoseStack poseStack, float x, float y, float z, float u, float v, int color, int lu, int lv, float nx, float ny, float nz) {
        builder.addVertex(poseStack.last(), x, y, z);
        builder.setColor(color);
        builder.setUv(u, v);
        builder.setUv1(0, 10);
        builder.setUv2(lu, lv);
        builder.setNormal(poseStack.last(), nx, ny, nz);
    }

    public static void renderFish(MultiBufferSource buffers, PoseStack poseStack, float wo, float ho, int fishType, int combinedLightIn) {
        int textW = 64;
        int textH = 32;
        int fishW = 5;
        int fishH = 4;
        int fishv = --fishType % (textH / fishH);
        int fishu = fishType / (textH / fishH);
        VertexConsumer builder = ModMaterials.FISHIES.buffer(buffers, RenderType::entityCutout);
        float w = (float)fishW / (float)textW;
        float h = (float)fishH / (float)textH;
        float hw = 4.0f * w / 2.0f;
        float hh = 2.0f * h / 2.0f;
        int lu = VertexUtil.lightU((int)combinedLightIn);
        int lv = VertexUtil.lightV((int)combinedLightIn);
        float minu = (float)(0 * fishu) * w;
        float minv = (float)(0 * fishv) * h;
        float maxu = 1.0f * w + minu;
        float maxv = 1.0f * h + minv;
        for (int k = 0; k < 2; ++k) {
            for (int j = 0; j < 2; ++j) {
                VertexUtil.vert((VertexConsumer)builder, (PoseStack)poseStack, (float)(hw - Math.abs(wo / 2.0f)), (float)(-hh + ho), (float)wo, (float)minu, (float)maxv, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (int)lu, (int)lv, (float)0.0f, (float)1.0f, (float)0.0f);
                VertexUtil.vert((VertexConsumer)builder, (PoseStack)poseStack, (float)(-hw + Math.abs(wo / 2.0f)), (float)(-hh + ho), (float)(-wo), (float)maxu, (float)maxv, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (int)lu, (int)lv, (float)0.0f, (float)1.0f, (float)0.0f);
                VertexUtil.vert((VertexConsumer)builder, (PoseStack)poseStack, (float)(-hw + Math.abs(wo / 2.0f)), (float)(hh + ho), (float)(-wo), (float)maxu, (float)minv, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (int)lu, (int)lv, (float)0.0f, (float)1.0f, (float)0.0f);
                VertexUtil.vert((VertexConsumer)builder, (PoseStack)poseStack, (float)(hw - Math.abs(wo / 2.0f)), (float)(hh + ho), (float)wo, (float)minu, (float)minv, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (int)lu, (int)lv, (float)0.0f, (float)1.0f, (float)0.0f);
                poseStack.mulPose(RotHlpr.Y180);
                float temp = minu;
                minu = maxu;
                maxu = temp;
            }
            lu = 240;
            minu += 0.5f;
            maxu += 0.5f;
        }
    }
}

