/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivemetalworks.common.menu;

import cy.jdkdigital.productivelib.container.AbstractContainer;
import cy.jdkdigital.productivelib.container.ManualSlotItemHandler;
import cy.jdkdigital.productivemetalworks.common.block.entity.FoundryControllerBlockEntity;
import cy.jdkdigital.productivemetalworks.registry.MetalworksRegistrator;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class FoundryControllerContainer
extends AbstractContainer {
    public static int COLUMNS = 5;
    private final Inventory playerInventory;
    public final FoundryControllerBlockEntity blockEntity;

    public FoundryControllerContainer(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, FoundryControllerContainer.getBlockEntity(playerInventory, data));
    }

    public FoundryControllerContainer(int windowId, Inventory playerInventory, final FoundryControllerBlockEntity blockEntity) {
        super((MenuType)MetalworksRegistrator.FOUNDRY_CONTROLLER_CONTAINER.get(), windowId);
        this.playerInventory = playerInventory;
        this.blockEntity = blockEntity;
        this.addDataSlots(new ContainerData(){

            public int get(int i) {
                FluidStack fuel = blockEntity.getFuel();
                return i == 0 ? BuiltInRegistries.FLUID.getId((Object)fuel.getFluid()) : fuel.getAmount();
            }

            public void set(int i, int value) {
                switch (i) {
                    case 0: {
                        blockEntity.fuel = new FluidStack((Fluid)BuiltInRegistries.FLUID.byId(value), 1);
                    }
                    case 1: {
                        blockEntity.fuel.setAmount(value);
                    }
                }
            }

            public int getCount() {
                return 2;
            }
        });
        this.addDataSlots(new ContainerData(){

            public int get(int i) {
                FluidStack fluid = blockEntity.fluidHandler.getFluidInTank(i);
                return !fluid.isEmpty() ? BuiltInRegistries.FLUID.getId((Object)fluid.getFluid()) : 0;
            }

            public void set(int i, int value) {
                FluidStack fluid = blockEntity.fluidHandler.getFluidInTank(i);
                if (fluid.isEmpty()) {
                    blockEntity.fluidHandler.fill(new FluidStack((Fluid)BuiltInRegistries.FLUID.byId(value), 1), IFluidHandler.FluidAction.EXECUTE);
                }
            }

            public int getCount() {
                return 20;
            }
        });
        this.addDataSlots(new ContainerData(){

            public int get(int i) {
                return blockEntity.fluidHandler.getFluidInTank(i).getAmount();
            }

            public void set(int i, int value) {
                blockEntity.fluidHandler.getFluidInTank(i).setAmount(value);
            }

            public int getCount() {
                return 20;
            }
        });
        int rowCount = this.calculateRowCount(1);
        int leftover = this.blockEntity.getItemHandler().getSlots() % COLUMNS;
        if (rowCount > 0) {
            this.addSlotBox(this.blockEntity.getItemHandler(), 0, 80, 17, COLUMNS, 18, rowCount, 18);
        }
        this.addSlotRange(this.blockEntity.getItemHandler(), rowCount * 5, 80, 17 + rowCount * 18, leftover, 18);
        this.layoutPlayerInventorySlots(playerInventory, 0, 8, 84);
    }

    private static FoundryControllerBlockEntity getBlockEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null!");
        Objects.requireNonNull(data, "data cannot be null!");
        BlockEntity blockEntity = playerInventory.player.level().getBlockEntity(data.readBlockPos());
        if (blockEntity instanceof FoundryControllerBlockEntity) {
            FoundryControllerBlockEntity blockEntity2 = (FoundryControllerBlockEntity)blockEntity;
            return blockEntity2;
        }
        throw new IllegalStateException("Block entity is not correct for Foundry Controller Container!");
    }

    public boolean stillValid(@Nonnull Player player) {
        return (Boolean)this.blockEntity.getBlockState().getValue((Property)BlockStateProperties.ATTACHED) != false && this.blockEntity.getMultiblockData() != null && player.distanceToSqr((double)this.blockEntity.getBlockPos().getX() + 0.5, (double)this.blockEntity.getBlockPos().getY() + 0.5, (double)this.blockEntity.getBlockPos().getZ() + 0.5) <= 64.0 && !this.blockEntity.isRemoved();
    }

    protected BlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    public float subtractInputFromScroll(float scrollOffs, double input) {
        return Mth.clamp((float)(scrollOffs - (float)(input / (double)this.calculateRowCount(0))), (float)0.0f, (float)1.0f);
    }

    public void scrollTo(float scrollOffs) {
        int offsetRow = this.getRowIndexForScroll(scrollOffs);
        this.slots.forEach(slot -> {
            ManualSlotItemHandler mSlot;
            if (slot instanceof ManualSlotItemHandler && (mSlot = (ManualSlotItemHandler)slot).getItemHandler().equals((Object)this.blockEntity.getItemHandler())) {
                if (slot.index < offsetRow * COLUMNS || slot.index > offsetRow * COLUMNS + 14) {
                    mSlot.disable();
                } else {
                    mSlot.enable();
                }
                slot.y = Math.floorDiv(slot.index, COLUMNS) * 18 - offsetRow * 18 + 17;
            }
        });
    }

    public int calculateRowCount(int offset) {
        return Mth.positiveCeilDiv((int)(this.blockEntity.getItemHandler().getSlots() - offset * COLUMNS), (int)COLUMNS);
    }

    public int getRowIndexForScroll(float scrollOffs) {
        return Math.max((int)((double)(scrollOffs * (float)this.calculateRowCount(3)) + 0.5), 0);
    }
}

