/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivemetalworks.common.block.entity;

import com.mojang.datafixers.util.Pair;
import cy.jdkdigital.productivelib.common.block.entity.FluidTankBlockEntity;
import cy.jdkdigital.productivelib.common.block.entity.IMultiBlockControllerBlockEntity;
import cy.jdkdigital.productivelib.exception.InvalidStructureException;
import cy.jdkdigital.productivelib.util.MultiBlockDetector;
import cy.jdkdigital.productivelib.util.MultiFluidTank;
import cy.jdkdigital.productivemetalworks.Config;
import cy.jdkdigital.productivemetalworks.common.block.entity.FoundryTankBlockEntity;
import cy.jdkdigital.productivemetalworks.common.datamap.EntityMeltingMap;
import cy.jdkdigital.productivemetalworks.common.datamap.FuelMap;
import cy.jdkdigital.productivemetalworks.common.menu.FoundryControllerContainer;
import cy.jdkdigital.productivemetalworks.recipe.FluidAlloyingRecipe;
import cy.jdkdigital.productivemetalworks.recipe.ItemMeltingRecipe;
import cy.jdkdigital.productivemetalworks.registry.MetalworksRegistrator;
import cy.jdkdigital.productivemetalworks.registry.ModTags;
import cy.jdkdigital.productivemetalworks.util.RecipeHelper;
import cy.jdkdigital.productivemetalworks.util.TickingSlotInventoryHandler;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FoundryControllerBlockEntity
extends FluidTankBlockEntity
implements IMultiBlockControllerBlockEntity,
MenuProvider {
    private MultiBlockDetector.MultiBlockData foundryData;
    private int tickCounter = 0;
    private float leftoverTick = 0.0f;
    public FluidStack fuel = FluidStack.EMPTY;
    public MultiFluidTank fluidHandler = new MultiFluidTank(20, 90000){

        protected void onContentsChanged(boolean hasChangedFluid) {
            Level level;
            super.onContentsChanged(hasChangedFluid);
            if (hasChangedFluid && (level = FoundryControllerBlockEntity.this.level) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                FoundryControllerBlockEntity.this.sync((Level)serverLevel);
            }
            FoundryControllerBlockEntity.this.setChanged();
        }
    };
    protected TickingSlotInventoryHandler itemHandler = new TickingSlotInventoryHandler(200, (BlockEntity)this){

        @Override
        protected int getTimeInSlot(ItemStack stack) {
            Level pLevel;
            RecipeHolder<ItemMeltingRecipe> recipe;
            Level level;
            if (this.blockEntity != null && (level = this.blockEntity.getLevel()) instanceof Level && (recipe = RecipeHelper.getItemMeltingRecipe(pLevel = level, stack)) != null) {
                return ((ItemMeltingRecipe)recipe.value()).result.stream().map(FluidStack::getAmount).reduce(Integer::sum).orElse(0);
            }
            return 0;
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        public boolean isInputSlotItem(int slot, ItemStack item) {
            return true;
        }

        public boolean isInputSlot(int slot) {
            return true;
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return true;
        }

        public int[] getOutputSlots() {
            return new int[0];
        }

        protected void onContentsChanged(int slot) {
            Level level = FoundryControllerBlockEntity.this.level;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                FoundryControllerBlockEntity.this.sync((Level)serverLevel);
            }
        }
    };

    public FoundryControllerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)MetalworksRegistrator.FOUNDRY_CONTROLLER_BLOCK_ENTITY.get(), pos, state);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, FoundryControllerBlockEntity blockEntity) {
        if (blockEntity.getMultiblockData() != null) {
            FuelMap fuelData;
            FluidStack fuel;
            MultiBlockDetector.MultiBlockData mb = blockEntity.getMultiblockData();
            FluidTankBlockEntity.tick((Level)level, (BlockPos)pos, (BlockState)state, (FluidTankBlockEntity)blockEntity);
            if (blockEntity.tickCounter % 20 == 0 && (Config.foundryCollectItems || Config.foundryDamageEntities)) {
                BlockPos c1 = ((BlockPos)mb.topCorners().getFirst()).below(mb.height() - 1);
                BlockPos c2 = ((BlockPos)mb.topCorners().getSecond()).below(mb.height() - 2);
                level.getEntities(null, new AABB((double)c1.getX(), (double)c1.getY(), (double)c1.getZ(), (double)c2.getX(), (double)c2.getY(), (double)c2.getZ())).forEach(entity -> {
                    if (Config.foundryCollectItems && entity instanceof ItemEntity) {
                        ItemEntity item = (ItemEntity)entity;
                        ItemStack groundStack = item.getItem();
                        for (int slot = 0; slot < blockEntity.itemHandler.getSlots(); ++slot) {
                            if (!blockEntity.itemHandler.getItem(slot).isEmpty()) continue;
                            blockEntity.itemHandler.setStackInSlot(slot, new ItemStack((ItemLike)groundStack.getItem(), 1));
                            groundStack.shrink(1);
                        }
                    }
                    if (Config.foundryDamageEntities && entity instanceof LivingEntity) {
                        LivingEntity livingEntity = (LivingEntity)entity;
                        if (blockEntity.getFluidHandler().totalFluidAmount() > 0) {
                            livingEntity.hurt(level.damageSources().hotFloor(), 2.0f);
                            EntityMeltingMap meltingFluid = (EntityMeltingMap)livingEntity.getType().builtInRegistryHolder().getData(MetalworksRegistrator.ENTITY_MELTING_MAP);
                            if (meltingFluid != null) {
                                blockEntity.fluidHandler.fill(meltingFluid.fluid(), IFluidHandler.FluidAction.EXECUTE);
                            }
                        }
                    }
                });
            }
            if (!(fuel = blockEntity.getFuel()).isEmpty() && (fuelData = (FuelMap)fuel.getFluid().builtInRegistryHolder().getData(MetalworksRegistrator.FUEL_MAP)) != null) {
                RecipeHolder<ItemMeltingRecipe> recipe;
                int burnTicks = Math.round(fuelData.speed() + blockEntity.leftoverTick);
                blockEntity.leftoverTick = fuelData.speed() + blockEntity.leftoverTick - (float)burnTicks;
                blockEntity.itemHandler.tick(burnTicks);
                boolean hasChanged = false;
                FluidStack consumedFuel = new FluidStack(fuel.getFluid(), 0);
                for (int slot = 0; slot < blockEntity.itemHandler.size(); ++slot) {
                    int totalProducedFluid;
                    ItemStack item;
                    Pair<Integer, Integer> ticker = blockEntity.itemHandler.getTicker(slot);
                    if ((Integer)ticker.getSecond() <= 0 || (Integer)ticker.getFirst() != 0 || (item = blockEntity.getItemHandler().getStackInSlot(slot)).isEmpty() || (recipe = RecipeHelper.getItemMeltingRecipe(level, item)) == null || (totalProducedFluid = ((ItemMeltingRecipe)recipe.value()).result.stream().map(FluidStack::getAmount).reduce(Integer::sum).orElse(0).intValue()) + consumedFuel.getAmount() > fuel.getAmount() || totalProducedFluid > blockEntity.fluidHandler.getCapacity() - blockEntity.fluidHandler.totalFluidAmount()) continue;
                    consumedFuel.grow((int)((float)totalProducedFluid * fuelData.consumption()));
                    blockEntity.itemHandler.extractItem(slot, 1, false, false);
                    hasChanged = true;
                    for (FluidStack fluidStack : ((ItemMeltingRecipe)recipe.value()).result) {
                        if (blockEntity.fluidHandler.fill(fluidStack, IFluidHandler.FluidAction.SIMULATE) != fluidStack.getAmount()) continue;
                        blockEntity.fluidHandler.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
                    }
                }
                if (hasChanged) {
                    if (!consumedFuel.isEmpty()) {
                        for (BlockPos blockPos : mb.peripherals()) {
                            if (consumedFuel.isEmpty() || !((recipe = level.getBlockEntity(blockPos)) instanceof FoundryTankBlockEntity)) continue;
                            FoundryTankBlockEntity tankBlockEntity = (FoundryTankBlockEntity)recipe;
                            FluidStack drainedFluid = tankBlockEntity.getFluidHandler().drain(consumedFuel, IFluidHandler.FluidAction.EXECUTE);
                            consumedFuel.shrink(drainedFluid.getAmount());
                        }
                    }
                    blockEntity.sync(level);
                }
            }
        }
        if (++blockEntity.tickCounter % 200 == 0) {
            blockEntity.tickCounter = 0;
            try {
                MultiBlockDetector.MultiBlockData foundryData = MultiBlockDetector.detectStructure((Level)level, (BlockPos)pos, ModTags.Blocks.FOUNDRY_WALL_BLOCKS, ModTags.Blocks.FOUNDRY_BOTTOM_BLOCKS, (boolean)true, (boolean)true, (int)Config.foundryMaxVolume, (int)Config.foundryMaxCircumference, (int)Config.foundryMaxHeight);
                blockEntity.setMultiBlockData(foundryData);
            }
            catch (InvalidStructureException e) {
                blockEntity.setMultiBlockData(null);
            }
        }
    }

    public static void clientTick(Level level, BlockPos blockPos, BlockState blockState, FoundryControllerBlockEntity blockEntity) {
        FuelMap fuelData;
        FluidStack fuel = blockEntity.getFuel();
        if (!fuel.isEmpty() && (fuelData = (FuelMap)fuel.getFluid().builtInRegistryHolder().getData(MetalworksRegistrator.FUEL_MAP)) != null) {
            int burnTicks = Math.round(fuelData.speed() + blockEntity.leftoverTick);
            blockEntity.leftoverTick = fuelData.speed() + blockEntity.leftoverTick - (float)burnTicks;
            blockEntity.itemHandler.tick(burnTicks);
        }
    }

    public void tickFluidTank(Level level, BlockPos blockPos, BlockState blockState, FluidTankBlockEntity fluidTankBlockEntity) {
        List<RecipeHolder<FluidAlloyingRecipe>> recipeProcessList = RecipeHelper.getAlloyRecipes(level, this.fluidHandler);
        recipeProcessList.forEach(fluidAlloyingRecipe -> {
            int speed = ((FluidAlloyingRecipe)fluidAlloyingRecipe.value()).speed;
            boolean canDrainFullSpeed = ((FluidAlloyingRecipe)fluidAlloyingRecipe.value()).fluids.stream().map(f -> new SizedFluidIngredient(f.ingredient(), f.amount() * speed)).noneMatch(fluid -> this.fluidHandler.drain(fluid, IFluidHandler.FluidAction.SIMULATE).isEmpty());
            if (canDrainFullSpeed && this.fluidHandler.fill(new FluidStack(((FluidAlloyingRecipe)fluidAlloyingRecipe.value()).result.getFluid(), ((FluidAlloyingRecipe)fluidAlloyingRecipe.value()).result.getAmount() * speed), IFluidHandler.FluidAction.SIMULATE) > 0) {
                ((FluidAlloyingRecipe)fluidAlloyingRecipe.value()).fluids.forEach(fluid -> this.fluidHandler.drain(fluid, IFluidHandler.FluidAction.EXECUTE));
                this.fluidHandler.fill(((FluidAlloyingRecipe)fluidAlloyingRecipe.value()).result, IFluidHandler.FluidAction.EXECUTE);
            } else {
                boolean canDrain = ((FluidAlloyingRecipe)fluidAlloyingRecipe.value()).fluids.stream().noneMatch(fluid -> this.fluidHandler.drain(fluid, IFluidHandler.FluidAction.SIMULATE).isEmpty());
                if (canDrain && this.fluidHandler.fill(((FluidAlloyingRecipe)fluidAlloyingRecipe.value()).result, IFluidHandler.FluidAction.SIMULATE) > 0) {
                    ((FluidAlloyingRecipe)fluidAlloyingRecipe.value()).fluids.forEach(fluid -> this.fluidHandler.drain(fluid, IFluidHandler.FluidAction.EXECUTE));
                    this.fluidHandler.fill(((FluidAlloyingRecipe)fluidAlloyingRecipe.value()).result, IFluidHandler.FluidAction.EXECUTE);
                }
            }
        });
    }

    public int tankTickRate() {
        return 1;
    }

    public IItemHandler getItemHandler() {
        return this.itemHandler;
    }

    public MultiFluidTank getFluidHandler() {
        return this.fluidHandler;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return new FoundryControllerContainer(i, inventory, this);
    }

    public void savePacketNBT(CompoundTag tag, HolderLookup.Provider provider) {
        super.savePacketNBT(tag, provider);
        if (this.getMultiblockData() != null) {
            tag.put("multiData", this.getMultiblockData().serializeNBT(provider));
        }
    }

    public void loadPacketNBT(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadPacketNBT(tag, provider);
        if (tag.contains("multiData")) {
            MultiBlockDetector.MultiBlockData data = new MultiBlockDetector.MultiBlockData(null, null, List.of(), 0, 0);
            data.deserializeNBT(provider, Objects.requireNonNull(tag.get("multiData")));
            this.setMultiBlockData(data);
        }
    }

    public FluidStack getFuel() {
        MultiBlockDetector.MultiBlockData mb = this.getMultiblockData();
        if (this.level != null && mb != null) {
            FluidStack fuel = FluidStack.EMPTY;
            for (BlockPos pos : mb.peripherals()) {
                FoundryTankBlockEntity tank;
                FluidStack fluid;
                BlockEntity blockEntity = this.level.getBlockEntity(pos);
                if (!(blockEntity instanceof FoundryTankBlockEntity) || (fluid = (tank = (FoundryTankBlockEntity)blockEntity).getFluidHandler().getFluidInTank(0)).isEmpty()) continue;
                if (fuel.isEmpty()) {
                    fuel = fluid.copy();
                    continue;
                }
                if (!fuel.is(fluid.getFluid())) continue;
                fuel.grow(fluid.getAmount());
            }
            return fuel;
        }
        return FluidStack.EMPTY;
    }

    public void setMultiBlockData(MultiBlockDetector.MultiBlockData multiBlockData) {
        ServerLevel serverLevel;
        Level level = this.level;
        if (level instanceof ServerLevel) {
            serverLevel = (ServerLevel)level;
            if (multiBlockData != null) {
                this.fluidHandler.setCapacity(multiBlockData.volume() * Config.foundryFluidCapacityPerBlockVolume);
                this.itemHandler.setSize(multiBlockData.volume());
                if (!((Boolean)this.getBlockState().getValue((Property)BlockStateProperties.ATTACHED)).booleanValue()) {
                    serverLevel.setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)BlockStateProperties.ATTACHED, (Comparable)Boolean.valueOf(true)));
                }
                BlockPos c1 = ((BlockPos)multiBlockData.topCorners().getFirst()).below(multiBlockData.height());
                BlockPos c2 = ((BlockPos)multiBlockData.topCorners().getSecond()).below(multiBlockData.height());
                BlockPos.betweenClosed((BlockPos)c1, (BlockPos)c2).forEach(blockPos -> {
                    BlockState state = serverLevel.getBlockState(blockPos);
                    if (state.is(ModTags.Blocks.HEATING_COILS) && !((Boolean)state.getValue((Property)BlockStateProperties.ATTACHED)).booleanValue()) {
                        serverLevel.setBlockAndUpdate(blockPos, (BlockState)state.setValue((Property)BlockStateProperties.ATTACHED, (Comparable)Boolean.valueOf(true)));
                    }
                });
            } else if (((Boolean)this.getBlockState().getValue((Property)BlockStateProperties.ATTACHED)).booleanValue()) {
                serverLevel.setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)BlockStateProperties.ATTACHED, (Comparable)Boolean.valueOf(false)));
            }
        } else {
            this.fluidHandler.setCapacity(multiBlockData.volume() * Config.foundryFluidCapacityPerBlockVolume);
            this.itemHandler.setSize(multiBlockData.volume());
        }
        level = this.level;
        if (level instanceof ServerLevel) {
            serverLevel = (ServerLevel)level;
            if (this.foundryData != multiBlockData || multiBlockData != null) {
                this.sync((Level)serverLevel);
            }
        }
        this.foundryData = multiBlockData;
        this.setChanged();
    }

    public MultiBlockDetector.MultiBlockData getMultiblockData() {
        return this.foundryData;
    }

    public void sync(Level level) {
        level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
    }

    public void moveTankFirst(int tank) {
        if (tank > 0 && tank < this.fluidHandler.getTanks()) {
            this.fluidHandler.moveTankToTop(tank);
            this.sync(this.level);
        }
    }
}

