/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivemetalworks.common.block;

import com.mojang.serialization.MapCodec;
import cy.jdkdigital.productivemetalworks.common.block.entity.CastingBlockEntity;
import cy.jdkdigital.productivemetalworks.registry.MetalworksRegistrator;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CastingTableBlock
extends BaseEntityBlock {
    public static final MapCodec<CastingTableBlock> CODEC = CastingTableBlock.simpleCodec(CastingTableBlock::new);
    private static final VoxelShape INSIDE1 = CastingTableBlock.box((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)12.0, (double)16.0);
    private static final VoxelShape INSIDE2 = CastingTableBlock.box((double)0.0, (double)0.0, (double)3.0, (double)0.0, (double)12.0, (double)13.0);
    protected static final VoxelShape SHAPE = Shapes.join((VoxelShape)Shapes.block(), (VoxelShape)Shapes.or((VoxelShape)INSIDE1, (VoxelShape)INSIDE2), (BooleanOp)BooleanOp.ONLY_FIRST);

    public CastingTableBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nonnull
    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockStateBuilder) {
        blockStateBuilder.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new CastingBlockEntity(pos, state);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)pContext.getHorizontalDirection().getOpposite());
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return CastingTableBlock.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)MetalworksRegistrator.CASTING_BLOCK_ENTITY.get()), (BlockEntityTicker)(level.isClientSide ? CastingBlockEntity::clientTick : CastingBlockEntity::serverTick));
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        ServerLevel serverLevel;
        BlockEntity blockEntity;
        if (level instanceof ServerLevel && (blockEntity = (serverLevel = (ServerLevel)level).getBlockEntity(pos)) instanceof CastingBlockEntity) {
            CastingBlockEntity blockEntity2 = (CastingBlockEntity)blockEntity;
            ItemStack itemInHand = player.getItemInHand(InteractionHand.MAIN_HAND);
            ItemStack outputItem = blockEntity2.getItemHandler().getStackInSlot(0);
            if (outputItem.isEmpty()) {
                outputItem = blockEntity2.castInv.getStackInSlot(0);
            }
            if (!outputItem.isEmpty() && (itemInHand.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)itemInHand, (ItemStack)outputItem) && itemInHand.getCount() < itemInHand.getMaxStackSize()) && blockEntity2.getFluidHandler().getFluidAmount() == 0 && !blockEntity2.isCooling() && !outputItem.isEmpty()) {
                if (itemInHand.isEmpty()) {
                    player.setItemInHand(InteractionHand.MAIN_HAND, outputItem.copy());
                } else {
                    itemInHand.grow(outputItem.getCount());
                }
                outputItem.shrink(outputItem.getMaxStackSize());
                blockEntity2.sync(serverLevel);
            }
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        CastingBlockEntity blockEntity;
        BlockEntity blockEntity2 = level.getBlockEntity(pos);
        if (blockEntity2 instanceof CastingBlockEntity && (blockEntity = (CastingBlockEntity)blockEntity2).canAcceptCast()) {
            boolean isTable = state.is(MetalworksRegistrator.CASTING_TABLE);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (!isTable || !(stack.getItem() instanceof BlockItem)) {
                    ItemStack clonedStack = stack.copy();
                    clonedStack.setCount(1);
                    blockEntity.castInv.insertItem(0, clonedStack, false);
                    stack.shrink(1);
                    blockEntity.sync(serverLevel);
                }
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    public void onRemove(BlockState oldState, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (oldState.getBlock() != newState.getBlock() && (blockEntity = level.getBlockEntity(pos)) instanceof CastingBlockEntity) {
            CastingBlockEntity blockEntity2 = (CastingBlockEntity)blockEntity;
            if (!blockEntity2.isCooling()) {
                for (int slot = 0; slot < blockEntity2.getItemHandler().getSlots(); ++slot) {
                    Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)blockEntity2.getItemHandler().getStackInSlot(slot));
                }
            }
            for (int slot = 0; slot < blockEntity2.castInv.getSlots(); ++slot) {
                Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)blockEntity2.castInv.getStackInSlot(slot));
            }
        }
        super.onRemove(oldState, level, pos, newState, isMoving);
    }
}

