/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.justzoom.mixin.mixins.common.client;

import de.keksuccino.justzoom.ZoomHandler;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.world.entity.Entity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={GameRenderer.class})
public class MixinGameRenderer {
    @Shadow
    private float fov;
    @Shadow
    private float oldFov;

    @Inject(method={"getFov"}, at={@At(value="RETURN")}, cancellable=true)
    private void return_getFov_JustZoom(Camera c, float partial, boolean useFOVSetting, CallbackInfoReturnable<Double> info) {
        if (ZoomHandler.isZooming()) {
            double normalFov = (Double)info.getReturnValue();
            if (normalFov > 170.0) {
                normalFov = 170.0;
            }
            if (normalFov < 1.0) {
                normalFov = 1.0;
            }
            double modifiedFov = normalFov;
            ZoomHandler.cachedNormalFov = normalFov;
            if ((modifiedFov *= (double)ZoomHandler.getFovModifier()) > 170.0) {
                modifiedFov = 170.0;
            }
            if (modifiedFov < 1.0) {
                modifiedFov = 1.0;
            }
            ZoomHandler.cachedModifiedFov = modifiedFov;
            if (!ZoomHandler.shouldZoomInOutSmooth()) {
                info.setReturnValue((Object)modifiedFov);
            } else {
                info.setReturnValue((Object)normalFov);
            }
        }
    }

    @Inject(method={"tickFov"}, at={@At(value="HEAD")}, cancellable=true)
    private void head_tickFov_JustZoom(CallbackInfo info) {
        if (ZoomHandler.isZooming()) {
            info.cancel();
            float f = 1.0f;
            Entity entity = Minecraft.getInstance().getCameraEntity();
            if (entity instanceof AbstractClientPlayer) {
                AbstractClientPlayer abstractclientplayer = (AbstractClientPlayer)entity;
                f = abstractclientplayer.getFieldOfViewModifier();
            }
            this.oldFov = this.fov;
            this.fov += (f - this.fov) * 0.5f;
        }
    }
}

