/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.bucketlib.api.crafting;

import com.mojang.serialization.Decoder;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapDecoder;
import com.mojang.serialization.MapEncoder;
import de.cech12.bucketlib.BucketLibMod;
import de.cech12.bucketlib.util.BucketLibUtil;
import java.util.ArrayList;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.common.crafting.IngredientType;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class MilkIngredient
implements ICustomIngredient {
    private ItemStack[] matchingStacks;
    public static final MapCodec<MilkIngredient> CODEC = MapCodec.of((MapEncoder)Encoder.empty(), (MapDecoder)Decoder.unit((Object)new MilkIngredient()));
    public static final IngredientType<MilkIngredient> TYPE = new IngredientType(CODEC);

    public boolean test(@Nonnull ItemStack itemStack) {
        ItemStack container;
        Optional<FluidStack> drainedFluidOptional;
        if (itemStack.isEmpty()) {
            return false;
        }
        if (itemStack.getItem() == Items.MILK_BUCKET) {
            return true;
        }
        ResourceLocation location = BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem());
        if ("mekanism".equals(location.getNamespace()) && itemStack.getCraftingRemainingItem().isEmpty()) {
            return false;
        }
        if (NeoForgeMod.MILK.isBound() && (drainedFluidOptional = FluidUtil.getFluidHandler((ItemStack)(container = itemStack.copyWithCount(1))).map(fluidHandler -> fluidHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE))).isPresent() && !drainedFluidOptional.get().isEmpty()) {
            FluidStack drainedFluid = drainedFluidOptional.get();
            return drainedFluid.getFluid() == NeoForgeMod.MILK.get() && drainedFluid.getAmount() == 1000;
        }
        return BucketLibUtil.containsMilk(itemStack.copy());
    }

    @Nonnull
    public Stream<ItemStack> getItems() {
        if (this.matchingStacks == null) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            stacks.add(new ItemStack((ItemLike)Items.MILK_BUCKET));
            BucketLibMod.getRegisteredBuckets().forEach(universalBucketItem -> {
                if (universalBucketItem.canMilkEntities()) {
                    stacks.add(BucketLibUtil.addMilk(new ItemStack((ItemLike)universalBucketItem)));
                }
            });
            this.matchingStacks = stacks.toArray(new ItemStack[0]);
        }
        return Stream.of(this.matchingStacks);
    }

    public boolean isSimple() {
        return false;
    }

    @Nonnull
    public IngredientType<?> getType() {
        return TYPE;
    }
}

