/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.definitions;

import appeng.core.definitions.ItemDefinition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.pedroksl.advanced_ae.common.definitions.FluidDefinition;
import net.pedroksl.advanced_ae.common.fluids.QuantumInfusionBlock;
import net.pedroksl.advanced_ae.common.fluids.QuantumInfusionFluid;
import net.pedroksl.advanced_ae.common.fluids.QuantumInfusionFluidType;

public class AAEFluids {
    public static final DeferredRegister<FluidType> DR_FLUID_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.FLUID_TYPES, (String)"advanced_ae");
    public static final DeferredRegister<Fluid> DR_FLUIDS = DeferredRegister.create((ResourceKey)Registries.FLUID, (String)"advanced_ae");
    public static final DeferredRegister.Blocks DR_FLUID_BLOCKS = DeferredRegister.createBlocks((String)"advanced_ae");
    public static final DeferredRegister.Items DR_BUCKET_ITEMS = DeferredRegister.createItems((String)"advanced_ae");
    private static final List<FluidDefinition<?, ?>> FLUIDS = new ArrayList();
    public static final FluidDefinition<?, ?> QUANTUM_INFUSION = AAEFluids.fluid("Quantum Infusion", "quantum_infusion", QuantumInfusionFluidType::new, QuantumInfusionFluid.Flowing::new, QuantumInfusionFluid.Source::new, QuantumInfusionBlock::new);

    public static List<FluidDefinition<?, ?>> getFluids() {
        return Collections.unmodifiableList(FLUIDS);
    }

    private static <F extends Fluid, B extends LiquidBlock> FluidDefinition<F, B> fluid(String englishName, String id, Supplier<FluidType> fluidTypeSupplier, Supplier<F> flowingSupplier, Supplier<F> sourceSupplier, Supplier<B> liquidBlockSupplier) {
        DeferredHolder type = DR_FLUID_TYPES.register(id + "_type", fluidTypeSupplier);
        DeferredHolder flowing = DR_FLUIDS.register(id + "_flowing", flowingSupplier);
        DeferredHolder source = DR_FLUIDS.register(id + "_source", sourceSupplier);
        DeferredBlock block = DR_FLUID_BLOCKS.register(id + "_block", liquidBlockSupplier);
        DeferredItem bucketItem = DR_BUCKET_ITEMS.register(id + "_bucket", () -> new BucketItem((Fluid)source.get(), new Item.Properties().craftRemainder(Items.BUCKET).stacksTo(1)));
        ItemDefinition bucketDefinition = new ItemDefinition(englishName + " Bucket", bucketItem);
        FluidDefinition definition = new FluidDefinition(englishName, (DeferredHolder<FluidType, FluidType>)type, flowing, source, block, (ItemDefinition<BucketItem>)bucketDefinition);
        FLUIDS.add(definition);
        return definition;
    }

    public static void init(IEventBus eventBus) {
        DR_FLUID_TYPES.register(eventBus);
        DR_FLUIDS.register(eventBus);
        DR_FLUID_BLOCKS.register(eventBus);
        DR_BUCKET_ITEMS.register(eventBus);
    }
}

