/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.client.gui.widgets;

import appeng.api.stacks.GenericStack;
import appeng.client.gui.AEBaseScreen;
import appeng.core.localization.Tooltips;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.network.PacketDistributor;
import net.pedroksl.advanced_ae.common.definitions.AAEText;
import net.pedroksl.advanced_ae.common.helpers.ColorContainer;
import net.pedroksl.advanced_ae.network.packet.FluidTankItemUsePacket;
import org.apache.commons.lang3.text.WordUtils;
import org.jetbrains.annotations.NotNull;

public class FluidTankSlot
extends AbstractWidget {
    private final AbstractContainerScreen<?> screen;
    private TextureAtlasSprite fluidTexture;
    private FluidStack content = FluidStack.EMPTY;
    private final int maxLevel;
    private boolean disableRender = false;
    private final int index;

    public FluidTankSlot(AbstractContainerScreen<?> screen, int index, int x, int y, int width, int height, int maxLevel, Component message) {
        super(x, y, width, height, message);
        this.maxLevel = maxLevel;
        this.screen = screen;
        this.index = index;
    }

    public void onClick(double mouseX, double mouseY, int button) {
        FluidStack fluidStack;
        IFluidHandlerItem cap;
        ItemStack stack = this.screen.getMenu().getCarried();
        if (!stack.isEmpty() && (cap = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM)) != null && ((fluidStack = cap.getFluidInTank(0)).is(this.content.getFluid()) || fluidStack.isEmpty() || this.content.isEmpty())) {
            AEBaseScreen baseScreen;
            AbstractContainerScreen<?> abstractContainerScreen = this.screen;
            int actualButton = abstractContainerScreen instanceof AEBaseScreen ? ((baseScreen = (AEBaseScreen)abstractContainerScreen).isHandlingRightClick() ? 1 : 0) : button;
            PacketDistributor.sendToServer((CustomPacketPayload)new FluidTankItemUsePacket(this.index, actualButton), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public void playDownSound(@NotNull SoundManager handler) {
    }

    public void playDownSound(SoundManager handler, boolean isInsert) {
        if (isInsert) {
            handler.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.BUCKET_EMPTY, (float)1.0f, (float)1.0f));
        } else {
            handler.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.BUCKET_FILL, (float)1.0f, (float)1.0f));
        }
    }

    public boolean isValidClickButton(int button) {
        return button == 0 || button == 1;
    }

    protected void renderWidget(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.content == null || this.fluidTexture == null || this.disableRender) {
            return;
        }
        ColorContainer argb = new ColorContainer(IClientFluidTypeExtensions.of((Fluid)this.content.getFluid()).getTintColor());
        guiGraphics.setColor(argb.r(), argb.g(), argb.b(), argb.a());
        float levels = (float)this.content.getAmount() / 1000.0f / (float)this.maxLevel;
        int usedY = (int)Math.ceil(levels * (float)this.height);
        float tiles = (float)usedY / (float)this.width;
        int currentY = this.getY() + this.height;
        int x = 0;
        while ((float)x < tiles) {
            if (tiles - (float)x > 1.0f) {
                size = this.width;
                guiGraphics.blit(this.getX(), currentY - size, 0, size, size, this.fluidTexture);
                currentY -= size;
            } else {
                size = (int)Math.ceil((tiles - (float)x) * (float)this.width);
                guiGraphics.blit(this.getX(), currentY - size, 0, this.width, size, this.fluidTexture);
            }
            ++x;
        }
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    protected void updateWidgetNarration(@NotNull NarrationElementOutput narration) {
    }

    public void setFluidStack(FluidStack fluidStack) {
        if (fluidStack.isEmpty()) {
            this.content = FluidStack.EMPTY;
            this.disableRender = true;
            this.updateTooltip(fluidStack);
            return;
        }
        this.disableRender = false;
        boolean updateTexture = this.content.isEmpty() || fluidStack.getFluid() != this.content.getFluid();
        this.content = fluidStack;
        this.updateTooltip(fluidStack);
        if (updateTexture && !this.content.isEmpty()) {
            IClientFluidTypeExtensions properties = IClientFluidTypeExtensions.of((Fluid)this.content.getFluid());
            ResourceLocation texture = properties.getStillTexture(this.content);
            this.fluidTexture = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(texture);
        }
    }

    private void updateTooltip(FluidStack stack) {
        if (stack.isEmpty()) {
            this.setTooltip(Tooltip.create((Component)Tooltips.of((Component[])new Component[]{AAEText.TankEmpty.text(), Component.literal((String)"\n"), AAEText.TankAmount.text(new Object[]{0, 16}).withStyle(Tooltips.NUMBER_TEXT)})));
            return;
        }
        GenericStack genericStack = GenericStack.fromFluidStack((FluidStack)this.content);
        if (genericStack != null) {
            this.setTooltip(Tooltip.create((Component)Tooltips.of((Component[])new Component[]{stack.getHoverName(), Component.literal((String)"\n"), Tooltips.ofAmount((GenericStack)genericStack), Component.literal((String)"\n"), Component.literal((String)FluidTankSlot.getModDisplayNameFromId(genericStack.what().getModId())).withStyle(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.ITALIC})})));
        }
    }

    private static String getModDisplayNameFromId(String modId) {
        Optional container = ModList.get().getModContainerById(modId);
        if (modId.equals("c")) {
            return "Common";
        }
        container = ModList.get().getModContainerById(modId);
        if (container.isPresent()) {
            return ((ModContainer)container.get()).getModInfo().getDisplayName();
        }
        container = ModList.get().getModContainerById(modId.replace('_', '-'));
        return container.isPresent() ? ((ModContainer)container.get()).getModInfo().getDisplayName() : WordUtils.capitalizeFully((String)modId.replace('_', ' '));
    }
}

