/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.client.gui;

import appeng.api.stacks.AEKey;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.NumberEntryType;
import appeng.client.gui.WidgetContainer;
import appeng.client.gui.implementations.AESubScreen;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.NumberEntryWidget;
import appeng.core.localization.GuiText;
import appeng.menu.AEBaseMenu;
import appeng.menu.ISubMenu;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.pedroksl.advanced_ae.gui.SetAmountMenu;

public class SetAmountScreen
extends AEBaseScreen<SetAmountMenu> {
    private final NumberEntryWidget amount;
    private boolean amountInitialized;

    public SetAmountScreen(SetAmountMenu menu, Inventory playerInventory, Component title, ScreenStyle style) {
        super((AEBaseMenu)menu, playerInventory, title, style);
        this.widgets.addButton("save", (Component)GuiText.Set.text(), this::confirm);
        AESubScreen.addBackButton((ISubMenu)menu, (String)"back", (WidgetContainer)this.widgets);
        this.amount = this.widgets.addNumberEntryWidget("amountToStock", NumberEntryType.UNITLESS);
        this.amount.setLongValue(1L);
        this.amount.setTextFieldStyle(style.getWidget("amountToStockInput"));
        this.amount.setMinValue(0L);
        this.amount.setHideValidationIcon(true);
        this.amount.setOnConfirm(this::confirm);
    }

    protected void updateBeforeRender() {
        AEKey whatToStock;
        super.updateBeforeRender();
        if (!this.amountInitialized && (whatToStock = ((SetAmountMenu)this.menu).getWhatToStock()) != null) {
            this.amount.setType(NumberEntryType.of((AEKey)whatToStock));
            this.amount.setLongValue(((SetAmountMenu)this.menu).getInitialAmount());
            this.amount.setMaxValue(((SetAmountMenu)this.menu).getMaxAmount());
            this.amountInitialized = true;
        }
    }

    private void confirm() {
        this.amount.getLongValue().ifPresent(((SetAmountMenu)this.menu)::confirm);
    }
}

