/*
 * Decompiled with CFR 0.152.
 */
package com.respawningstructures.structure;

import com.respawningstructures.RespawningStructures;
import com.respawningstructures.config.CommonConfiguration;
import com.respawningstructures.structure.IRemembersPositionPiece;
import com.respawningstructures.structure.Respawn;
import com.respawningstructures.structure.RespawnLevelData;
import com.respawningstructures.structure.StructureData;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.StructureTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;
import net.minecraft.world.level.levelgen.structure.structures.DesertPyramidPiece;
import net.minecraft.world.level.levelgen.structure.structures.JungleTemplePiece;
import net.minecraft.world.level.levelgen.structure.structures.MineshaftPieces;
import net.minecraft.world.level.levelgen.structure.structures.NetherFortressPieces;
import net.minecraft.world.level.levelgen.structure.structures.StrongholdPieces;
import net.minecraft.world.phys.AABB;

public class RespawnManager {
    public static volatile StructureData respawnInProgress = null;
    public static Object2IntOpenHashMap<EntityType> entityCounts = new Object2IntOpenHashMap();
    public static Object2IntOpenHashMap<BlockPos> heightMap = null;
    private static List<Holder<MobEffect>> randomEffects = List.of(MobEffects.DAMAGE_RESISTANCE, MobEffects.FIRE_RESISTANCE, MobEffects.REGENERATION, MobEffects.DAMAGE_BOOST, MobEffects.WATER_BREATHING, MobEffects.ABSORPTION, MobEffects.DARKNESS, MobEffects.JUMP);

    public static StructureData getForPos(ServerLevel level, BlockPos pos, boolean update) {
        RespawnLevelData respawnData = (RespawnLevelData)level.getDataStorage().computeIfAbsent(RespawnLevelData.RESPAWNLEVELDATAFACTORY, "respawningdungeonsdata");
        return respawnData.getForPos(level, pos, update);
    }

    public static void onSpawnerKilled(SpawnerBlockEntity entity) {
        StructureData structureData;
        if (entity.hasLevel() && !entity.getLevel().isClientSide() && (structureData = RespawnManager.getForPos((ServerLevel)entity.getLevel(), entity.getBlockPos(), true)) != null) {
            ++structureData.spawnerBreak;
        }
    }

    public static void onSpawnerActive(ServerLevel level, BlockPos pos) {
        StructureData structureData = RespawnManager.getForPos(level, pos, true);
        if (structureData != null) {
            ++structureData.spawnerActivations;
        }
    }

    public static void onChestLooted(ServerLevel level, ResourceLocation lootTable, BlockPos pos) {
        StructureData structureData = RespawnManager.getForPos(level, pos, true);
        if (structureData != null) {
            ++structureData.containerLooted;
        }
    }

    public static void onBlockEntityAddRemove(ServerLevel level, BlockPos pos, boolean remove) {
        StructureData structureData = RespawnManager.getForPos(level, pos, false);
        if (structureData != null) {
            if (!remove) {
                structureData.setLastModifiedTime(structureData.lastActivity + 200L);
                ++structureData.blockEntities;
            } else {
                structureData.blockEntities = Math.max(0, structureData.blockEntities - 1);
            }
        }
    }

    public static void onMobKilled(LivingEntity entity) {
        StructureData structureData = RespawnManager.getForPos((ServerLevel)entity.level(), entity.blockPosition(), true);
        if (structureData != null) {
            ++structureData.mobsKilled;
            if (entity.getMaxHealth() > 80.0f) {
                structureData.mobsKilled += 10;
            }
        }
    }

    public static void onBlockBreak(ServerPlayer player, BlockPos pos) {
        StructureData structureData = RespawnManager.getForPos((ServerLevel)player.level(), pos, true);
        if (structureData != null) {
            ++structureData.blocksBroken;
        }
    }

    public static void onLightPlaced(ServerPlayer player, BlockPos pos) {
        StructureData structureData = RespawnManager.getForPos((ServerLevel)player.level(), pos, true);
        if (structureData != null) {
            ++structureData.lightsPlaced;
        }
    }

    public static void onRedstonePlaced(ServerPlayer player, BlockPos pos) {
        StructureData structureData = RespawnManager.getForPos((ServerLevel)player.level(), pos, true);
        if (structureData != null) {
            ++structureData.redstonePlaced;
        }
    }

    public static void onRedstoneDestroyed(ServerPlayer player, BlockPos pos) {
        StructureData structureData = RespawnManager.getForPos((ServerLevel)player.level(), pos, true);
        if (structureData != null) {
            structureData.redstonePlaced = Math.max(0, structureData.redstonePlaced - 1);
        }
    }

    public static void onBlockPlaced(ServerPlayer player, BlockPos pos) {
        StructureData structureData = RespawnManager.getForPos((ServerLevel)player.level(), pos, true);
        if (structureData != null) {
            ++structureData.blocksPlaced;
        }
    }

    public static void onExplosion(Level level, Explosion explosion, List<BlockPos> affectedBlocks) {
        StructureData structureData = RespawnManager.getForPos((ServerLevel)level, BlockPos.containing((Position)explosion.center()), true);
        if (structureData != null) {
            structureData.blocksBroken += affectedBlocks.size() / 2;
        }
    }

    public static void onPlayerDeath(ServerPlayer player) {
        StructureData structureData = RespawnManager.getForPos((ServerLevel)player.level(), player.blockPosition(), true);
        if (structureData != null) {
            ++structureData.playerDeaths;
        }
    }

    public static void onPlayerLogin(ServerPlayer entity) {
        RespawnLevelData levelData = (RespawnLevelData)((ServerLevel)entity.level()).getDataStorage().computeIfAbsent(RespawnLevelData.RESPAWNLEVELDATAFACTORY, "respawningdungeonsdata");
        if (entity.getRespawnPosition() != null && entity.level().dimension() == entity.getRespawnDimension()) {
            levelData.playerRespawnTracker.computeIfAbsent((UUID)entity.getUUID(), (Function<UUID, Respawn>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$onPlayerLogin$0(net.minecraft.server.level.ServerPlayer com.respawningstructures.structure.RespawnLevelData java.util.UUID ), (Ljava/util/UUID;)Lcom/respawningstructures/structure/Respawn;)((ServerPlayer)entity, (RespawnLevelData)levelData)).lastUsageLevelTime = levelData.getLevelTime();
        }
        levelData.setDirty();
    }

    public static void onPlayerRespawn(ServerPlayer entity) {
        RespawnLevelData levelData = (RespawnLevelData)((ServerLevel)entity.level()).getDataStorage().computeIfAbsent(RespawnLevelData.RESPAWNLEVELDATAFACTORY, "respawningdungeonsdata");
        if (entity.getRespawnPosition() != null && entity.level().dimension() == entity.getRespawnDimension()) {
            levelData.playerRespawnTracker.computeIfAbsent((UUID)entity.getUUID(), (Function<UUID, Respawn>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$onPlayerRespawn$1(net.minecraft.server.level.ServerPlayer com.respawningstructures.structure.RespawnLevelData java.util.UUID ), (Ljava/util/UUID;)Lcom/respawningstructures/structure/Respawn;)((ServerPlayer)entity, (RespawnLevelData)levelData)).lastUsageLevelTime = levelData.getLevelTime();
        }
        levelData.setDirty();
    }

    public static void onPlayerSetSpawn(ServerPlayer entity) {
        for (ServerLevel level : entity.server.getAllLevels()) {
            RespawnLevelData levelData = (RespawnLevelData)level.getDataStorage().computeIfAbsent(RespawnLevelData.RESPAWNLEVELDATAFACTORY, "respawningdungeonsdata");
            Respawn respawn = levelData.playerRespawnTracker.get(entity.getUUID());
            if (respawn == null) {
                if (level.dimension() == entity.getRespawnDimension() && entity.getRespawnPosition() != null) {
                    levelData.playerRespawnTracker.computeIfAbsent(entity.getUUID(), uuid -> new Respawn((UUID)uuid, entity.getRespawnPosition(), levelData.getLevelTime()));
                }
            } else if (level.dimension() != entity.getRespawnDimension()) {
                levelData.playerRespawnTracker.remove(entity.getUUID());
            } else {
                respawn.lastUsageLevelTime = levelData.getLevelTime();
            }
            levelData.setDirty();
        }
    }

    public static void onPortalUsage(ServerPlayer player, BlockPos pos) {
        StructureData structureData = RespawnManager.getForPos((ServerLevel)player.level(), pos, true);
        if (structureData != null) {
            ++structureData.portalUsage;
        }
    }

    public static void onLevelTick(ServerLevel level) {
        if (((CommonConfiguration)RespawningStructures.config.getCommonConfig()).dimensionBlackList.contains(level.dimension().location().toString())) {
            return;
        }
        RespawnLevelData respawnData = (RespawnLevelData)level.getDataStorage().computeIfAbsent(RespawnLevelData.RESPAWNLEVELDATAFACTORY, "respawningdungeonsdata");
        for (StructureData data : respawnData.getAllStructureData()) {
            if (data.canRespawn(level) == StructureData.RespawnStatus.PENDING_RESPAWN && data.respawn(level)) break;
        }
    }

    public static boolean respawnStructure(ServerLevel level, StructureData structureData, boolean checkLoaded) {
        StructurePiece piece;
        Iterator iterator;
        if (structureData == null) {
            return false;
        }
        if (checkLoaded && !level.hasChunk(structureData.pos.x(), structureData.pos.z())) {
            return false;
        }
        RespawnLevelData respawnData = (RespawnLevelData)level.getDataStorage().computeIfAbsent(RespawnLevelData.RESPAWNLEVELDATAFACTORY, "respawningdungeonsdata");
        if (respawnData == null) {
            return false;
        }
        structureData.fillStructureStart(level);
        StructureStart structureStart = structureData.getStructureStart();
        if (structureStart == null || !structureStart.isValid()) {
            return false;
        }
        long time = System.nanoTime();
        BoundingBox boundingbox = structureStart.getBoundingBox();
        ChunkPos chunkPosMin = new ChunkPos(SectionPos.blockToSectionCoord((int)boundingbox.minX()), SectionPos.blockToSectionCoord((int)boundingbox.minZ()));
        ChunkPos chunkPosMax = new ChunkPos(SectionPos.blockToSectionCoord((int)boundingbox.maxX()), SectionPos.blockToSectionCoord((int)boundingbox.maxZ()));
        if (checkLoaded) {
            int loaded = 0;
            int unloaded = 0;
            for (int x = chunkPosMin.x; x <= chunkPosMax.x; ++x) {
                for (int z = chunkPosMax.z; z <= chunkPosMax.z; ++z) {
                    if (!level.hasChunk(x, z)) {
                        ++unloaded;
                        continue;
                    }
                    ++loaded;
                }
            }
            if (loaded + unloaded > 0 && (double)unloaded / (double)(loaded + unloaded) > 0.3) {
                return false;
            }
        }
        if (((CommonConfiguration)RespawningStructures.config.getCommonConfig()).logRespawns) {
            RespawningStructures.LOGGER.info("Respawning structure: " + String.valueOf(structureData.id) + " at: " + String.valueOf(structureData.pos.origin()) + " stats: " + structureData.getStats(level).getString());
        }
        respawnInProgress = structureData;
        respawnData.setDirty();
        List entities = level.getEntitiesOfClass(Entity.class, new AABB((double)boundingbox.minX(), (double)boundingbox.minY(), (double)boundingbox.minZ(), (double)boundingbox.maxX(), (double)boundingbox.maxY(), (double)boundingbox.maxZ()).inflate(20.0));
        entityCounts = new Object2IntOpenHashMap();
        for (Entity existing : entities) {
            entityCounts.put((Object)existing.getType(), entityCounts.getOrDefault((Object)existing.getType(), 0) + 1);
        }
        for (StructurePiece piece2 : structureStart.getPieces()) {
            if (checkLoaded) {
                if (!boundingbox.isInside(piece2.getBoundingBox().maxX(), piece2.getBoundingBox().maxY(), piece2.getBoundingBox().maxZ()) && !level.hasChunk(piece2.getBoundingBox().maxX() >> 4, piece2.getBoundingBox().maxZ() >> 4)) {
                    return false;
                }
                if (!boundingbox.isInside(piece2.getBoundingBox().minX(), piece2.getBoundingBox().minY(), piece2.getBoundingBox().minZ()) && !level.hasChunk(piece2.getBoundingBox().minX() >> 4, piece2.getBoundingBox().minZ() >> 4)) {
                    return false;
                }
            }
            if (piece2 instanceof NetherFortressPieces.MonsterThrone) {
                ((NetherFortressPieces.MonsterThrone)piece2).hasPlacedSpawner = false;
            }
            if (piece2 instanceof StrongholdPieces.PortalRoom) {
                ((StrongholdPieces.PortalRoom)piece2).hasPlacedSpawner = false;
            }
            if (piece2 instanceof StrongholdPieces.ChestCorridor) {
                ((StrongholdPieces.ChestCorridor)piece2).hasPlacedChest = false;
            }
            if (piece2 instanceof MineshaftPieces.MineShaftCorridor) {
                ((MineshaftPieces.MineShaftCorridor)piece2).hasPlacedSpider = false;
            }
            if (piece2 instanceof DesertPyramidPiece) {
                ((DesertPyramidPiece)piece2).hasPlacedChest[0] = false;
                ((DesertPyramidPiece)piece2).hasPlacedChest[1] = false;
                ((DesertPyramidPiece)piece2).hasPlacedChest[2] = false;
                ((DesertPyramidPiece)piece2).hasPlacedChest[3] = false;
            }
            if (piece2 instanceof JungleTemplePiece) {
                ((JungleTemplePiece)piece2).placedMainChest = false;
                ((JungleTemplePiece)piece2).placedHiddenChest = false;
            }
            if (piece2 instanceof NetherFortressPieces.CastleSmallCorridorLeftTurnPiece) {
                boolean bl = ((NetherFortressPieces.CastleSmallCorridorLeftTurnPiece)piece2).isNeedingChest = RespawningStructures.rand.nextInt(3) == 0;
            }
            if (piece2 instanceof NetherFortressPieces.CastleSmallCorridorRightTurnPiece) {
                boolean bl = ((NetherFortressPieces.CastleSmallCorridorRightTurnPiece)piece2).isNeedingChest = RespawningStructures.rand.nextInt(3) == 0;
            }
            if (!(piece2 instanceof IRemembersPositionPiece)) continue;
            ((IRemembersPositionPiece)piece2).setRespawnTemplatePos(((TemplateStructurePiece)piece2).templatePosition());
        }
        Registry structureRegistry = level.registryAccess().registryOrThrow(Registries.STRUCTURE);
        Optional holder = structureRegistry.getHolder(structureRegistry.getId((Object)structureStart.getStructure()));
        if (holder.isPresent() && ((Holder.Reference)holder.get()).is(StructureTags.VILLAGE)) {
            ArrayList pieces = new ArrayList(structureStart.getPieces());
            iterator = pieces.iterator();
            while (iterator.hasNext()) {
                piece = (StructurePiece)iterator.next();
                if (!piece.toString().contains("street")) continue;
                iterator.remove();
            }
            structureStart = new StructureStart(structureStart.getStructure(), structureStart.getChunkPos(), structureStart.getReferences(), new PiecesContainer(pieces));
        }
        if (holder.isPresent() && ((Holder.Reference)holder.get()).key().location().toString().contains("stronghold")) {
            ArrayList pieces = new ArrayList(structureStart.getPieces());
            iterator = pieces.iterator();
            while (iterator.hasNext()) {
                piece = (StructurePiece)iterator.next();
                if (!piece.toString().contains("portal") && !(piece instanceof StrongholdPieces.PortalRoom)) continue;
                iterator.remove();
            }
            structureStart = new StructureStart(structureStart.getStructure(), structureStart.getChunkPos(), structureStart.getReferences(), new PiecesContainer(pieces));
        }
        StructureStart toPlace = structureStart;
        ChunkPos.rangeClosed((ChunkPos)chunkPosMin, (ChunkPos)chunkPosMax).forEach(chunPos -> {
            toPlace.placeInChunk((WorldGenLevel)level, level.structureManager(), level.getChunkSource().getGenerator(), level.getRandom(), new BoundingBox(chunPos.getMinBlockX(), level.getMinBuildHeight(), chunPos.getMinBlockZ(), chunPos.getMaxBlockX(), level.getMaxBuildHeight(), chunPos.getMaxBlockZ()), chunPos);
            level.getChunk(chunPos.x, chunPos.z).postProcessGeneration();
            ClientboundLevelChunkWithLightPacket packet = new ClientboundLevelChunkWithLightPacket(level.getChunk(chunPos.x, chunPos.z), level.getLightEngine(), null, null);
            for (ServerPlayer player : level.getChunkSource().chunkMap.getPlayers(chunPos, false)) {
                player.connection.send((Packet)packet);
            }
        });
        time = System.nanoTime() - time;
        if ((double)time / 1.0E9 > 20.0) {
            RespawningStructures.LOGGER.warn("Structure:" + String.valueOf(structureData.id) + " took over 20 seconds to respawn, if you want to avoid lagspikes it is recommended to put this ID on the blacklist:" + String.valueOf(structureData.id));
        }
        structureData.onRespawnReset();
        respawnInProgress = null;
        heightMap = null;
        return true;
    }

    public static boolean tryAddEntityDuringRespawn(Entity entity, ServerLevel level, BlockPos pos) {
        if (respawnInProgress != null) {
            if (entityCounts.getInt((Object)entity.getType()) > 0) {
                entityCounts.put((Object)entity.getType(), entityCounts.getInt((Object)entity.getType()) - 1);
                return false;
            }
            if (entity instanceof Mob && entity instanceof Enemy) {
                RespawnManager.applyRespawnBonus((Mob)entity, respawnInProgress);
            }
        }
        return true;
    }

    public static void onSpawnerSpawn(Mob entity) {
        StructureData structureData = RespawnManager.getForPos((ServerLevel)entity.level(), entity.blockPosition(), true);
        if (structureData != null && structureData.respawns > 0) {
            RespawnManager.applyRespawnBonus(entity, structureData);
        }
    }

    private static void applyRespawnBonus(Mob entity, StructureData structureData) {
        if (!((CommonConfiguration)RespawningStructures.config.getCommonConfig()).increaseDifficultyWithRespawn) {
            return;
        }
        int respawnDifficulty = Math.min(4, structureData.respawns);
        for (int i = 0; i < respawnDifficulty; ++i) {
            Holder<MobEffect> randomEffect;
            ItemStack toEnchantItem = null;
            EquipmentSlot enchantItemSlot = null;
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                if (slot == EquipmentSlot.OFFHAND || entity.getItemBySlot(slot).isEmpty() || entity.getItemBySlot(slot).isEnchanted()) continue;
                toEnchantItem = entity.getItemBySlot(slot);
                enchantItemSlot = slot;
                break;
            }
            if (toEnchantItem == null && RespawningStructures.rand.nextInt(10) == 0) {
                for (EquipmentSlot slot : EquipmentSlot.values()) {
                    if (!entity.getItemBySlot(slot).isEmpty() || slot == EquipmentSlot.OFFHAND) continue;
                    if (slot == EquipmentSlot.MAINHAND) {
                        toEnchantItem = Items.IRON_SWORD.getDefaultInstance();
                        enchantItemSlot = slot;
                        entity.setItemSlot(slot, toEnchantItem);
                    }
                    if (slot == EquipmentSlot.CHEST) {
                        toEnchantItem = Items.IRON_CHESTPLATE.getDefaultInstance();
                        enchantItemSlot = slot;
                        entity.setItemSlot(slot, toEnchantItem);
                    }
                    if (slot == EquipmentSlot.HEAD) {
                        toEnchantItem = Items.IRON_HELMET.getDefaultInstance();
                        enchantItemSlot = slot;
                        entity.setItemSlot(slot, toEnchantItem);
                    }
                    if (slot == EquipmentSlot.LEGS) {
                        toEnchantItem = Items.IRON_LEGGINGS.getDefaultInstance();
                        enchantItemSlot = slot;
                        entity.setItemSlot(slot, toEnchantItem);
                    }
                    if (slot != EquipmentSlot.FEET) break;
                    toEnchantItem = Items.IRON_BOOTS.getDefaultInstance();
                    enchantItemSlot = slot;
                    entity.setItemSlot(slot, toEnchantItem);
                    break;
                }
            }
            if (toEnchantItem != null) {
                EnchantmentHelper.enchantItem((RandomSource)entity.getRandom(), toEnchantItem, (int)respawnDifficulty, (RegistryAccess)entity.level().registryAccess(), (Optional)entity.level().registryAccess().registryOrThrow(Registries.ENCHANTMENT).getTag(EnchantmentTags.ON_RANDOM_LOOT));
                entity.setDropChance(enchantItemSlot, 0.3f);
            }
            if (RespawningStructures.rand.nextInt(4) != 0 || entity.hasEffect(randomEffect = randomEffects.get(RespawningStructures.rand.nextInt(randomEffects.size())))) continue;
            entity.addEffect(new MobEffectInstance(randomEffect, -1));
        }
    }

    private static /* synthetic */ Respawn lambda$onPlayerRespawn$1(ServerPlayer entity, RespawnLevelData levelData, UUID uuid) {
        return new Respawn(uuid, entity.getRespawnPosition(), levelData.getLevelTime());
    }

    private static /* synthetic */ Respawn lambda$onPlayerLogin$0(ServerPlayer entity, RespawnLevelData levelData, UUID uuid) {
        return new Respawn(uuid, entity.getRespawnPosition(), levelData.getLevelTime());
    }
}

