/*
 * Decompiled with CFR 0.152.
 */
package com.respawningstructures.event;

import com.respawningstructures.structure.RespawnLevelData;
import com.respawningstructures.structure.RespawnManager;
import java.util.Calendar;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.MobSpawnEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.level.ExplosionEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

public class EventHandler {
    private static final TagKey<Block> REDSTONE = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"respawningstructures", (String)"redstone"));
    private static long lastTime = 0L;

    @SubscribeEvent
    public static void onServerTick(ServerTickEvent.Post event) {
        if (event.getServer().getTickCount() % 100 == 35) {
            if (lastTime == 0L) {
                lastTime = Calendar.getInstance().getTimeInMillis();
                return;
            }
            if (event.getServer().getPlayerCount() > 0 && Calendar.getInstance().getTimeInMillis() - lastTime > 300000L) {
                lastTime = Calendar.getInstance().getTimeInMillis();
                for (ServerLevel level : event.getServer().getAllLevels()) {
                    RespawnLevelData data = (RespawnLevelData)level.getDataStorage().computeIfAbsent(RespawnLevelData.RESPAWNLEVELDATAFACTORY, "respawningdungeonsdata");
                    if (data == null) continue;
                    data.increaseTime(300);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLevelTick(LevelTickEvent.Post event) {
        if (!event.getLevel().isClientSide && event.getLevel().getGameTime() % 1000L == 17L) {
            RespawnManager.onLevelTick((ServerLevel)event.getLevel());
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        if (event.getPlayer() instanceof ServerPlayer) {
            if (event.getState().hasBlockEntity() && event.getLevel().getBlockEntity(event.getPos()) instanceof SpawnerBlockEntity) {
                RespawnManager.onSpawnerKilled((SpawnerBlockEntity)event.getLevel().getBlockEntity(event.getPos()));
            } else if (event.getState().hasProperty((Property)BlockStateProperties.POWER) || event.getState().is(REDSTONE)) {
                RespawnManager.onRedstoneDestroyed((ServerPlayer)event.getPlayer(), event.getPos());
            } else {
                RespawnManager.onBlockBreak((ServerPlayer)event.getPlayer(), event.getPos());
            }
        }
    }

    @SubscribeEvent
    public static void onBlockPlaced(BlockEvent.EntityPlaceEvent event) {
        if (event.getEntity() instanceof ServerPlayer) {
            if (event.getState().getLightEmission() > 0) {
                RespawnManager.onLightPlaced((ServerPlayer)event.getEntity(), event.getPos());
            } else if (event.getState().hasProperty((Property)BlockStateProperties.POWER) || event.getState().is(REDSTONE)) {
                RespawnManager.onRedstonePlaced((ServerPlayer)event.getEntity(), event.getPos());
            } else {
                RespawnManager.onBlockPlaced((ServerPlayer)event.getEntity(), event.getPos());
            }
        }
    }

    @SubscribeEvent
    public static void onExplosion(ExplosionEvent.Detonate event) {
        if (!event.getLevel().isClientSide) {
            RespawnManager.onExplosion(event.getLevel(), event.getExplosion(), event.getAffectedBlocks());
        }
    }

    @SubscribeEvent
    public static void onLevelLoad(LevelEvent.Load event) {
        if (!event.getLevel().isClientSide()) {
            // empty if block
        }
    }

    @SubscribeEvent
    public static void onMobKilled(LivingDeathEvent event) {
        if (!event.getEntity().level().isClientSide() && event.getSource().getEntity() instanceof ServerPlayer) {
            RespawnManager.onMobKilled(event.getEntity());
        } else if (event.getEntity() instanceof ServerPlayer) {
            RespawnManager.onPlayerDeath((ServerPlayer)event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onEntityAdded(EntityJoinLevelEvent event) {
        if (!event.getLevel().isClientSide && !RespawnManager.tryAddEntityDuringRespawn(event.getEntity(), (ServerLevel)event.getLevel(), event.getEntity().blockPosition())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEntityAdded(MobSpawnEvent.PositionCheck event) {
        if (!event.getLevel().isClientSide() && event.getSpawnType() == MobSpawnType.SPAWNER && event.getEntity() != null) {
            RespawnManager.onSpawnerSpawn(event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getEntity() instanceof ServerPlayer) {
            RespawnManager.onPlayerLogin((ServerPlayer)event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (event.getEntity() instanceof ServerPlayer) {
            RespawnManager.onPlayerRespawn((ServerPlayer)event.getEntity());
        }
    }
}

