/*
 * Decompiled with CFR 0.152.
 */
package com.tom.morewires.compat.id;

import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.ConnectorBlockEntityHelper;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.LocalWireNetwork;
import blusunrize.immersiveengineering.api.wires.WireType;
import com.google.common.collect.ImmutableList;
import com.tom.morewires.MoreImmersiveWires;
import com.tom.morewires.compat.id.IDNetworkHandler;
import com.tom.morewires.tile.IOnCable;
import java.util.Collection;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.extensions.ILevelExtension;
import org.cyclops.cyclopscore.blockentity.BlockEntityTickerDelayed;
import org.cyclops.cyclopscore.blockentity.CyclopsBlockEntity;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.datastructure.EnumFacingMap;
import org.cyclops.integrateddynamics.api.block.cable.ICable;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.INetworkCarrier;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.api.network.INetworkElementProvider;
import org.cyclops.integrateddynamics.api.path.ISidedPathElement;
import org.cyclops.integrateddynamics.capability.cable.CableTile;
import org.cyclops.integrateddynamics.capability.network.NetworkCarrierDefault;
import org.cyclops.integrateddynamics.capability.networkelementprovider.NetworkElementProviderSingleton;
import org.cyclops.integrateddynamics.capability.path.PathElementCable;
import org.cyclops.integrateddynamics.capability.path.PathElementDefault;
import org.cyclops.integrateddynamics.core.helper.CableHelpers;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.network.VariablestoreNetworkElement;

public class IDConnectorBlockEntity
extends CyclopsBlockEntity
implements IOnCable.IOnCableConnector {
    private final ICable cable;
    private IDNetworkHandler handler;
    protected GlobalWireNetwork globalNet;
    private final INetworkCarrier networkCarrier;
    private boolean isUnloaded = false;
    protected PathElementCable path = new PathElementCable(){

        public DimPos getPosition() {
            return DimPos.of((Level)IDConnectorBlockEntity.this.level, (BlockPos)IDConnectorBlockEntity.this.worldPosition);
        }

        public Set<ISidedPathElement> getReachableElements() {
            Set s = super.getReachableElements();
            if (IDConnectorBlockEntity.this.handler != null) {
                IDConnectorBlockEntity.this.handler.visitAll(s);
            }
            return s;
        }

        protected ICable getCable() {
            return IDConnectorBlockEntity.this.cable;
        }
    };

    public IDConnectorBlockEntity(BlockEntityType<?> p_155228_, BlockPos p_155229_, BlockState p_155230_) {
        super(p_155228_, p_155229_, p_155230_);
        this.cable = new CableTile<IDConnectorBlockEntity>(this){

            protected boolean isForceDisconnectable() {
                return false;
            }

            protected boolean isForceDisconnected(Direction side) {
                return IDConnectorBlockEntity.this.getFacing() != side;
            }

            protected EnumFacingMap<Boolean> getForceDisconnected() {
                return null;
            }

            protected EnumFacingMap<Boolean> getConnected() {
                return EnumFacingMap.newMap();
            }

            public boolean isConnected(Direction side) {
                return IDConnectorBlockEntity.this.getFacing() == side && CableHelpers.canCableConnectTo((ILevelExtension)IDConnectorBlockEntity.this.level, (BlockPos)this.getPos(), (Direction)side, (ICable)this);
            }

            public void updateConnections() {
            }

            public ItemStack getItemStack() {
                return new ItemStack((ItemLike)MoreImmersiveWires.ID_WIRE.simple().CONNECTOR.get());
            }
        };
        this.networkCarrier = new NetworkCarrierDefault();
    }

    public BlockState getState() {
        return this.getBlockState();
    }

    public boolean canConnect() {
        return true;
    }

    public boolean canConnectCable(WireType cableType, ConnectionPoint target, Vec3i offset) {
        LocalWireNetwork local = this.globalNet.getNullableLocalNet(new ConnectionPoint(this.worldPosition, 0));
        if (local != null && !local.getConnections(this.worldPosition).isEmpty()) {
            return false;
        }
        return cableType == MoreImmersiveWires.ID_WIRE.simple().wireType;
    }

    public void connectCable(WireType cableType, ConnectionPoint target, IImmersiveConnectable other, ConnectionPoint otherTarget) {
    }

    public void removeCable(Connection connection, ConnectionPoint attachedPoint) {
        this.setChanged();
    }

    public BlockPos getPosition() {
        return this.worldPosition;
    }

    @Override
    public Level getLevelNonnull() {
        return this.level;
    }

    public ICable getCable() {
        return this.cable;
    }

    public void onChunkUnloaded() {
        INetwork network;
        super.onChunkUnloaded();
        if (this.getLevel() != null && !this.getLevel().isClientSide && (network = this.getNetworkCarrier().getNetwork()) != null) {
            NetworkHelpers.invalidateNetworkElements((Level)this.getLevel(), (BlockPos)this.getBlockPos(), (INetwork)network, (INetworkElementProvider)this.getNetworkElementProvider());
        }
        ConnectorBlockEntityHelper.onChunkUnload((GlobalWireNetwork)this.globalNet, (IImmersiveConnectable)this);
        this.isUnloaded = true;
    }

    public INetworkCarrier getNetworkCarrier() {
        return this.networkCarrier;
    }

    public INetworkElementProvider getNetworkElementProvider() {
        return new NetworkElementProviderSingleton(this){

            public INetworkElement createNetworkElement(Level world, BlockPos blockPos) {
                return new VariablestoreNetworkElement(DimPos.of((Level)world, (BlockPos)blockPos));
            }
        };
    }

    public void setNetworkHandler(IDNetworkHandler handler) {
        this.handler = handler;
        if (!this.remove) {
            NetworkHelpers.initNetwork((ILevelExtension)this.level, (BlockPos)this.worldPosition, null);
        }
    }

    public void setLevel(Level worldIn) {
        super.setLevel(worldIn);
        this.globalNet = GlobalWireNetwork.getNetwork((Level)worldIn);
    }

    public void onLoad() {
        super.onLoad();
        if (this.level != null) {
            ConnectorBlockEntityHelper.onChunkLoad((IImmersiveConnectable)this, (Level)this.level);
            this.isUnloaded = false;
        }
    }

    public void setRemovedIE() {
        ConnectorBlockEntityHelper.remove((Level)this.level, (IImmersiveConnectable)this);
    }

    public void setRemoved() {
        super.setRemoved();
        if (!this.isUnloaded) {
            this.setRemovedIE();
        }
    }

    public Collection<ResourceLocation> getRequestedHandlers() {
        return ImmutableList.of((Object)MoreImmersiveWires.ID_WIRE.simple().NET_ID);
    }

    public PathElementDefault getPathElement() {
        return this.path;
    }

    public static class Ticker
    extends BlockEntityTickerDelayed<IDConnectorBlockEntity> {
        protected void update(Level level, BlockPos pos, BlockState blockState, IDConnectorBlockEntity blockEntity) {
            super.update(level, pos, blockState, (BlockEntity)blockEntity);
            NetworkHelpers.revalidateNetworkElements((Level)level, (BlockPos)pos);
        }
    }
}

