/*
 * Decompiled with CFR 0.152.
 */
package com.tom.morewires.block;

import blusunrize.immersiveengineering.common.blocks.generic.ConnectorBlock;
import blusunrize.immersiveengineering.common.blocks.metal.BasicConnectorBlock;
import com.tom.morewires.tile.IConnector;
import java.util.function.BiPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.registries.DeferredHolder;

public class OnCableConnectorBlock<T extends BlockEntity>
extends BasicConnectorBlock<T> {
    public static final BooleanProperty ON_CABLE = BooleanProperty.create((String)"on_cable");
    private BiPredicate<BlockGetter, BlockPos> isOnCable;

    public OnCableConnectorBlock(DeferredHolder<BlockEntityType<?>, BlockEntityType<T>> type, BiPredicate<BlockGetter, BlockPos> isOnCable) {
        super((BlockBehaviour.Properties)ConnectorBlock.PROPERTIES.get(), type);
        this.isOnCable = isOnCable;
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        IConnector connector;
        super.neighborChanged(state, world, pos, block, fromPos, isMoving);
        BlockEntity te = world.getBlockEntity(pos);
        if (te instanceof IConnector && world.isEmptyBlock(pos.relative((connector = (IConnector)te).getFacing()))) {
            OnCableConnectorBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)this));
            connector.getLevelNonnull().removeBlock(pos, false);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{ON_CABLE});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos = context.replacingClickedOnBlock() ? context.getClickedPos() : context.getClickedPos().relative(context.getClickedFace(), -1);
        return (BlockState)super.getStateForPlacement(context).setValue((Property)ON_CABLE, (Comparable)Boolean.valueOf(this.isOnCable.test((BlockGetter)context.getLevel(), pos)));
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        BlockState state = super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        return (BlockState)state.setValue((Property)ON_CABLE, (Comparable)Boolean.valueOf(this.isOnCable.test((BlockGetter)worldIn, currentPos.relative((Direction)state.getValue((Property)ConnectorBlock.DEFAULT_FACING_PROP)))));
    }
}

