/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.javafmlmod;

import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.Bindings;
import net.neoforged.fml.Logging;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.loading.modscan.ModAnnotation;
import net.neoforged.neoforgespi.language.ModFileScanData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.Type;

public class AutomaticEventSubscriber {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Type AUTO_SUBSCRIBER = Type.getType(EventBusSubscriber.class);
    private static final Type MOD_TYPE = Type.getType(Mod.class);

    public static void inject(ModContainer mod, ModFileScanData scanData, Module layer) {
        if (scanData == null) {
            return;
        }
        LOGGER.debug(Logging.LOADING, "Attempting to inject @EventBusSubscriber classes into the eventbus for {}", (Object)mod.getModId());
        List<ModFileScanData.AnnotationData> ebsTargets = scanData.getAnnotations().stream().filter(annotationData -> AUTO_SUBSCRIBER.equals((Object)annotationData.annotationType())).collect(Collectors.toList());
        Map<String, String> modids = scanData.getAnnotations().stream().filter(annotationData -> MOD_TYPE.equals((Object)annotationData.annotationType())).collect(Collectors.toMap(a -> a.clazz().getClassName(), a -> (String)a.annotationData().get("value")));
        ebsTargets.forEach(ad -> {
            EnumSet<Dist> sides = AutomaticEventSubscriber.getSides(ad.annotationData().get("value"));
            String modId = (String)ad.annotationData().getOrDefault("modid", modids.getOrDefault(ad.clazz().getClassName(), mod.getModId()));
            ModAnnotation.EnumHolder busTargetHolder = (ModAnnotation.EnumHolder)ad.annotationData().getOrDefault("bus", new ModAnnotation.EnumHolder(null, EventBusSubscriber.Bus.GAME.name()));
            EventBusSubscriber.Bus busTarget = EventBusSubscriber.Bus.valueOf(busTargetHolder.value());
            if (Objects.equals(mod.getModId(), modId) && sides.contains(FMLEnvironment.dist)) {
                try {
                    IEventBus bus;
                    switch (busTarget) {
                        default: {
                            throw new MatchException(null, null);
                        }
                        case GAME: {
                            IEventBus iEventBus = Bindings.getGameBus();
                            break;
                        }
                        case MOD: {
                            IEventBus iEventBus = bus = mod.getEventBus();
                        }
                    }
                    if (bus != null) {
                        LOGGER.debug(Logging.LOADING, "Auto-subscribing {} to {}", (Object)ad.clazz().getClassName(), (Object)busTarget);
                        bus.register(Class.forName(ad.clazz().getClassName(), true, layer.getClassLoader()));
                    }
                }
                catch (ClassNotFoundException e) {
                    LOGGER.fatal(Logging.LOADING, "Failed to load mod class {} for @EventBusSubscriber annotation", (Object)ad.clazz(), (Object)e);
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public static EnumSet<Dist> getSides(Object data) {
        if (data == null) {
            return EnumSet.allOf(Dist.class);
        }
        return ((List)data).stream().map(eh -> Dist.valueOf((String)eh.value())).collect(Collectors.toCollection(() -> EnumSet.noneOf(Dist.class)));
    }
}

