/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.task;

import dev.architectury.registry.registries.RegistrarManager;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import java.util.ArrayList;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class KillTask
extends Task {
    private static final ResourceLocation ZOMBIE = ResourceLocation.parse((String)"minecraft:zombie");
    private ResourceLocation entity = ZOMBIE;
    private long value = 100L;

    public KillTask(long id, Quest quest) {
        super(id, quest);
    }

    @Override
    public TaskType getType() {
        return TaskTypes.KILL;
    }

    @Override
    public long getMaxProgress() {
        return this.value;
    }

    @Override
    public void writeData(CompoundTag nbt, HolderLookup.Provider provider) {
        super.writeData(nbt, provider);
        nbt.putString("entity", this.entity.toString());
        nbt.putLong("value", this.value);
    }

    @Override
    public void readData(CompoundTag nbt, HolderLookup.Provider provider) {
        super.readData(nbt, provider);
        this.entity = ResourceLocation.tryParse((String)nbt.getString("entity"));
        this.value = nbt.getLong("value");
    }

    @Override
    public void writeNetData(RegistryFriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.writeUtf(this.entity.toString(), Short.MAX_VALUE);
        buffer.writeVarLong(this.value);
    }

    @Override
    public void readNetData(RegistryFriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.entity = ResourceLocation.tryParse((String)buffer.readUtf(Short.MAX_VALUE));
        this.value = buffer.readVarInt();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        ArrayList ids = new ArrayList(BuiltInRegistries.ENTITY_TYPE.keySet());
        config.addEnum("entity", (Object)this.entity, v -> {
            this.entity = v;
        }, NameMap.of((Object)ZOMBIE, ids).nameKey(v -> "entity." + v.getNamespace() + "." + v.getPath()).icon(v -> {
            SpawnEggItem item = SpawnEggItem.byId((EntityType)((EntityType)BuiltInRegistries.ENTITY_TYPE.get(v)));
            return ItemIcon.getItemIcon((Item)(item != null ? item : Items.SPAWNER));
        }).create(), (Object)ZOMBIE);
        config.addLong("value", this.value, v -> {
            this.value = v;
        }, 100L, 1L, Long.MAX_VALUE);
    }

    @OnlyIn(value=Dist.CLIENT)
    public MutableComponent getAltTitle() {
        return Component.translatable((String)"ftbquests.task.ftbquests.kill.title", (Object[])new Object[]{this.formatMaxProgress(), Component.translatable((String)("entity." + this.entity.getNamespace() + "." + this.entity.getPath()))});
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Icon getAltIcon() {
        SpawnEggItem item = SpawnEggItem.byId((EntityType)((EntityType)BuiltInRegistries.ENTITY_TYPE.get(this.entity)));
        return ItemIcon.getItemIcon((Item)(item != null ? item : Items.SPAWNER));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onButtonClicked(Button button, boolean canClick) {
    }

    public void kill(TeamData teamData, LivingEntity e) {
        if (!teamData.isCompleted(this) && this.entity.equals((Object)RegistrarManager.getId((Object)e.getType(), (ResourceKey)Registries.ENTITY_TYPE))) {
            teamData.addProgress(this, 1L);
        }
    }
}

