/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest;

import com.mojang.util.UndashedUuid;
import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftblibrary.snbt.SNBT;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftbquests.FTBQuests;
import dev.ftb.mods.ftbquests.api.FTBQuestsAPI;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.events.QuestProgressEventData;
import dev.ftb.mods.ftbquests.net.ClaimRewardResponseMessage;
import dev.ftb.mods.ftbquests.net.ObjectCompletedMessage;
import dev.ftb.mods.ftbquests.net.ObjectCompletedResetMessage;
import dev.ftb.mods.ftbquests.net.ObjectStartedMessage;
import dev.ftb.mods.ftbquests.net.ObjectStartedResetMessage;
import dev.ftb.mods.ftbquests.net.ResetRewardMessage;
import dev.ftb.mods.ftbquests.net.SyncEditingModeMessage;
import dev.ftb.mods.ftbquests.net.SyncLockMessage;
import dev.ftb.mods.ftbquests.net.SyncRewardBlockingMessage;
import dev.ftb.mods.ftbquests.net.TogglePinnedResponseMessage;
import dev.ftb.mods.ftbquests.net.UpdateTaskProgressMessage;
import dev.ftb.mods.ftbquests.quest.BaseQuestFile;
import dev.ftb.mods.ftbquests.quest.ProgressionMode;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardAutoClaim;
import dev.ftb.mods.ftbquests.quest.reward.RewardClaimType;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.util.FTBQuestsInventoryListener;
import dev.ftb.mods.ftbquests.util.QuestKey;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.Team;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2ByteOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.function.ToBooleanBiFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TeamData {
    public static final int VERSION = 1;
    public static final int AUTO_PIN_ID = 1;
    private static final byte BOOL_UNKNOWN = -1;
    private static final byte BOOL_FALSE = 0;
    private static final byte BOOL_TRUE = 1;
    private static final Comparator<Long2LongMap.Entry> LONG2LONG_COMPARATOR = (e1, e2) -> Long.compareUnsigned(e1.getLongValue(), e2.getLongValue());
    private static final Comparator<Object2LongMap.Entry<QuestKey>> OBJECT2LONG_COMPARATOR = (e1, e2) -> Long.compareUnsigned(e1.getLongValue(), e2.getLongValue());
    public static final StreamCodec<FriendlyByteBuf, TeamData> STREAM_CODEC = new StreamCodec<FriendlyByteBuf, TeamData>(){

        public TeamData decode(FriendlyByteBuf buf) {
            return (TeamData)Util.make((Object)new TeamData(buf.readUUID(), ClientQuestFile.INSTANCE), d -> d.readNetData(buf));
        }

        public void encode(FriendlyByteBuf buf, TeamData data) {
            buf.writeUUID(data.getTeamId());
            data.write(buf);
        }
    };
    private final UUID teamId;
    private final BaseQuestFile file;
    private String name;
    private boolean shouldSave;
    private boolean locked;
    private boolean rewardsBlocked;
    private final Long2LongOpenHashMap taskProgress;
    private final Object2LongOpenHashMap<QuestKey> claimedRewards;
    private final Long2LongOpenHashMap started;
    private final Long2LongOpenHashMap completed;
    private final Object2ObjectOpenHashMap<UUID, PerPlayerData> perPlayerData;
    private final Long2ByteOpenHashMap areDependenciesCompleteCache;
    private final Long2ByteOpenHashMap areDependenciesVisibleCache;
    private final Object2ByteOpenHashMap<QuestKey> unclaimedRewardsCache;

    public TeamData(UUID teamId, BaseQuestFile file) {
        this(teamId, file, "");
    }

    public TeamData(UUID teamId, BaseQuestFile file, String name) {
        this.teamId = teamId;
        this.file = file;
        this.name = name;
        this.shouldSave = false;
        this.taskProgress = new Long2LongOpenHashMap();
        this.taskProgress.defaultReturnValue(0L);
        this.claimedRewards = new Object2LongOpenHashMap();
        this.claimedRewards.defaultReturnValue(0L);
        this.started = new Long2LongOpenHashMap();
        this.started.defaultReturnValue(0L);
        this.completed = new Long2LongOpenHashMap();
        this.completed.defaultReturnValue(0L);
        this.perPlayerData = new Object2ObjectOpenHashMap();
        this.areDependenciesCompleteCache = new Long2ByteOpenHashMap();
        this.areDependenciesVisibleCache = new Long2ByteOpenHashMap();
        this.unclaimedRewardsCache = new Object2ByteOpenHashMap();
    }

    public UUID getTeamId() {
        return this.teamId;
    }

    public BaseQuestFile getFile() {
        return this.file;
    }

    @NotNull
    public static TeamData get(Player player) {
        return FTBQuestsAPI.api().getQuestFile(player.getCommandSenderWorld().isClientSide()).getTeamData(player).orElseThrow();
    }

    public void markDirty() {
        this.shouldSave = true;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (!this.name.equals(name)) {
            this.name = name;
            this.markDirty();
        }
    }

    public void saveIfChanged() {
        BaseQuestFile baseQuestFile;
        if (this.shouldSave && (baseQuestFile = this.file) instanceof ServerQuestFile) {
            ServerQuestFile sqf = (ServerQuestFile)baseQuestFile;
            Path path = sqf.server.getWorldPath(ServerQuestFile.FTBQUESTS_DATA);
            SNBT.write((Path)path.resolve(String.valueOf(this.teamId) + ".snbt"), (CompoundTag)this.serializeNBT());
            this.shouldSave = false;
        }
    }

    public String toString() {
        return this.name.isEmpty() ? this.teamId.toString() : this.name;
    }

    public long getProgress(long taskId) {
        return this.taskProgress.get(taskId);
    }

    public long getProgress(Task task) {
        return this.getProgress(task.id);
    }

    public Optional<Date> getStartedTime(long questId) {
        long when = this.started.get(questId);
        return when == 0L ? Optional.empty() : Optional.of(new Date(when));
    }

    public boolean setStarted(long questId, @Nullable Date time) {
        if (!this.locked) {
            if (time == null) {
                if (this.started.remove(questId) >= 0L) {
                    this.clearCachedProgress();
                    this.markDirty();
                    if (this.file.isServerSide()) {
                        NetworkManager.sendToPlayers(this.getOnlineMembers(), (CustomPacketPayload)new ObjectStartedResetMessage(this.teamId, questId));
                    }
                    return true;
                }
            } else if (this.started.put(questId, time.getTime()) == 0L) {
                this.clearCachedProgress();
                this.markDirty();
                if (this.file.isServerSide()) {
                    NetworkManager.sendToPlayers(this.getOnlineMembers(), (CustomPacketPayload)new ObjectStartedMessage(this.teamId, questId));
                }
                return true;
            }
        }
        return false;
    }

    public Optional<Date> getCompletedTime(long questId) {
        long when = this.completed.get(questId);
        return when == 0L ? Optional.empty() : Optional.of(new Date(when));
    }

    public boolean setCompleted(long id, @Nullable Date time) {
        if (this.locked) {
            return false;
        }
        if (time == null) {
            if (this.completed.remove(id) >= 0L) {
                this.clearCachedProgress();
                this.markDirty();
                if (this.file.isServerSide()) {
                    NetworkManager.sendToPlayers(this.getOnlineMembers(), (CustomPacketPayload)new ObjectCompletedResetMessage(this.teamId, id));
                }
                return true;
            }
        } else if (this.completed.put(id, time.getTime()) == 0L) {
            this.clearCachedProgress();
            this.markDirty();
            if (this.file.isServerSide()) {
                NetworkManager.sendToPlayers(this.getOnlineMembers(), (CustomPacketPayload)new ObjectCompletedMessage(this.teamId, id));
            }
            return true;
        }
        return false;
    }

    public Optional<Date> getRewardClaimTime(UUID player, Reward reward) {
        QuestKey key = QuestKey.forReward(player, reward);
        long t = this.claimedRewards.getLong((Object)key);
        return t == 0L ? Optional.empty() : Optional.of(new Date(t));
    }

    public boolean areRewardsBlocked() {
        return this.rewardsBlocked;
    }

    public boolean isRewardBlocked(Reward reward) {
        return this.areRewardsBlocked() && !reward.ignoreRewardBlocking() && !reward.getQuest().ignoreRewardBlocking();
    }

    public boolean setRewardsBlocked(boolean rewardsBlocked) {
        if (rewardsBlocked != this.rewardsBlocked) {
            this.rewardsBlocked = rewardsBlocked;
            this.clearCachedProgress();
            this.markDirty();
            if (this.file.isServerSide()) {
                NetworkManager.sendToPlayers(this.getOnlineMembers(), (CustomPacketPayload)new SyncRewardBlockingMessage(this.teamId, rewardsBlocked));
            }
            return true;
        }
        return false;
    }

    public boolean isRewardClaimed(UUID player, Reward reward) {
        return this.getRewardClaimTime(player, reward).isPresent();
    }

    public boolean hasUnclaimedRewards(UUID player, QuestObject object) {
        QuestKey key = QuestKey.create(player, object.id);
        byte b = this.unclaimedRewardsCache.getOrDefault((Object)key, (byte)-1);
        if (b == -1) {
            b = object.hasUnclaimedRewardsRaw(this, player) ? (byte)1 : 0;
            this.unclaimedRewardsCache.put((Object)key, b);
        }
        return b == 1;
    }

    public boolean claimReward(UUID player, Reward reward, long date) {
        if (this.locked || this.isRewardBlocked(reward)) {
            return false;
        }
        QuestKey key = QuestKey.forReward(player, reward);
        if (!this.claimedRewards.containsKey((Object)key)) {
            this.claimedRewards.put((Object)key, date);
            this.clearCachedProgress();
            this.markDirty();
            if (this.file.isServerSide()) {
                NetworkManager.sendToPlayers(this.getOnlineMembers(), (CustomPacketPayload)new ClaimRewardResponseMessage(this.teamId, player, reward.id));
            }
            reward.getQuest().checkRepeatable(this, player);
            return true;
        }
        return false;
    }

    public void deleteReward(Reward reward) {
        if (!this.locked && this.claimedRewards.object2LongEntrySet().removeIf(e -> ((QuestKey)e.getKey()).getId() == reward.id)) {
            this.clearCachedProgress();
            this.markDirty();
        }
    }

    public boolean resetReward(UUID player, Reward reward) {
        if (!this.locked && this.claimedRewards.removeLong((Object)QuestKey.forReward(player, reward)) != 0L) {
            this.clearCachedProgress();
            this.markDirty();
            if (this.file.isServerSide()) {
                NetworkManager.sendToPlayers(this.getOnlineMembers(), (CustomPacketPayload)new ResetRewardMessage(this.teamId, player, reward.id));
            }
            return true;
        }
        return false;
    }

    public void clearCachedProgress() {
        this.areDependenciesCompleteCache.clear();
        this.areDependenciesVisibleCache.clear();
        this.unclaimedRewardsCache.clear();
    }

    public SNBTCompoundTag serializeNBT() {
        SNBTCompoundTag nbt = new SNBTCompoundTag();
        nbt.putInt("version", 1);
        nbt.putString("uuid", UndashedUuid.toString((UUID)this.teamId));
        nbt.putString("name", this.name);
        nbt.putBoolean("lock", this.locked);
        nbt.putBoolean("rewards_blocked", this.rewardsBlocked);
        SNBTCompoundTag taskProgressNBT = new SNBTCompoundTag();
        for (Object entry : this.taskProgress.long2LongEntrySet()) {
            if (entry.getLongValue() <= Integer.MAX_VALUE) {
                taskProgressNBT.putInt(QuestObjectBase.getCodeString(entry.getLongKey()), (int)entry.getLongValue());
                continue;
            }
            taskProgressNBT.putLong(QuestObjectBase.getCodeString(entry.getLongKey()), entry.getLongValue());
        }
        nbt.put("task_progress", (Tag)taskProgressNBT);
        SNBTCompoundTag startedNBT = new SNBTCompoundTag();
        for (Long2LongMap.Entry entry : this.started.long2LongEntrySet().stream().sorted(LONG2LONG_COMPARATOR).toList()) {
            startedNBT.putLong(QuestObjectBase.getCodeString(entry.getLongKey()), entry.getLongValue());
        }
        nbt.put("started", (Tag)startedNBT);
        SNBTCompoundTag completedNBT = new SNBTCompoundTag();
        for (Long2LongMap.Entry entry : this.completed.long2LongEntrySet().stream().sorted(LONG2LONG_COMPARATOR).toList()) {
            completedNBT.putLong(QuestObjectBase.getCodeString(entry.getLongKey()), entry.getLongValue());
        }
        nbt.put("completed", (Tag)completedNBT);
        SNBTCompoundTag sNBTCompoundTag = new SNBTCompoundTag();
        for (Object2LongMap.Entry<QuestKey> entry : this.claimedRewards.object2LongEntrySet().stream().sorted(OBJECT2LONG_COMPARATOR).toList()) {
            sNBTCompoundTag.putLong(((QuestKey)entry.getKey()).toString(), entry.getLongValue());
        }
        nbt.put("claimed_rewards", (Tag)sNBTCompoundTag);
        CompoundTag compoundTag = new CompoundTag();
        this.perPlayerData.forEach((id, ppd) -> {
            if (!ppd.hasDefaultValues()) {
                ppdTag.put(UndashedUuid.toString((UUID)id), (Tag)ppd.writeNBT());
            }
        });
        nbt.put("player_data", (Tag)compoundTag);
        return nbt;
    }

    public void deserializeNBT(SNBTCompoundTag nbt) {
        int fileVersion = nbt.getInt("version");
        if (fileVersion != 1) {
            this.markDirty();
        }
        this.name = nbt.getString("name");
        this.locked = nbt.getBoolean("lock");
        this.rewardsBlocked = nbt.getBoolean("rewards_blocked");
        this.taskProgress.clear();
        this.claimedRewards.clear();
        this.perPlayerData.clear();
        SNBTCompoundTag claimedRewardsNBT = nbt.getCompound("claimed_rewards");
        for (Object s : claimedRewardsNBT.getAllKeys()) {
            this.claimedRewards.put((Object)QuestKey.fromString((String)s), claimedRewardsNBT.getLong((String)s));
        }
        SNBTCompoundTag taskProgressNBT = nbt.getCompound("task_progress");
        for (Object s : taskProgressNBT.getAllKeys()) {
            this.taskProgress.put(this.file.getID(s), taskProgressNBT.getLong((String)s));
        }
        SNBTCompoundTag startedNBT = nbt.getCompound("started");
        for (Object s : startedNBT.getAllKeys()) {
            this.started.put(this.file.getID(s), startedNBT.getLong((String)s));
        }
        SNBTCompoundTag completedNBT = nbt.getCompound("completed");
        for (String s : completedNBT.getAllKeys()) {
            this.completed.put(this.file.getID(s), completedNBT.getLong(s));
        }
        SNBTCompoundTag ppdTag = nbt.getCompound("player_data");
        for (String key : ppdTag.getAllKeys()) {
            try {
                UUID id = UndashedUuid.fromString((String)key);
                this.perPlayerData.put((Object)id, (Object)PerPlayerData.fromNBT(ppdTag.getCompound(key), this.file));
            }
            catch (IllegalArgumentException e) {
                FTBQuests.LOGGER.error("ignoring invalid player ID {} while loading per-player data for team {}", (Object)key, (Object)this.teamId);
            }
        }
    }

    private void write(FriendlyByteBuf buffer) {
        buffer.writeUtf(this.name, Short.MAX_VALUE);
        buffer.writeVarInt(this.taskProgress.size());
        for (Long2LongMap.Entry entry : this.taskProgress.long2LongEntrySet()) {
            buffer.writeLong(entry.getLongKey());
            buffer.writeVarLong(entry.getLongValue());
        }
        long now = System.currentTimeMillis();
        buffer.writeVarInt(this.started.size());
        for (Long2LongMap.Entry entry : this.started.long2LongEntrySet()) {
            buffer.writeLong(entry.getLongKey());
            buffer.writeVarLong(now - entry.getLongValue());
        }
        buffer.writeVarInt(this.completed.size());
        for (Long2LongMap.Entry entry : this.completed.long2LongEntrySet()) {
            buffer.writeLong(entry.getLongKey());
            buffer.writeVarLong(now - entry.getLongValue());
        }
        buffer.writeBoolean(this.locked);
        buffer.writeBoolean(this.rewardsBlocked);
        buffer.writeVarInt(this.claimedRewards.size());
        for (Long2LongMap.Entry entry : this.claimedRewards.object2LongEntrySet()) {
            ((QuestKey)entry.getKey()).toNetwork(buffer);
            buffer.writeVarLong(now - entry.getLongValue());
        }
        buffer.writeVarInt(this.perPlayerData.size());
        this.perPlayerData.forEach((id, ppd) -> {
            buffer.writeUUID(id);
            ppd.writeNet(buffer);
        });
    }

    private void readNetData(FriendlyByteBuf buffer) {
        this.name = buffer.readUtf(Short.MAX_VALUE);
        this.taskProgress.clear();
        int ts = buffer.readVarInt();
        for (int i = 0; i < ts; ++i) {
            this.taskProgress.put(buffer.readLong(), buffer.readVarLong());
        }
        long now = System.currentTimeMillis();
        this.started.clear();
        int ss = buffer.readVarInt();
        for (int i = 0; i < ss; ++i) {
            this.started.put(buffer.readLong(), now - buffer.readVarLong());
        }
        this.completed.clear();
        int cs = buffer.readVarInt();
        for (int i = 0; i < cs; ++i) {
            this.completed.put(buffer.readLong(), now - buffer.readVarLong());
        }
        this.locked = buffer.readBoolean();
        this.rewardsBlocked = buffer.readBoolean();
        this.claimedRewards.clear();
        this.perPlayerData.clear();
        int claimedRewardCount = buffer.readVarInt();
        for (int i = 0; i < claimedRewardCount; ++i) {
            QuestKey key = QuestKey.fromNetwork(buffer);
            this.claimedRewards.put((Object)key, now - buffer.readVarLong());
        }
        int ppdCount = buffer.readVarInt();
        for (int i = 0; i < ppdCount; ++i) {
            UUID id = buffer.readUUID();
            this.perPlayerData.put((Object)id, (Object)PerPlayerData.fromNet(buffer));
        }
    }

    public int getRelativeProgress(QuestObject object) {
        if (this.isCompleted(object)) {
            return 100;
        }
        if (!this.isStarted(object)) {
            return 0;
        }
        return object.getRelativeProgressFromChildren(this);
    }

    public boolean isStarted(QuestObject object) {
        return this.started.containsKey(object.id);
    }

    public boolean isCompleted(QuestObject object) {
        return this.completed.containsKey(object.id);
    }

    private boolean checkDepsCached(Quest quest, Long2ByteOpenHashMap cache, ToBooleanBiFunction<Quest, TeamData> checker) {
        if (!quest.hasDependencies()) {
            return true;
        }
        byte res = cache.getOrDefault(quest.id, (byte)-1);
        if (res == -1) {
            res = checker.applyAsBoolean((Object)quest, (Object)this) ? (byte)1 : 0;
            cache.put(quest.id, res);
        }
        return res == 1;
    }

    public boolean areDependenciesComplete(Quest quest) {
        return this.checkDepsCached(quest, this.areDependenciesCompleteCache, (ToBooleanBiFunction<Quest, TeamData>)((ToBooleanBiFunction)Quest::areDependenciesComplete));
    }

    public boolean areDependenciesVisible(Quest quest) {
        return this.checkDepsCached(quest, this.areDependenciesVisibleCache, (ToBooleanBiFunction<Quest, TeamData>)((ToBooleanBiFunction)Quest::areDependenciesVisible));
    }

    public boolean canStartTasks(Quest quest) {
        return quest.getProgressionMode() == ProgressionMode.FLEXIBLE || this.areDependenciesComplete(quest);
    }

    public void claimReward(ServerPlayer player, Reward reward, boolean notify) {
        if (this.claimReward(player.getUUID(), reward, System.currentTimeMillis())) {
            reward.claim(player, notify);
        }
    }

    public Collection<ServerPlayer> getOnlineMembers() {
        return FTBTeamsAPI.api().getManager().getTeamByID(this.teamId).map(Team::getOnlineMembers).orElse(List.of());
    }

    public void checkAutoCompletion(Quest quest) {
        if (quest.getRewards().isEmpty() || !this.isCompleted(quest)) {
            return;
        }
        Collection<ServerPlayer> online = null;
        for (Reward reward : quest.getRewards()) {
            RewardAutoClaim auto = reward.getAutoClaimType();
            if (auto == RewardAutoClaim.DISABLED) continue;
            if (online == null && (online = this.getOnlineMembers()).isEmpty()) {
                return;
            }
            for (ServerPlayer player : online) {
                this.claimReward(player, reward, auto == RewardAutoClaim.ENABLED);
            }
        }
    }

    public RewardClaimType getClaimType(UUID player, Reward reward) {
        boolean r = this.isRewardClaimed(player, reward);
        if (r) {
            return RewardClaimType.CLAIMED;
        }
        if (this.isCompleted(reward.getQuest())) {
            return RewardClaimType.CAN_CLAIM;
        }
        return RewardClaimType.CANT_CLAIM;
    }

    public void resetProgress(Task task) {
        if (this.taskProgress.remove(task.id) > 0L) {
            this.markDirty();
        }
    }

    public final void setProgress(Task task, long progress) {
        if (this.locked) {
            return;
        }
        long maxProgress = task.getMaxProgress();
        progress = Math.max(0L, Math.min(progress, maxProgress));
        long prevProgress = this.getProgress(task);
        if (prevProgress != progress || progress == 0L && this.isStarted(task)) {
            if (progress == 0L) {
                this.taskProgress.remove(task.id);
                this.started.remove(task.id);
                this.completed.remove(task.id);
            } else {
                this.taskProgress.put(task.id, progress);
            }
            this.clearCachedProgress();
            if (this.file.isServerSide()) {
                Date now = new Date();
                Collection<ServerPlayer> onlineMembers = this.getOnlineMembers();
                NetworkManager.sendToPlayers(this.getOnlineMembers(), (CustomPacketPayload)new UpdateTaskProgressMessage(this.getTeamId(), task.id, progress));
                if (prevProgress == 0L) {
                    task.onStarted(new QuestProgressEventData<Task>(now, this, task, onlineMembers, Collections.emptyList()));
                }
                if (progress >= maxProgress && this.areDependenciesComplete(task.getQuest())) {
                    this.markTaskCompleted(task);
                }
            }
            this.markDirty();
        }
    }

    public void markTaskCompleted(Task task) {
        Collection<ServerPlayer> onlineMembers = this.getOnlineMembers();
        Collection<Object> notifiedPlayers = !task.getQuest().getChapter().isAlwaysInvisible() && QuestObjectBase.shouldSendNotifications() ? onlineMembers : List.of();
        task.onCompleted(new QuestProgressEventData<Task>(new Date(), this, task, onlineMembers, notifiedPlayers));
        for (ServerPlayer player : onlineMembers) {
            FTBQuestsInventoryListener.detect(player, ItemStack.EMPTY, task.id);
        }
        if (this.isCompleted(task.getQuest())) {
            this.perPlayerData.values().forEach(data -> data.pinnedQuests.remove(task.getQuest().id));
            this.markDirty();
            NetworkManager.sendToPlayers(this.getOnlineMembers(), (CustomPacketPayload)new TogglePinnedResponseMessage(task.getQuest().id, false));
        }
    }

    public final void addProgress(Task task, long progress) {
        this.setProgress(task, this.getProgress(task) + progress);
    }

    public boolean isLocked() {
        return this.locked;
    }

    public boolean setLocked(boolean newLocked) {
        if (this.locked != newLocked) {
            this.locked = newLocked;
            this.clearCachedProgress();
            this.markDirty();
            if (this.file.isServerSide()) {
                NetworkManager.sendToPlayers(this.getOnlineMembers(), (CustomPacketPayload)new SyncLockMessage(this.teamId, this.locked));
            }
            return true;
        }
        return false;
    }

    public void mergeData(TeamData from) {
        from.taskProgress.forEach((id, data) -> this.taskProgress.mergeLong(id.longValue(), data.longValue(), Long::max));
        from.started.forEach((id, data) -> this.started.mergeLong(id.longValue(), data.longValue(), (oldVal, newVal) -> oldVal));
        from.completed.forEach((id, data) -> this.completed.mergeLong(id.longValue(), data.longValue(), (oldVal, newVal) -> oldVal));
        from.claimedRewards.forEach((id, data) -> this.claimedRewards.mergeLong(id, data.longValue(), (oldVal, newVal) -> oldVal));
        from.perPlayerData.forEach((id, data) -> this.perPlayerData.merge(id, data, (oldVal, newVal) -> oldVal));
    }

    public void mergeClaimedRewards(TeamData from) {
        from.claimedRewards.forEach((questKey, data) -> {
            if (questKey.uuid().equals(this.teamId)) {
                this.claimedRewards.put(questKey, data.longValue());
            }
        });
    }

    public void copyData(TeamData from) {
        this.locked = from.locked;
        this.taskProgress.putAll((Map)from.taskProgress);
        this.claimedRewards.putAll(from.claimedRewards);
        this.started.putAll((Map)from.started);
        this.completed.putAll((Map)from.completed);
        this.perPlayerData.putAll(from.perPlayerData);
        this.rewardsBlocked = from.rewardsBlocked;
    }

    private Optional<PerPlayerData> getOrCreatePlayerData(Player player) {
        if (!this.perPlayerData.containsKey((Object)player.getUUID()) && this.file.isPlayerOnTeam(player, this)) {
            this.perPlayerData.put((Object)player.getUUID(), (Object)new PerPlayerData());
        }
        return Optional.ofNullable((PerPlayerData)this.perPlayerData.get((Object)player.getUUID()));
    }

    public boolean getCanEdit(Player player) {
        return this.getOrCreatePlayerData(player).map(d -> d.canEdit).orElse(false);
    }

    public boolean setCanEdit(Player player, boolean newCanEdit) {
        return this.getOrCreatePlayerData(player).map(playerData -> {
            if (playerData.canEdit != newCanEdit) {
                playerData.canEdit = newCanEdit;
                this.clearCachedProgress();
                this.markDirty();
                if (this.file.isServerSide() && player instanceof ServerPlayer) {
                    ServerPlayer sp = (ServerPlayer)player;
                    NetworkManager.sendToPlayer((ServerPlayer)sp, (CustomPacketPayload)new SyncEditingModeMessage(this.teamId, newCanEdit));
                }
                return true;
            }
            return false;
        }).orElse(false);
    }

    public boolean isQuestPinned(Player player, long id) {
        return this.getOrCreatePlayerData(player).map(playerData -> playerData.pinnedQuests.contains(id)).orElse(false);
    }

    public void setQuestPinned(Player player, long id, boolean pinned) {
        this.getOrCreatePlayerData(player).ifPresent(playerData -> {
            if (pinned ? playerData.pinnedQuests.add(id) : playerData.pinnedQuests.remove(id)) {
                this.markDirty();
            }
        });
    }

    public void setChapterPinned(Player player, boolean pinned) {
        this.getOrCreatePlayerData(player).ifPresent(playerData -> {
            if (playerData.chapterPinned != pinned) {
                playerData.chapterPinned = pinned;
                this.markDirty();
            }
        });
    }

    public boolean isChapterPinned(Player player) {
        return this.getOrCreatePlayerData(player).map(playerData -> playerData.chapterPinned).orElse(false);
    }

    public LongSet getPinnedQuestIds(Player player) {
        return this.getOrCreatePlayerData(player).map(playerData -> playerData.pinnedQuests).orElse(LongSet.of());
    }

    private static class PerPlayerData {
        private boolean canEdit;
        private boolean autoPin;
        private boolean chapterPinned;
        private final LongSet pinnedQuests;

        PerPlayerData() {
            this.chapterPinned = false;
            this.autoPin = false;
            this.canEdit = false;
            this.pinnedQuests = new LongOpenHashSet();
        }

        PerPlayerData(boolean canEdit, boolean autoPin, boolean chapterPinned, LongSet pinnedQuests) {
            this.canEdit = canEdit;
            this.autoPin = autoPin;
            this.chapterPinned = chapterPinned;
            this.pinnedQuests = pinnedQuests;
        }

        public boolean hasDefaultValues() {
            return !this.canEdit && !this.autoPin && !this.chapterPinned && this.pinnedQuests.isEmpty();
        }

        public static PerPlayerData fromNBT(CompoundTag nbt, BaseQuestFile file) {
            boolean canEdit = nbt.getBoolean("can_edit");
            boolean autoPin = nbt.getBoolean("auto_pin");
            boolean chapterPinned = nbt.getBoolean("chapter_pinned");
            LongSet pq = (LongSet)nbt.getList("pinned_quests", 8).stream().map(tag -> file.getID(tag.getAsString())).collect(Collectors.toCollection(LongOpenHashSet::new));
            return new PerPlayerData(canEdit, autoPin, chapterPinned, pq);
        }

        public static PerPlayerData fromNet(FriendlyByteBuf buffer) {
            PerPlayerData ppd = new PerPlayerData();
            ppd.canEdit = buffer.readBoolean();
            ppd.autoPin = buffer.readBoolean();
            ppd.chapterPinned = buffer.readBoolean();
            int pinnedCount = buffer.readVarInt();
            for (int i = 0; i < pinnedCount; ++i) {
                ppd.pinnedQuests.add(buffer.readLong());
            }
            return ppd;
        }

        public CompoundTag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            if (this.canEdit) {
                nbt.putBoolean("can_edit", true);
            }
            if (this.autoPin) {
                nbt.putBoolean("auto_pin", true);
            }
            if (this.chapterPinned) {
                nbt.putBoolean("chapter_pinned", true);
            }
            if (!this.pinnedQuests.isEmpty()) {
                long[] pinnedQuestsArray = this.pinnedQuests.toLongArray();
                Arrays.sort(pinnedQuestsArray);
                ListTag pinnedQuestsNBT = new ListTag();
                for (long l : pinnedQuestsArray) {
                    pinnedQuestsNBT.add((Object)StringTag.valueOf((String)QuestObjectBase.getCodeString(l)));
                }
                nbt.put("pinned_quests", (Tag)pinnedQuestsNBT);
            }
            return nbt;
        }

        public void writeNet(FriendlyByteBuf buffer) {
            buffer.writeBoolean(this.canEdit);
            buffer.writeBoolean(this.autoPin);
            buffer.writeBoolean(this.chapterPinned);
            buffer.writeVarInt(this.pinnedQuests.size());
            LongIterator longIterator = this.pinnedQuests.iterator();
            while (longIterator.hasNext()) {
                long reward = (Long)longIterator.next();
                buffer.writeLong(reward);
            }
        }
    }
}

