/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.net;

import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftbquests.api.FTBQuestsAPI;
import dev.ftb.mods.ftbquests.net.ToggleChapterPinnedResponseMessage;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public record ToggleChapterPinnedMessage() implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ToggleChapterPinnedMessage> TYPE = new CustomPacketPayload.Type(FTBQuestsAPI.rl("toggle_chapter_pinned_message"));
    public static final ToggleChapterPinnedMessage INSTANCE = new ToggleChapterPinnedMessage();
    public static final StreamCodec<FriendlyByteBuf, ToggleChapterPinnedMessage> STREAM_CODEC = StreamCodec.unit((Object)INSTANCE);

    public CustomPacketPayload.Type<ToggleChapterPinnedMessage> type() {
        return TYPE;
    }

    public static void handle(ToggleChapterPinnedMessage message, NetworkManager.PacketContext context) {
        context.queue(() -> {
            ServerPlayer player = (ServerPlayer)context.getPlayer();
            ServerQuestFile.INSTANCE.getTeamData((Player)player).ifPresent(data -> {
                boolean newPinned = !data.isChapterPinned((Player)player);
                data.setChapterPinned((Player)player, newPinned);
                NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ToggleChapterPinnedResponseMessage(newPinned));
            });
        });
    }
}

