/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.net;

import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftbquests.api.FTBQuestsAPI;
import dev.ftb.mods.ftbquests.client.FTBQuestsNetClient;
import dev.ftb.mods.ftbquests.integration.PermissionsHelper;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;

public record SyncEditorPermissionMessage(boolean hasPermission) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SyncEditorPermissionMessage> TYPE = new CustomPacketPayload.Type(FTBQuestsAPI.rl("sync_editor_permission_message"));
    public static final StreamCodec<FriendlyByteBuf, SyncEditorPermissionMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, SyncEditorPermissionMessage::hasPermission, SyncEditorPermissionMessage::new);

    public static SyncEditorPermissionMessage forPlayer(ServerPlayer p) {
        return new SyncEditorPermissionMessage(PermissionsHelper.hasEditorPermission(p, false));
    }

    public CustomPacketPayload.Type<SyncEditorPermissionMessage> type() {
        return TYPE;
    }

    public static void handle(SyncEditorPermissionMessage message, NetworkManager.PacketContext context) {
        context.queue(() -> FTBQuestsNetClient.setEditorPermission(message.hasPermission));
    }
}

