/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.client.gui.quests;

import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.ContextMenuItem;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.ScreenWrapper;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.WidgetLayout;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.client.FTBQuestsClient;
import dev.ftb.mods.ftbquests.client.FTBQuestsClientConfig;
import dev.ftb.mods.ftbquests.client.gui.CustomToast;
import dev.ftb.mods.ftbquests.client.gui.RewardTablesScreen;
import dev.ftb.mods.ftbquests.client.gui.quests.OtherButtonsPanel;
import dev.ftb.mods.ftbquests.client.gui.quests.TabButton;
import dev.ftb.mods.ftbquests.client.gui.quests.TooltipContextMenuItem;
import dev.ftb.mods.ftbquests.net.ChangeProgressMessage;
import dev.ftb.mods.ftbquests.net.ForceSaveMessage;
import dev.ftb.mods.ftbquests.net.ToggleEditingModeMessage;
import dev.ftb.mods.ftbquests.quest.task.StructureTask;
import dev.ftb.mods.ftbquests.quest.theme.ThemeLoader;
import dev.ftb.mods.ftbquests.quest.theme.property.ThemeProperties;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;

public class OtherButtonsPanelBottom
extends OtherButtonsPanel {
    private static final String WIKI_URL = "https://go.ftb.team/docs-quests";

    public OtherButtonsPanelBottom(Panel panel) {
        super(panel);
    }

    public void addWidgets() {
        if (this.questScreen.file.canEdit()) {
            this.add((Widget)new EditSettingsButton(this));
        }
        if (FTBQuestsClient.getClientPlayer().hasPermissions(2) || ClientQuestFile.INSTANCE.hasEditorPermission()) {
            this.add((Widget)new ToggleEditModeButton(this));
        }
        this.add((Widget)new EditPlayerPrefsButton(this));
    }

    public void alignWidgets() {
        this.setHeight(this.align(WidgetLayout.VERTICAL));
        this.setPos(this.questScreen.width - this.width, this.questScreen.height - this.height - 1);
    }

    public static class EditSettingsButton
    extends TabButton {
        public EditSettingsButton(Panel panel) {
            super(panel, (Component)Component.translatable((String)"gui.settings"), (Icon)ThemeProperties.SETTINGS_ICON.get());
        }

        public void onClicked(MouseButton button) {
            this.playClickSound();
            if (this.questScreen.getContextMenu().isPresent()) {
                this.questScreen.closeContextMenu();
                return;
            }
            ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
            contextMenu.add(new ContextMenuItem((Component)Component.translatable((String)"ftbquests.gui.edit_file"), (Icon)ThemeProperties.SETTINGS_ICON.get(), b -> this.questScreen.file.onEditButtonClicked((Runnable)((Object)this))));
            contextMenu.add(new ContextMenuItem((Component)Component.translatable((String)"ftbquests.gui.reset_progress"), (Icon)ThemeProperties.RELOAD_ICON.get(), b -> ChangeProgressMessage.sendToServer(this.questScreen.file.selfTeamData, this.questScreen.file, progressChange -> progressChange.setReset(true))).setYesNoText((Component)Component.translatable((String)"ftbquests.gui.reset_progress_q")));
            contextMenu.add(new ContextMenuItem((Component)Component.translatable((String)"ftbquests.gui.complete_instantly"), (Icon)ThemeProperties.CHECK_ICON.get(), b -> ChangeProgressMessage.sendToServer(this.questScreen.file.selfTeamData, this.questScreen.file, progressChange -> progressChange.setReset(false))).setYesNoText((Component)Component.translatable((String)"ftbquests.gui.complete_instantly_q")));
            contextMenu.add(new TooltipContextMenuItem((Component)Component.translatable((String)"ftbquests.reward_tables"), (Icon)ThemeProperties.REWARD_TABLE_ICON.get(), b -> new RewardTablesScreen(this.questScreen).openGui(), new Component[]{Component.literal((String)"[Ctrl + T]").withStyle(ChatFormatting.DARK_GRAY)}));
            contextMenu.add(new ContextMenuItem((Component)Component.translatable((String)"ftbquests.gui.save_on_server"), (Icon)ThemeProperties.SAVE_ICON.get(), b -> NetworkManager.sendToServer((CustomPacketPayload)ForceSaveMessage.INSTANCE)));
            contextMenu.add(new ContextMenuItem((Component)Component.translatable((String)"ftbquests.gui.save_as_file"), (Icon)ThemeProperties.DOWNLOAD_ICON.get(), b -> this.saveLocally()));
            contextMenu.add(new ContextMenuItem((Component)Component.translatable((String)"ftbquests.gui.reload_theme"), (Icon)ThemeProperties.RELOAD_ICON.get(), b -> this.reload_theme()));
            contextMenu.add(new ContextMenuItem((Component)Component.translatable((String)"ftbquests.gui.wiki"), Icons.INFO, b -> this.handleClick(OtherButtonsPanelBottom.WIKI_URL)));
            this.questScreen.openContextMenu(contextMenu);
        }

        private void reload_theme() {
            Minecraft mc = Minecraft.getInstance();
            ThemeLoader.loadTheme(mc.getResourceManager());
            ClientQuestFile.INSTANCE.refreshGui();
            Minecraft.getInstance().getToasts().addToast((Toast)new CustomToast((Component)Component.translatable((String)"ftbquests.gui.reload_theme"), Icons.ACCEPT, (Component)Component.translatable((String)"gui.done")));
        }

        private void saveLocally() {
            try {
                Calendar time = Calendar.getInstance();
                StringBuilder fileName = new StringBuilder("local/ftbquests/saved/");
                this.appendNum(fileName, time.get(1), '-');
                this.appendNum(fileName, time.get(2) + 1, '-');
                this.appendNum(fileName, time.get(5), '-');
                this.appendNum(fileName, time.get(11), '-');
                this.appendNum(fileName, time.get(12), '-');
                this.appendNum(fileName, time.get(13), '\u0000');
                File file = new File(Minecraft.getInstance().gameDirectory, fileName.toString()).getCanonicalFile();
                ClientQuestFile.INSTANCE.writeDataFull(file.toPath(), ClientQuestFile.INSTANCE.holderLookup());
                ClientQuestFile.INSTANCE.getTranslationManager().saveToNBT(file.toPath().resolve("lang"), true);
                MutableComponent component = Component.translatable((String)"ftbquests.gui.saved_as_file", (Object[])new Object[]{"." + file.getPath().replace(Minecraft.getInstance().gameDirectory.getCanonicalFile().getAbsolutePath(), "")});
                component.getStyle().withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_FILE, file.getAbsolutePath()));
                Minecraft.getInstance().player.sendSystemMessage((Component)component);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        private void appendNum(StringBuilder sb, int num, char c) {
            if (num < 10) {
                sb.append('0');
            }
            sb.append(num);
            if (c != '\u0000') {
                sb.append(c);
            }
        }
    }

    public static class ToggleEditModeButton
    extends TabButton {
        public ToggleEditModeButton(Panel panel) {
            super(panel, ToggleEditModeButton.makeTooltip(), ClientQuestFile.canClientPlayerEdit() ? (Icon)ThemeProperties.EDITOR_ICON_ON.get() : (Icon)ThemeProperties.EDITOR_ICON_OFF.get());
        }

        private static Component makeTooltip() {
            String key = ClientQuestFile.canClientPlayerEdit() ? "commands.ftbquests.editing_mode.enabled" : "commands.ftbquests.editing_mode.disabled";
            return Component.translatable((String)key, (Object[])new Object[]{ClientQuestFile.INSTANCE.selfTeamData.getName()});
        }

        public void onClicked(MouseButton button) {
            this.playClickSound();
            if (!this.questScreen.file.selfTeamData.getCanEdit((Player)Minecraft.getInstance().player)) {
                StructureTask.maybeRequestStructureSync();
            }
            NetworkManager.sendToServer((CustomPacketPayload)ToggleEditingModeMessage.INSTANCE);
        }
    }

    private static class EditPlayerPrefsButton
    extends TabButton {
        public EditPlayerPrefsButton(OtherButtonsPanelBottom panel) {
            super(panel, (Component)Component.translatable((String)"ftbquests.gui.preferences"), (Icon)ThemeProperties.PREFS_ICON.get());
        }

        public void onClicked(MouseButton button) {
            FTBQuestsClientConfig.openSettings((Screen)new ScreenWrapper((BaseScreen)this.questScreen));
        }
    }
}

