/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.villages;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.mixin.accessors.StructureTemplatePoolAccess;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;

public class VillageStructures {
    private static void addPieceToPool(Registry<StructureTemplatePool> templatePoolRegistry, Holder<StructureProcessorList> emptyProcessor, ResourceLocation poolRL, String nbtPieceRL, StructureTemplatePool.Projection projection, int weight) {
        StructureTemplatePool pool = (StructureTemplatePool)templatePoolRegistry.get(poolRL);
        if (pool == null) {
            return;
        }
        SinglePoolElement piece = poolRL.getPath().endsWith("streets") ? (SinglePoolElement)SinglePoolElement.legacy((String)nbtPieceRL, emptyProcessor).apply(projection) : (SinglePoolElement)SinglePoolElement.single((String)nbtPieceRL, emptyProcessor).apply(projection);
        StructureTemplatePoolAccess access = (StructureTemplatePoolAccess)pool;
        for (int i = 0; i < weight; ++i) {
            access.getTemplates().add((Object)piece);
        }
        ArrayList<Pair<StructurePoolElement, Integer>> listOfPieceEntries = new ArrayList<Pair<StructurePoolElement, Integer>>(access.getRawTemplates());
        listOfPieceEntries.add((Pair<StructurePoolElement, Integer>)new Pair((Object)piece, (Object)weight));
        access.setRawTemplates(listOfPieceEntries);
    }

    public static void addMechanicHouse(ServerAboutToStartEvent event) {
        int weight = (Integer)ConfigHelper.common().villagers.mechanicHouseWeight.get();
        if (weight > 0) {
            Holder.Reference emptyProcessor = event.getServer().registryAccess().registryOrThrow(Registries.PROCESSOR_LIST).getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.PROCESSOR_LIST, (ResourceLocation)ResourceLocation.parse((String)"minecraft:empty")));
            Registry templatePoolRegistry = event.getServer().registryAccess().registryOrThrow(Registries.TEMPLATE_POOL);
            for (VillageBiome v : VillageBiome.values()) {
                if (v.needsCustomStreet()) {
                    VillageStructures.addPieceToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Holder<StructureProcessorList>)emptyProcessor, ResourceLocation.parse((String)("village/" + v.getBiomeName() + "/streets")), "pneumaticcraft:village/custom_street_" + v.getBiomeName(), StructureTemplatePool.Projection.TERRAIN_MATCHING, Math.max(1, weight / 4));
                    continue;
                }
                VillageStructures.addPieceToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Holder<StructureProcessorList>)emptyProcessor, ResourceLocation.parse((String)("village/" + v.getBiomeName() + "/houses")), "pneumaticcraft:village/mechanic_house_" + v.getBiomeName(), StructureTemplatePool.Projection.RIGID, weight);
            }
        }
    }

    static enum VillageBiome {
        PLAINS("plains", false),
        DESERT("desert", true),
        SAVANNA("savanna", false),
        TAIGA("taiga", false),
        SNOWY("snowy", true);

        private final String biomeName;
        private final boolean needsCustomStreet;

        private VillageBiome(String biomeName, boolean needsCustomStreet) {
            this.biomeName = biomeName;
            this.needsCustomStreet = needsCustomStreet;
        }

        public String getBiomeName() {
            return this.biomeName;
        }

        public boolean needsCustomStreet() {
            return this.needsCustomStreet;
        }
    }
}

