/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util;

import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforge.fluids.SimpleFluidContent;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class PNCFluidTank
implements IFluidHandler,
IFluidTank {
    protected Predicate<FluidStack> validator;
    @Nonnull
    protected FluidStack fluidStack = FluidStack.EMPTY;
    protected int capacity;

    public PNCFluidTank(int capacity) {
        this(capacity, e -> true);
    }

    public PNCFluidTank(int capacity, Predicate<FluidStack> validator) {
        this.capacity = capacity;
        this.validator = validator;
    }

    public PNCFluidTank setCapacity(int capacity) {
        this.capacity = capacity;
        return this;
    }

    public PNCFluidTank setValidator(Predicate<FluidStack> validator) {
        if (validator != null) {
            this.validator = validator;
        }
        return this;
    }

    public boolean isFluidValid(FluidStack stack) {
        return this.validator.test(stack);
    }

    public int getCapacity() {
        return this.capacity;
    }

    @Nonnull
    public FluidStack getFluid() {
        return this.fluidStack;
    }

    public int getFluidAmount() {
        return this.fluidStack.getAmount();
    }

    public PNCFluidTank readFromNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        FluidStack fluid = FluidStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)nbt);
        this.setFluid(fluid);
        return this;
    }

    public Tag writeToNBT(HolderLookup.Provider provider) {
        return this.fluidStack.saveOptional(provider);
    }

    public int getTanks() {
        return 1;
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        return this.getFluid();
    }

    public int getTankCapacity(int tank) {
        return this.getCapacity();
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return this.isFluidValid(stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty() || !this.isFluidValid(resource)) {
            return 0;
        }
        if (action.simulate()) {
            if (this.fluidStack.isEmpty()) {
                return Math.min(this.capacity, resource.getAmount());
            }
            if (!FluidStack.isSameFluidSameComponents((FluidStack)this.fluidStack, (FluidStack)resource)) {
                return 0;
            }
            return Math.min(this.capacity - this.fluidStack.getAmount(), resource.getAmount());
        }
        FluidStack prevStack = this.fluidStack.copy();
        if (this.fluidStack.isEmpty()) {
            this.fluidStack = new FluidStack(resource.getFluid(), Math.min(this.capacity, resource.getAmount()));
            this.onContentsChanged(prevStack);
            return this.fluidStack.getAmount();
        }
        if (!FluidStack.isSameFluidSameComponents((FluidStack)this.fluidStack, (FluidStack)resource)) {
            return 0;
        }
        int filled = this.capacity - this.fluidStack.getAmount();
        if (resource.getAmount() < filled) {
            this.fluidStack.grow(resource.getAmount());
            filled = resource.getAmount();
        } else {
            this.fluidStack.setAmount(this.capacity);
        }
        if (filled > 0) {
            this.onContentsChanged(prevStack);
        }
        return filled;
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty() || !FluidStack.isSameFluidSameComponents((FluidStack)resource, (FluidStack)this.fluidStack)) {
            return FluidStack.EMPTY;
        }
        return this.drain(resource.getAmount(), action);
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        int drained = maxDrain;
        if (this.fluidStack.getAmount() < drained) {
            drained = this.fluidStack.getAmount();
        }
        FluidStack stack = new FluidStack(this.fluidStack.getFluid(), drained);
        if (action.execute() && drained > 0) {
            FluidStack prevStack = this.fluidStack.copy();
            this.fluidStack.shrink(drained);
            this.onContentsChanged(prevStack);
        }
        return stack;
    }

    protected void onContentsChanged(FluidStack prevStack) {
    }

    public void setFluid(FluidStack stack) {
        FluidStack prevStack = this.fluidStack.copy();
        this.fluidStack = stack;
        this.onContentsChanged(prevStack);
    }

    public boolean isEmpty() {
        return this.fluidStack.isEmpty();
    }

    public int getSpace() {
        return Math.max(0, this.capacity - this.fluidStack.getAmount());
    }

    public SimpleFluidContent getContent() {
        return SimpleFluidContent.copyOf((FluidStack)this.fluidStack);
    }

    public void loadFromContent(SimpleFluidContent contents) {
        this.fluidStack = contents.copy();
    }
}

