/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.upgrades;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import me.desht.pneumaticcraft.api.misc.Symbols;
import me.desht.pneumaticcraft.api.upgrade.IUpgradeRegistry;
import me.desht.pneumaticcraft.api.upgrade.PNCUpgrade;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.item.UpgradeItem;
import me.desht.pneumaticcraft.common.upgrades.PNCUpgradeImpl;
import me.desht.pneumaticcraft.common.upgrades.UpgradableItemUtils;
import me.desht.pneumaticcraft.mixin.accessors.BlockEntityTypeAccess;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;

public enum ApplicableUpgradesDB implements IUpgradeRegistry
{
    INSTANCE;

    private static final int MAX_UPGRADES_IN_TOOLTIP = 12;
    private final Table<BlockEntityType<?>, PNCUpgrade, Integer> TILE_ENTITIES = Tables.synchronizedTable((Table)HashBasedTable.create());
    private final Table<EntityType<?>, PNCUpgrade, Integer> ENTITIES = Tables.synchronizedTable((Table)HashBasedTable.create());
    private final Table<Item, PNCUpgrade, Integer> ITEMS = Tables.synchronizedTable((Table)HashBasedTable.create());
    private final Map<ResourceLocation, PNCUpgrade> knownUpgrades = new ConcurrentHashMap<ResourceLocation, PNCUpgrade>();
    private final Map<PNCUpgrade, Set<Item>> acceptedUpgrades = new ConcurrentHashMap<PNCUpgrade, Set<Item>>();

    public static ApplicableUpgradesDB getInstance() {
        return INSTANCE;
    }

    @Override
    public void addApplicableUpgrades(BlockEntityType<?> type, IUpgradeRegistry.Builder builder) {
        this.addUpgrades(this.TILE_ENTITIES, type, builder);
    }

    @Override
    public void addApplicableUpgrades(EntityType<?> type, IUpgradeRegistry.Builder builder) {
        this.addUpgrades(this.ENTITIES, type, builder);
    }

    @Override
    public void addApplicableUpgrades(Item item, IUpgradeRegistry.Builder builder) {
        this.addUpgrades(this.ITEMS, item, builder);
    }

    @Override
    public int getMaxUpgrades(BlockEntity te, PNCUpgrade upgrade) {
        if (te == null || upgrade == null) {
            return 0;
        }
        Integer max = (Integer)this.TILE_ENTITIES.get((Object)te.getType(), (Object)upgrade);
        return max == null ? 0 : max;
    }

    @Override
    public int getMaxUpgrades(Entity entity, PNCUpgrade upgrade) {
        if (entity == null || upgrade == null) {
            return 0;
        }
        Integer max = (Integer)this.ENTITIES.get((Object)entity.getType(), (Object)upgrade);
        return max == null ? 0 : max;
    }

    @Override
    public int getMaxUpgrades(Item item, PNCUpgrade upgrade) {
        if (item == null || upgrade == null) {
            return 0;
        }
        Integer max = (Integer)this.ITEMS.get((Object)item, (Object)upgrade);
        return max == null ? 0 : max;
    }

    @Override
    public void addUpgradeTooltip(PNCUpgrade upgrade, List<Component> tooltip) {
        Collection<Item> acceptors = ApplicableUpgradesDB.getInstance().getItemsWhichAccept(upgrade);
        if (!acceptors.isEmpty()) {
            ArrayList<Object> tempList = new ArrayList<Object>(acceptors.size());
            for (Item acceptor : acceptors) {
                tempList.add(Symbols.bullet().append((Component)acceptor.getDescription().copy().withStyle(ChatFormatting.DARK_AQUA)));
            }
            tempList.sort(Comparator.comparing(Component::getString));
            if (tempList.size() > 12) {
                int n = (int)(ClientUtils.getClientLevel().getGameTime() / 8L % (long)acceptors.size());
                ArrayList<Component> tempList2 = new ArrayList<Component>(12);
                for (int i = 0; i < 12; ++i) {
                    tempList2.add((Component)tempList.get((n + i) % acceptors.size()));
                }
                tooltip.addAll(tempList2);
            } else {
                tooltip.addAll(tempList);
            }
        }
    }

    @Override
    public PNCUpgrade registerUpgrade(ResourceLocation id, int maxTier, String ... depModIds) {
        PNCUpgradeImpl upgrade = new PNCUpgradeImpl(id, maxTier, depModIds);
        if (this.knownUpgrades.put(upgrade.getId(), upgrade) != null) {
            throw new IllegalStateException("duplicate upgrade ID: " + String.valueOf(id));
        }
        return upgrade;
    }

    @Override
    public PNCUpgrade getUpgradeById(ResourceLocation upgradeId) {
        return this.knownUpgrades.get(upgradeId);
    }

    @Override
    public Collection<PNCUpgrade> getKnownUpgrades() {
        return Collections.unmodifiableCollection(this.knownUpgrades.values());
    }

    @Override
    public Item makeUpgradeItem(PNCUpgrade upgrade, int tier, Rarity rarity) {
        return new UpgradeItem(upgrade, tier, rarity);
    }

    @Override
    public Item makeUpgradeItem(PNCUpgrade upgrade, int tier, Item.Properties properties) {
        return new UpgradeItem(upgrade, tier, properties);
    }

    @Override
    public int getUpgradeCount(ItemStack stack, PNCUpgrade upgrade) {
        return UpgradableItemUtils.getUpgradeCount(stack, upgrade);
    }

    @Override
    public Map<PNCUpgrade, Integer> getUpgradesInItem(ItemStack stack) {
        return UpgradableItemUtils.getUpgrades(stack);
    }

    public Collection<Item> getItemsWhichAccept(PNCUpgrade upgrade) {
        return this.acceptedUpgrades.getOrDefault(upgrade, Collections.emptySet());
    }

    public Map<PNCUpgrade, Integer> getApplicableUpgrades(BlockEntity te) {
        return this.TILE_ENTITIES.row((Object)te.getType());
    }

    public Map<PNCUpgrade, Integer> getApplicableUpgrades(Entity e) {
        return this.ENTITIES.row((Object)e.getType());
    }

    public Map<PNCUpgrade, Integer> getApplicableUpgrades(Item item) {
        return this.ITEMS.row((Object)item);
    }

    private <T> void addUpgrades(Table<T, PNCUpgrade, Integer> table, T entry, IUpgradeRegistry.Builder builder) {
        builder.getUpgrades().forEach((upgrade, max) -> {
            table.put(entry, upgrade, max);
            if (entry instanceof Item) {
                Item item2 = (Item)entry;
                this.addAccepted((PNCUpgrade)upgrade, item2);
            } else if (entry instanceof BlockEntityType) {
                BlockEntityType beType = (BlockEntityType)entry;
                ((BlockEntityTypeAccess)beType).getValidBlocks().stream().map(Block::asItem).filter(item -> item != Items.AIR).forEach(item -> this.addAccepted((PNCUpgrade)upgrade, (Item)item));
            }
        });
    }

    private void addAccepted(PNCUpgrade upgrade, Item item) {
        this.acceptedUpgrades.computeIfAbsent(upgrade, k -> ConcurrentHashMap.newKeySet()).add(item);
    }
}

