/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tubemodules;

import java.util.Optional;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerMachine;
import me.desht.pneumaticcraft.common.block.PressureTubeBlock;
import me.desht.pneumaticcraft.common.block.entity.tube.PressureTubeBlockEntity;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.tubemodules.AbstractRedstoneReceivingModule;
import me.desht.pneumaticcraft.common.tubemodules.IInfluenceDispersing;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;

public class VacuumModule
extends AbstractRedstoneReceivingModule
implements IInfluenceDispersing {
    private BlockCapabilityCache<IAirHandlerMachine, Direction> airHandlerCache;
    public float rotation;
    public float oldRotation;
    private int lastAmount = 0;

    public VacuumModule(Direction dir, PressureTubeBlockEntity pressureTube) {
        super(dir, pressureTube);
    }

    @Override
    public Item getItem() {
        return (Item)ModItems.VACUUM_MODULE.get();
    }

    @Override
    public void tickCommon() {
        this.oldRotation = this.rotation;
        this.rotation += (float)this.lastAmount / 5.0f;
    }

    @Override
    public void tickServer() {
        super.tickServer();
        int prevLast = this.lastAmount;
        PressureTubeBlockEntity tube = this.getTube();
        if (tube.getPressure() >= 2.0f && this.getCachedNeighbourAirHandler().isPresent() && this.getReceivingRedstoneLevel() == 0) {
            int toAdd = (int)(-10.0f * (this.upgraded ? 7.41f : 1.0f));
            int toTake = (int)(-4.0f * (this.upgraded ? 5.06f : 1.0f));
            this.lastAmount = this.getCachedNeighbourAirHandler().map(h -> {
                int air = h.getAir();
                float pressure = h.getPressure();
                h.addAir(toTake);
                return PneumaticCraftUtils.epsilonEquals(pressure, h.getPressure()) ? 0 : air - h.getAir();
            }).orElse(0);
            if (this.lastAmount != 0) {
                tube.addAir(toAdd * -this.lastAmount / toTake);
            }
        } else {
            this.lastAmount = 0;
        }
        if (prevLast != this.lastAmount) {
            tube.sendDescriptionPacket();
        }
    }

    @Override
    public boolean isInline() {
        return true;
    }

    public int getLastAmount() {
        return this.lastAmount;
    }

    public void setLastAmount(int lastAmount) {
        this.lastAmount = lastAmount;
    }

    private Optional<IAirHandlerMachine> getCachedNeighbourAirHandler() {
        Level level;
        if (this.airHandlerCache == null && (level = this.pressureTube.getLevel()) instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            this.airHandlerCache = BlockCapabilityCache.create(PNCCapabilities.AIR_HANDLER_MACHINE, (ServerLevel)level2, (BlockPos)this.pressureTube.getBlockPos().relative(this.dir), (Object)this.dir.getOpposite(), () -> !this.pressureTube.isRemoved(), () -> {
                this.airHandlerCache = null;
            });
        }
        return this.airHandlerCache == null ? Optional.empty() : Optional.ofNullable((IAirHandlerMachine)this.airHandlerCache.getCapability());
    }

    @Override
    public int getMaxDispersion() {
        return 0;
    }

    @Override
    public void onAirDispersion(int amount) {
    }

    @Override
    public void readFromNBT(CompoundTag tag) {
        super.readFromNBT(tag);
        this.lastAmount = tag.getInt("lastAmount");
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag tag) {
        tag.putInt("lastAmount", this.lastAmount);
        return super.writeToNBT(tag);
    }

    @Override
    public boolean isInlineAndFocused(PressureTubeBlock.TubeHitInfo hitInfo) {
        return true;
    }
}

