/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.patchouli;

import com.google.common.collect.ImmutableList;
import java.util.List;
import me.desht.pneumaticcraft.api.crafting.recipe.PressureChamberRecipe;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.registry.ModRecipeTypes;
import me.desht.pneumaticcraft.common.thirdparty.patchouli.PatchouliAccess;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class ProcessorPressureChamber
implements IComponentProcessor {
    private PressureChamberRecipe recipe = null;
    private String header = null;

    public void setup(Level level, IVariableProvider iVariableProvider) {
        ResourceLocation recipeId = ResourceLocation.parse((String)iVariableProvider.get("recipe", (HolderLookup.Provider)level.registryAccess()).asString());
        ModRecipeTypes.PRESSURE_CHAMBER.get().getRecipe((Level)Minecraft.getInstance().level, recipeId).ifPresentOrElse(h -> {
            this.recipe = (PressureChamberRecipe)h.value();
        }, () -> Log.warning("Missing pressure chamber recipe: " + String.valueOf(recipeId), new Object[0]));
        this.header = iVariableProvider.has("header") ? iVariableProvider.get("header", (HolderLookup.Provider)level.registryAccess()).asString() : "";
    }

    public IVariable process(Level level, String s) {
        if (this.recipe == null) {
            return null;
        }
        if (s.equals("header")) {
            return IVariable.wrap((String)(this.header.isEmpty() ? this.defaultHeader() : this.header), (HolderLookup.Provider)level.registryAccess());
        }
        if (s.startsWith("input")) {
            int index = Integer.parseInt(s.substring(5)) - 1;
            if (index >= 0 && index < this.recipe.getInputsForDisplay((HolderLookup.Provider)ClientUtils.getClientLevel().registryAccess()).size()) {
                return PatchouliAccess.getStacks(this.recipe.getInputsForDisplay((HolderLookup.Provider)ClientUtils.getClientLevel().registryAccess()).get(index), (HolderLookup.Provider)level.registryAccess());
            }
        } else if (s.startsWith("output")) {
            int index = Integer.parseInt(s.substring(6)) - 1;
            List<List<ItemStack>> results = this.recipe.getResultsForDisplay((HolderLookup.Provider)ClientUtils.getClientLevel().registryAccess());
            if (index >= 0 && index < results.size()) {
                return IVariable.wrapList((Iterable)((Iterable)results.get(index).stream().map(object -> IVariable.from((Object)object, (HolderLookup.Provider)level.registryAccess())).collect(ImmutableList.toImmutableList())), (HolderLookup.Provider)level.registryAccess());
            }
        } else if (s.equals("pressure")) {
            String pr = PneumaticCraftUtils.roundNumberTo(this.recipe.getCraftingPressureForDisplay(), 1);
            return IVariable.wrap((String)I18n.get((String)"pneumaticcraft.patchouli.processor.pressureChamber.desc", (Object[])new Object[]{pr}), (HolderLookup.Provider)level.registryAccess());
        }
        return null;
    }

    private String defaultHeader() {
        List<ItemStack> stacks;
        List<List<ItemStack>> results = this.recipe.getResultsForDisplay((HolderLookup.Provider)ClientUtils.getClientLevel().registryAccess());
        if (!results.isEmpty() && !(stacks = results.getFirst()).isEmpty()) {
            return stacks.getFirst().getHoverName().getString();
        }
        return "";
    }
}

