/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.patchouli;

import me.desht.pneumaticcraft.api.crafting.recipe.AmadronRecipe;
import me.desht.pneumaticcraft.common.registry.ModRecipeTypes;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class ProcessorAmadronTrade
implements IComponentProcessor {
    private AmadronRecipe recipe = null;
    private String text = null;

    public void setup(Level level, IVariableProvider iVariableProvider) {
        ResourceLocation recipeId = ResourceLocation.parse((String)iVariableProvider.get("recipe", (HolderLookup.Provider)level.registryAccess()).asString());
        ModRecipeTypes.AMADRON.get().getRecipe((Level)Minecraft.getInstance().level, recipeId).ifPresentOrElse(holder -> {
            this.recipe = (AmadronRecipe)holder.value();
        }, () -> Log.warning("Missing amadron offer recipe: " + String.valueOf(recipeId), new Object[0]));
        this.text = iVariableProvider.has("text") ? iVariableProvider.get("text", (HolderLookup.Provider)level.registryAccess()).asString() : null;
    }

    public IVariable process(Level level, String key) {
        if (this.recipe == null) {
            return null;
        }
        return switch (key) {
            case "input" -> IVariable.from((Object)this.recipe.getInput().apply(itemStack -> itemStack, fluidStack -> fluidStack), (HolderLookup.Provider)level.registryAccess());
            case "output" -> IVariable.from((Object)this.recipe.getOutput().apply(itemStack -> itemStack, fluidStack -> fluidStack), (HolderLookup.Provider)level.registryAccess());
            case "name" -> IVariable.wrap((String)this.recipe.getOutput().getName(), (HolderLookup.Provider)level.registryAccess());
            case "text" -> IVariable.wrap((String)(this.text == null ? "" : I18n.get((String)this.text, (Object[])new Object[0])), (HolderLookup.Provider)level.registryAccess());
            default -> null;
        };
    }
}

