/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.gamestages;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import me.desht.pneumaticcraft.api.misc.IPlayerMatcher;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.darkhax.gamestages.GameStageHelper;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.player.Player;

public record GamestagesMatcher(List<String> stages, boolean matchAll) implements IPlayerMatcher
{
    private static final Function<String, DataResult<String>> STAGE_CHECKER = s -> GameStageHelper.isStageKnown((String)s) ? DataResult.success((Object)s) : DataResult.error(() -> "unknown stage: " + s);
    private static final Codec<String> STAGE_CODEC = Codec.STRING.flatXmap(STAGE_CHECKER, STAGE_CHECKER);
    public static final MapCodec<GamestagesMatcher> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)STAGE_CODEC.listOf().fieldOf("stages").forGetter(GamestagesMatcher::stages), (App)Codec.BOOL.optionalFieldOf("match_all", (Object)false).forGetter(GamestagesMatcher::matchAll)).apply((Applicative)builder, GamestagesMatcher::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, GamestagesMatcher> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8.apply(ByteBufCodecs.list()), GamestagesMatcher::stages, (StreamCodec)ByteBufCodecs.BOOL, GamestagesMatcher::matchAll, GamestagesMatcher::new);
    public static final IPlayerMatcher.MatcherType<GamestagesMatcher> TYPE = new IPlayerMatcher.MatcherType<GamestagesMatcher>(CODEC, STREAM_CODEC);

    @Override
    public IPlayerMatcher.MatcherType<? extends IPlayerMatcher> type() {
        return TYPE;
    }

    @Override
    public void addDescription(Player player, List<Component> tooltip) {
        if (!this.stages.isEmpty()) {
            MutableComponent header = PneumaticCraftUtils.xlate("pneumaticcraft.playerFilter.gamestages", new Object[0]).append(" (").append((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.misc." + (this.matchAll ? "all" : "any"), new Object[0])).append(")");
            List<Component> items = this.stages.stream().map(Component::literal).collect(Collectors.toList());
            this.standardTooltip(player, tooltip, (Component)header, items);
        }
    }

    @Override
    public boolean test(Player playerEntity) {
        return this.matchAll ? GameStageHelper.hasAllOf((Player)playerEntity, this.stages) : GameStageHelper.hasAnyOf((Player)playerEntity, this.stages);
    }
}

