/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.heat.behaviour;

import java.util.HashSet;
import java.util.Stack;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.crafting.recipe.HeatPropertiesRecipe;
import me.desht.pneumaticcraft.api.heat.HeatBehaviour;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.common.heat.BlockHeatProperties;
import me.desht.pneumaticcraft.common.heat.behaviour.HeatBehaviourTransition;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.FluidUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class HeatBehaviourCustomTransition
extends HeatBehaviourTransition {
    static final ResourceLocation ID = PneumaticRegistry.RL("custom_transition");
    private HeatPropertiesRecipe heatEntry;

    @Override
    public HeatBehaviour initialize(IHeatExchangerLogic connectedHeatLogic, Level world, BlockPos pos, Direction direction) {
        super.initialize(connectedHeatLogic, world, pos, direction);
        this.heatEntry = BlockHeatProperties.getInstance().getCustomHeatEntry(world, this.getBlockState());
        return this;
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public boolean isApplicable() {
        return super.isApplicable() && this.heatEntry != null && this.heatEntry.getHeatCapacity().orElse(0) > 0;
    }

    @Override
    protected int getMaxExchangedHeat() {
        return this.heatEntry.getHeatCapacity().orElse(0);
    }

    @Override
    protected boolean transformBlockHot() {
        return this.heatEntry.getTransformHot().map(hot -> {
            if (this.getFluid() != null) {
                this.transformFluidBlocks((BlockState)hot, this.heatEntry.getTransformHotFlowing().orElse(Blocks.AIR.defaultBlockState()));
                return true;
            }
            return this.getWorld().setBlockAndUpdate(this.getPos(), hot);
        }).orElse(false);
    }

    @Override
    protected boolean transformBlockCold() {
        return this.heatEntry.getTransformCold().map(cold -> {
            if (this.getFluid() != null) {
                this.transformFluidBlocks((BlockState)cold, this.heatEntry.getTransformColdFlowing().orElse(Blocks.AIR.defaultBlockState()));
                return true;
            }
            return this.getWorld().setBlockAndUpdate(this.getPos(), cold);
        }).orElse(false);
    }

    private void transformFluidBlocks(@NotNull BlockState turningBlockSource, @NotNull BlockState turningBlockFlowing) {
        if (FluidUtils.isSourceFluidBlock(this.getWorld(), this.getPos())) {
            this.getWorld().setBlockAndUpdate(this.getPos(), turningBlockSource);
            this.onTransition(this.getPos());
        } else {
            HashSet<BlockPos> traversed = new HashSet<BlockPos>();
            Stack<BlockPos> pending = new Stack<BlockPos>();
            pending.push(this.getPos());
            traversed.add(this.getPos());
            while (!pending.isEmpty()) {
                BlockPos pos = (BlockPos)pending.pop();
                for (Direction d : DirectionUtil.VALUES) {
                    BlockPos newPos = pos.relative(d);
                    Block checkingBlock = this.getWorld().getBlockState(newPos).getBlock();
                    if (checkingBlock != this.getBlockState().getBlock() || !traversed.add(newPos)) continue;
                    if (FluidUtils.isSourceFluidBlock(this.getWorld(), newPos)) {
                        this.getWorld().setBlockAndUpdate(newPos, turningBlockSource);
                        this.onTransition(newPos);
                        return;
                    }
                    this.getWorld().setBlockAndUpdate(newPos, turningBlockFlowing);
                    this.onTransition(newPos);
                    pending.push(newPos);
                }
            }
        }
    }
}

