/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import me.desht.pneumaticcraft.api.drone.IDrone;
import me.desht.pneumaticcraft.api.drone.IProgWidget;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.drone.progwidgets.IStandbyWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.entity.drone.DroneEntity;
import me.desht.pneumaticcraft.common.registry.ModProgWidgetTypes;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.DyeColor;

public class ProgWidgetStandby
extends ProgWidget
implements IStandbyWidget {
    public static final MapCodec<ProgWidgetStandby> CODEC = RecordCodecBuilder.mapCodec(builder -> ProgWidgetStandby.baseParts(builder).and((App)Codec.BOOL.optionalFieldOf("allow_pickup", (Object)false).forGetter(ProgWidgetStandby::allowPickupOnStandby)).apply((Applicative)builder, ProgWidgetStandby::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ProgWidgetStandby> STREAM_CODEC = StreamCodec.composite(ProgWidget.PositionFields.STREAM_CODEC, ProgWidget::getPosition, (StreamCodec)ByteBufCodecs.BOOL, ProgWidgetStandby::allowPickupOnStandby, ProgWidgetStandby::new);
    private boolean allowStandbyPickup;

    public ProgWidgetStandby(ProgWidget.PositionFields pos, boolean allowStandbyPickup) {
        super(pos);
        this.allowStandbyPickup = allowStandbyPickup;
    }

    public ProgWidgetStandby() {
        this(ProgWidget.PositionFields.DEFAULT, false);
    }

    @Override
    public IProgWidget copyWidget() {
        return new ProgWidgetStandby(this.getPosition(), this.allowStandbyPickup);
    }

    @Override
    public boolean hasStepInput() {
        return true;
    }

    @Override
    public ProgWidgetType<?> returnType() {
        return null;
    }

    @Override
    public List<ProgWidgetType<?>> getParameters() {
        return Collections.emptyList();
    }

    @Override
    public DyeColor getColor() {
        return DyeColor.LIME;
    }

    @Override
    public IProgWidget.WidgetDifficulty getDifficulty() {
        return IProgWidget.WidgetDifficulty.EASY;
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_STANDBY;
    }

    @Override
    public Goal getWidgetAI(IDrone drone, IProgWidget widget) {
        return new DroneAIStandby((DroneEntity)drone, (ProgWidget)widget);
    }

    @Override
    public ProgWidgetType<?> getType() {
        return ModProgWidgetTypes.STANDBY.get();
    }

    @Override
    public void getTooltip(List<Component> curTooltip) {
        super.getTooltip(curTooltip);
        if (this.allowStandbyPickup) {
            curTooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.standby.allowPickup", new Object[0]));
        }
    }

    @Override
    public boolean allowPickupOnStandby() {
        return this.allowStandbyPickup;
    }

    @Override
    public void setAllowStandbyPickup(boolean allowStandbyPickup) {
        this.allowStandbyPickup = allowStandbyPickup;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProgWidgetStandby that = (ProgWidgetStandby)o;
        return this.baseEquals(that) && this.allowStandbyPickup == that.allowStandbyPickup;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.baseHashCode(), this.allowStandbyPickup);
    }

    public static class DroneAIStandby
    extends Goal {
        private final DroneEntity drone;
        private final ProgWidget widget;

        DroneAIStandby(DroneEntity drone, ProgWidget widget) {
            this.drone = drone;
            this.widget = widget;
        }

        public boolean canUse() {
            IStandbyWidget s;
            ProgWidget progWidget = this.widget;
            boolean allowPickup = progWidget instanceof IStandbyWidget && (s = (IStandbyWidget)((Object)progWidget)).allowPickupOnStandby();
            this.drone.setStandby(true, allowPickup);
            return false;
        }
    }
}

