/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashSet;
import java.util.List;
import me.desht.pneumaticcraft.api.drone.IDrone;
import me.desht.pneumaticcraft.api.drone.IProgWidget;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.drone.ai.DroneAIBlockCondition;
import me.desht.pneumaticcraft.common.drone.progwidgets.ICondition;
import me.desht.pneumaticcraft.common.drone.progwidgets.ISidedWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetAreaItemBase;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetCondition;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetInventoryBase;
import me.desht.pneumaticcraft.common.registry.ModProgWidgetTypes;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;

public class ProgWidgetItemInventoryCondition
extends ProgWidgetCondition {
    public static final MapCodec<ProgWidgetItemInventoryCondition> CODEC = RecordCodecBuilder.mapCodec(builder -> ProgWidgetItemInventoryCondition.condParts(builder).apply((Applicative)builder, ProgWidgetItemInventoryCondition::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ProgWidgetItemInventoryCondition> STREAM_CODEC = StreamCodec.composite(ProgWidget.PositionFields.STREAM_CODEC, ProgWidget::getPosition, ProgWidgetInventoryBase.InvBaseFields.STREAM_CODEC, ProgWidgetInventoryBase::invBaseFields, ProgWidgetCondition.ConditionFields.STREAM_CODEC, ProgWidgetCondition::conditionFields, ProgWidgetItemInventoryCondition::new);

    public ProgWidgetItemInventoryCondition() {
    }

    public ProgWidgetItemInventoryCondition(ProgWidget.PositionFields pos, ProgWidgetInventoryBase.InvBaseFields inv, ProgWidgetCondition.ConditionFields cond) {
        super(pos, inv, cond);
    }

    @Override
    public IProgWidget copyWidget() {
        return new ProgWidgetItemInventoryCondition(this.getPosition(), this.invBaseFields().copy(), this.conditionFields());
    }

    @Override
    public List<ProgWidgetType<?>> getParameters() {
        return ImmutableList.of(ModProgWidgetTypes.AREA.get(), ModProgWidgetTypes.ITEM_FILTER.get(), ModProgWidgetTypes.TEXT.get());
    }

    @Override
    protected DroneAIBlockCondition getEvaluator(IDrone drone, IProgWidget widget) {
        return new DroneAIBlockCondition(drone, (ProgWidgetAreaItemBase)widget){

            @Override
            protected boolean evaluate(BlockPos pos) {
                BlockEntity te = this.drone.getDroneLevel().getBlockEntity(pos);
                HashSet handlers = new HashSet();
                for (Direction dir : DirectionUtil.VALUES) {
                    if (!((ISidedWidget)((Object)this.progWidget)).isSideSelected(dir)) continue;
                    IOHelper.getInventoryForBlock(te, dir).ifPresent(handlers::add);
                }
                int count = 0;
                for (IItemHandler handler : handlers) {
                    for (int i = 0; i < handler.getSlots(); ++i) {
                        ItemStack stack = handler.getStackInSlot(i);
                        if (!this.progWidget.isItemValidForFilters(stack)) continue;
                        count += stack.getCount();
                    }
                }
                ProgWidgetItemInventoryCondition.this.maybeRecordMeasuredVal(this.drone, count);
                return ((ICondition)((Object)this.progWidget)).getOperator().evaluate(count, ((ICondition)((Object)this.progWidget)).getRequiredCount());
            }
        };
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_CONDITION_ITEM_INVENTORY;
    }

    @Override
    public ProgWidgetType<?> getType() {
        return ModProgWidgetTypes.CONDITION_ITEM_INVENTORY.get();
    }
}

