/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity.utility;

import java.util.HashSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.common.block.entity.utility.DisplayTableBlockEntity;
import me.desht.pneumaticcraft.common.inventory.TagWorkbenchMenu;
import me.desht.pneumaticcraft.common.item.TagFilterItem;
import me.desht.pneumaticcraft.common.registry.ModBlockEntityTypes;
import me.desht.pneumaticcraft.common.registry.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;

public class TagWorkbenchBlockEntity
extends DisplayTableBlockEntity
implements MenuProvider {
    public static final int PAPER_SLOT = 1;
    public static final int OUTPUT_SLOT = 2;
    private final TagMatcherItemHandler inventory = new TagMatcherItemHandler();
    public int paperItemId;
    public int outputItemId;

    public TagWorkbenchBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntityTypes.TAG_WORKBENCH.get(), pos, state);
    }

    @Override
    public IItemHandler getItemHandler(@Nullable Direction dir) {
        return this.inventory;
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayer player) {
        if (tag.startsWith("write:")) {
            String[] data = tag.substring(6).split(",");
            if (data.length == 0) {
                return;
            }
            ItemStack outputStack = ItemStack.EMPTY;
            if (!this.inventory.getStackInSlot(2).isEmpty()) {
                outputStack = this.inventory.getStackInSlot(2);
            } else if (!this.inventory.getStackInSlot(1).isEmpty()) {
                this.inventory.extractItem(1, 1, false);
                outputStack = new ItemStack((ItemLike)ModItems.TAG_FILTER.get());
            }
            if (!outputStack.isEmpty()) {
                HashSet<TagKey<Item>> tags = new HashSet<TagKey<Item>>(TagFilterItem.getConfiguredTagList(outputStack));
                for (String s : data) {
                    tags.add((TagKey<Item>)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)s)));
                }
                TagFilterItem.setConfiguredTagList(outputStack, tags);
                this.inventory.setStackInSlot(2, outputStack);
            }
        }
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.put("Items", (Tag)this.inventory.serializeNBT(provider));
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.inventory.deserializeNBT(provider, tag.getCompound("Items"));
        this.displayedStack = this.inventory.getStackInSlot(0);
        this.paperItemId = Item.getId((Item)this.inventory.getStackInSlot(1).getItem());
        this.outputItemId = Item.getId((Item)this.inventory.getStackInSlot(2).getItem());
    }

    @Override
    public void readFromPacket(CompoundTag tag, HolderLookup.Provider provider) {
        super.readFromPacket(tag, provider);
        this.paperItemId = tag.getInt("PaperItemId");
        this.outputItemId = tag.getInt("OutputItemId");
    }

    @Override
    public void writeToPacket(CompoundTag tag, HolderLookup.Provider provider) {
        super.writeToPacket(tag, provider);
        tag.putInt("PaperItemId", this.paperItemId);
        tag.putInt("OutputItemId", this.outputItemId);
    }

    @Nullable
    public AbstractContainerMenu createMenu(int windowId, Inventory inv, Player player) {
        return new TagWorkbenchMenu(windowId, inv, this.getBlockPos());
    }

    private class TagMatcherItemHandler
    extends DisplayTableBlockEntity.DisplayItemHandler {
        TagMatcherItemHandler() {
            super(TagWorkbenchBlockEntity.this, TagWorkbenchBlockEntity.this, 3);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return switch (slot) {
                case 0 -> true;
                case 1 -> {
                    if (stack.getItem() == Items.PAPER || stack.getItem() == ModItems.TAG_FILTER.get()) {
                        yield true;
                    }
                    yield false;
                }
                case 2 -> {
                    if (stack.getItem() == ModItems.TAG_FILTER.get()) {
                        yield true;
                    }
                    yield false;
                }
                default -> throw new IllegalArgumentException("invalid slot " + slot);
            };
        }

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (slot == 1) {
                TagWorkbenchBlockEntity.this.outputItemId = Item.getId((Item)this.getStackInSlot(1).getItem());
            } else if (slot == 2) {
                TagWorkbenchBlockEntity.this.paperItemId = Item.getId((Item)this.getStackInSlot(2).getItem());
            }
        }

        @Override
        public int getSlotLimit(int slot) {
            return switch (slot) {
                case 0, 2 -> 1;
                default -> 64;
            };
        }
    }
}

