/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity.processing;

import java.util.Collection;
import me.desht.pneumaticcraft.api.crafting.recipe.AssemblyRecipe;
import me.desht.pneumaticcraft.common.block.entity.processing.AbstractAssemblyRobotBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.processing.AssemblyPlatformBlockEntity;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.LazySynced;
import me.desht.pneumaticcraft.common.recipes.assembly.AssemblyProgram;
import me.desht.pneumaticcraft.common.registry.ModBlockEntityTypes;
import me.desht.pneumaticcraft.common.registry.ModBlocks;
import me.desht.pneumaticcraft.common.util.CountedItemStacks;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.IOHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class AssemblyIOUnitBlockEntity
extends AbstractAssemblyRobotBlockEntity {
    private static final byte SLEEP_TICKS = 50;
    private static final byte STATE_IDLE = 0;
    private static final byte STATE_SEARCH_SRC = 1;
    private static final byte STATE_CLOSECLAW_AFTER_PICKUP = 5;
    private static final byte STATE_RESET_CLOSECLAW_AFTER_PICKUP = 20;
    private static final byte STATE_RESET_GOTO_IDLE = 26;
    private static final byte STATE_MAX = 127;
    @DescSynced
    private boolean shouldClawClose;
    @DescSynced
    @LazySynced
    public float clawProgress;
    public float oldClawProgress;
    @DescSynced
    private final BaseItemStackHandler itemHandler = new BaseItemStackHandler(this, 1);
    private Collection<AssemblyRecipe> recipeList;
    private ItemStack searchedItemStack = ItemStack.EMPTY;
    private byte state = 0;
    private byte tickCounter = 0;

    public AssemblyIOUnitBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntityTypes.ASSEMBLY_IO_UNIT.get(), pos, state);
    }

    @Override
    public boolean hasItemCapability() {
        return false;
    }

    @Override
    public void tickClient() {
        super.tickClient();
        if (!this.isClawDone()) {
            this.moveClaw();
        }
    }

    @Override
    public void tickServer() {
        super.tickServer();
        this.slowMode = false;
        switch (this.state) {
            case 0: {
                break;
            }
            case 1: {
                if (!this.findPickupLocation()) break;
                this.state = (byte)(this.state + 1);
                break;
            }
            case 2: 
            case 7: 
            case 22: {
                if (!this.hoverOverTarget()) break;
                this.state = (byte)(this.state + 1);
                break;
            }
            case 3: 
            case 8: 
            case 23: {
                this.slowMode = true;
                if (!this.gotoTarget()) break;
                this.state = (byte)(this.state + 1);
                break;
            }
            case 4: {
                if (!this.getItemFromCurrentDirection()) break;
                this.state = (byte)(this.state + 1);
                break;
            }
            case 5: 
            case 20: {
                if (!this.closeClaw()) break;
                this.state = (byte)(this.state + 1);
                break;
            }
            case 6: 
            case 21: {
                if (!this.findDropOffLocation()) break;
                this.state = (byte)(this.state + 1);
                break;
            }
            case 9: 
            case 24: {
                if (!this.openClaw()) break;
                this.state = (byte)(this.state + 1);
                break;
            }
            case 10: 
            case 25: {
                if (!this.putItemToCurrentDirection()) break;
                this.state = (byte)(this.state + 1);
                break;
            }
            case 11: 
            case 26: {
                if (this.gotoIdlePos()) {
                    this.state = 0;
                }
            }
            case 127: {
                break;
            }
            default: {
                System.out.printf("unexpected state: %d%n", this.state);
                this.state = (byte)127;
            }
        }
    }

    @Override
    public boolean reset() {
        if (this.state >= 20) {
            return false;
        }
        if (!this.itemHandler.getStackInSlot(0).isEmpty()) {
            this.state = (byte)20;
            return false;
        }
        if (this.state == 0) {
            return true;
        }
        this.state = (byte)26;
        return this.isIdle();
    }

    public boolean pickupItem(Collection<AssemblyRecipe> list) {
        this.recipeList = list;
        if (this.state == 0) {
            this.state = (byte)(this.state + 1);
        }
        return this.state > 0 && !this.isSleeping() && this.state < 127;
    }

    private boolean gotoIdlePos() {
        this.gotoHomePosition();
        return this.isDoneMoving();
    }

    private boolean findPickupLocation() {
        if (this.shouldSleep()) {
            return false;
        }
        AbstractAssemblyRobotBlockEntity.TargetDirections inventoryDir = null;
        if (this.isImportUnit()) {
            ItemImportResult result;
            this.searchedItemStack = ItemStack.EMPTY;
            if (this.recipeList != null && (result = this.findImportInventory()) != null) {
                this.searchedItemStack = result.stack;
                inventoryDir = result.targetDirs;
            }
        } else {
            inventoryDir = this.getPlatformDirection();
        }
        this.targetDirection = inventoryDir;
        if (this.targetDirection == null) {
            this.sleepBeforeNextSearch();
            return false;
        }
        return true;
    }

    private ItemImportResult findImportInventory() {
        for (Direction dir : DirectionUtil.HORIZONTALS) {
            ItemStack res;
            BlockEntity te = this.getCachedNeighbor(dir);
            if (te == null || (res = this.searchImportInventory(te)).isEmpty()) continue;
            return new ItemImportResult(dir, res);
        }
        for (Direction secDir : new Direction[]{Direction.WEST, Direction.EAST}) {
            for (Direction primDir : new Direction[]{Direction.NORTH, Direction.SOUTH}) {
                ItemStack res;
                BlockEntity te = this.getLevel().getBlockEntity(this.getBlockPos().relative(primDir).relative(secDir));
                if (te == null || (res = this.searchImportInventory(te)).isEmpty()) continue;
                return new ItemImportResult(primDir, secDir, res);
            }
        }
        return null;
    }

    private ItemStack searchImportInventory(BlockEntity te) {
        CountedItemStacks counted = IOHelper.getInventoryForBlock(te, Direction.UP).map(CountedItemStacks::new).orElse(null);
        if (counted != null) {
            NonNullList<ItemStack> stacks = counted.coalesce();
            for (AssemblyRecipe recipe : this.recipeList) {
                for (ItemStack stack : stacks) {
                    if (!recipe.matches(stack)) continue;
                    return stack.copyWithCount(recipe.getInputAmount());
                }
            }
        }
        return ItemStack.EMPTY;
    }

    private boolean isSleeping() {
        return this.tickCounter > 0;
    }

    private boolean shouldSleep() {
        if (this.tickCounter > 0) {
            byte by = this.tickCounter;
            this.tickCounter = (byte)(by + 1);
            if (by < 50) {
                return true;
            }
        }
        this.tickCounter = 0;
        return false;
    }

    private void sleepBeforeNextSearch() {
        this.tickCounter = 1;
    }

    private boolean findDropOffLocation() {
        if (this.shouldSleep()) {
            return false;
        }
        AbstractAssemblyRobotBlockEntity.TargetDirections targetDirections = this.targetDirection = this.isImportUnit() ? this.getPlatformDirection() : this.getExportLocationForItem(this.itemHandler.getStackInSlot(0));
        if (this.targetDirection == null) {
            this.sleepBeforeNextSearch();
            return false;
        }
        return true;
    }

    private boolean getItemFromCurrentDirection() {
        AssemblyPlatformBlockEntity plat;
        BlockEntity tile = this.getTileEntityForCurrentDirection();
        if (tile == null) {
            return false;
        }
        boolean extracted = false;
        if (this.isImportUnit()) {
            if (this.searchedItemStack.isEmpty()) {
                this.reset();
            } else {
                extracted = IOHelper.getInventoryForBlock(tile, Direction.UP).map(sourceInv -> {
                    ItemStack heldStack = this.itemHandler.getStackInSlot(0);
                    int initialHeldAmount = heldStack.getCount();
                    boolean foundIt = false;
                    int needed = this.searchedItemStack.getCount() - heldStack.getCount();
                    for (int i = 0; i < sourceInv.getSlots() && !foundIt; ++i) {
                        ItemStack stack = sourceInv.getStackInSlot(i);
                        if (stack.isEmpty()) continue;
                        if (heldStack.isEmpty() && ItemStack.isSameItem((ItemStack)stack, (ItemStack)this.searchedItemStack) || ItemStack.isSameItemSameComponents((ItemStack)heldStack, (ItemStack)stack)) {
                            ItemStack takenStack = sourceInv.extractItem(i, needed, false);
                            ItemStack excess = this.itemHandler.insertItem(0, takenStack, false);
                            needed -= takenStack.getCount() - excess.getCount();
                            ItemHandlerHelper.insertItem((IItemHandler)sourceInv, (ItemStack)excess, (boolean)false);
                        }
                        foundIt = needed <= 0;
                    }
                    if (initialHeldAmount == this.itemHandler.getStackInSlot(0).getCount()) {
                        this.state = 1;
                    }
                    return foundIt;
                }).orElseGet(() -> {
                    this.state = 1;
                    return false;
                });
            }
        } else if (tile instanceof AssemblyPlatformBlockEntity && (plat = (AssemblyPlatformBlockEntity)tile).openClaw()) {
            this.itemHandler.setStackInSlot(0, plat.getHeldStack());
            plat.setHeldStack(ItemStack.EMPTY);
            boolean bl = extracted = !this.itemHandler.getStackInSlot(0).isEmpty();
            if (!extracted) {
                this.state = 1;
            }
        }
        return extracted;
    }

    private boolean putItemToCurrentDirection() {
        if (this.isImportUnit()) {
            BlockEntity tile = this.getTileEntityForCurrentDirection();
            if (tile instanceof AssemblyPlatformBlockEntity) {
                AssemblyPlatformBlockEntity plat = (AssemblyPlatformBlockEntity)tile;
                if (this.itemHandler.getStackInSlot(0).isEmpty()) {
                    return plat.closeClaw();
                }
                if (plat.isIdle()) {
                    plat.setHeldStack(this.itemHandler.getStackInSlot(0));
                    this.itemHandler.setStackInSlot(0, ItemStack.EMPTY);
                    return plat.closeClaw();
                }
            } else {
                this.repeatDropOffSearch();
            }
        } else {
            BlockEntity te = this.getTileEntityForCurrentDirection();
            if (te == null) {
                this.repeatDropOffSearch();
            } else {
                ItemStack currentStack = this.itemHandler.getStackInSlot(0);
                int startSize = currentStack.getCount();
                ItemStack excess = IOHelper.insert(te, currentStack, Direction.UP, false);
                this.itemHandler.setStackInSlot(0, excess);
                currentStack = this.itemHandler.getStackInSlot(0);
                if (!currentStack.isEmpty() && startSize == currentStack.getCount()) {
                    this.repeatDropOffSearch();
                }
            }
            return this.itemHandler.getStackInSlot(0).isEmpty();
        }
        return false;
    }

    private void repeatDropOffSearch() {
        this.state = (byte)(this.state >= 20 ? 20 : 5);
    }

    private boolean closeClaw() {
        this.shouldClawClose = true;
        return this.moveClaw();
    }

    private boolean openClaw() {
        this.shouldClawClose = false;
        return this.moveClaw();
    }

    private boolean moveClaw() {
        this.oldClawProgress = this.clawProgress;
        if (!this.shouldClawClose && this.clawProgress > 0.0f) {
            this.clawProgress = Math.max(this.clawProgress - 0.05f * this.speed, 0.0f);
        } else if (this.shouldClawClose && this.clawProgress < 1.0f) {
            this.clawProgress = Math.min(this.clawProgress + 0.05f * this.speed, 1.0f);
        }
        this.setChanged();
        return this.isClawDone();
    }

    private boolean isClawDone() {
        return this.clawProgress == this.oldClawProgress && this.clawProgress == (this.shouldClawClose ? 1.0f : 0.0f);
    }

    public boolean isImportUnit() {
        return this.getBlockState().getBlock() == ModBlocks.ASSEMBLY_IO_UNIT_IMPORT.get();
    }

    @Override
    public void gotoHomePosition() {
        super.gotoHomePosition();
        if (this.isClawDone()) {
            this.openClaw();
        }
    }

    @Override
    public boolean isIdle() {
        return this.state == 0;
    }

    @Override
    public AssemblyProgram.EnumMachine getAssemblyType() {
        return this.isImportUnit() ? AssemblyProgram.EnumMachine.IO_UNIT_IMPORT : AssemblyProgram.EnumMachine.IO_UNIT_EXPORT;
    }

    private AbstractAssemblyRobotBlockEntity.TargetDirections getExportLocationForItem(ItemStack exportedItem) {
        if (!exportedItem.isEmpty()) {
            for (Direction dir : DirectionUtil.HORIZONTALS) {
                BlockEntity te = this.getLevel().getBlockEntity(this.getBlockPos().relative(dir));
                int slot = AssemblyIOUnitBlockEntity.getPlacementSlot(exportedItem, te);
                if (slot < 0) continue;
                return new AbstractAssemblyRobotBlockEntity.TargetDirections(dir);
            }
            if (this.canMoveToDiagonalNeighbours()) {
                for (Direction secDir : new Direction[]{Direction.WEST, Direction.EAST}) {
                    for (Direction primDir : new Direction[]{Direction.NORTH, Direction.SOUTH}) {
                        BlockEntity te = this.getLevel().getBlockEntity(this.getBlockPos().relative(primDir).relative(secDir));
                        int slot = AssemblyIOUnitBlockEntity.getPlacementSlot(exportedItem, te);
                        if (slot < 0) continue;
                        return new AbstractAssemblyRobotBlockEntity.TargetDirections(primDir, secDir);
                    }
                }
            }
        }
        return null;
    }

    private static int getPlacementSlot(ItemStack exportedItem, BlockEntity te) {
        if (te == null || te instanceof AbstractAssemblyRobotBlockEntity) {
            return -1;
        }
        return IOHelper.getInventoryForBlock(te, Direction.UP).map(handler -> {
            for (int slot = 0; slot < handler.getSlots(); ++slot) {
                ItemStack excess = handler.insertItem(slot, exportedItem, true);
                if (excess.getCount() >= exportedItem.getCount()) continue;
                return slot;
            }
            return -1;
        }).orElse(-1);
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.clawProgress = tag.getFloat("clawProgress");
        this.shouldClawClose = tag.getBoolean("clawClosing");
        this.state = tag.getByte("state");
        this.itemHandler.deserializeNBT(provider, tag.getCompound("Items"));
    }

    @Override
    public IItemHandler getItemHandler(@Nullable Direction dir) {
        return this.itemHandler;
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putFloat("clawProgress", this.clawProgress);
        tag.putBoolean("clawClosing", this.shouldClawClose);
        tag.putByte("state", this.state);
        tag.put("Items", (Tag)this.itemHandler.serializeNBT(provider));
    }

    @Override
    public boolean canMoveToDiagonalNeighbours() {
        return true;
    }

    private static class ItemImportResult {
        final AbstractAssemblyRobotBlockEntity.TargetDirections targetDirs;
        final ItemStack stack;

        ItemImportResult(Direction targetDirs, ItemStack stack) {
            this(targetDirs, null, stack);
        }

        ItemImportResult(Direction primDir, Direction secDir, ItemStack stack) {
            this.targetDirs = new AbstractAssemblyRobotBlockEntity.TargetDirections(primDir, secDir);
            this.stack = stack;
        }
    }
}

