/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity.drone;

import com.google.common.collect.ImmutableSet;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.drone.DroneConstructingEvent;
import me.desht.pneumaticcraft.api.drone.IPathNavigator;
import me.desht.pneumaticcraft.api.drone.IProgWidget;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.api.pressure.PressureTier;
import me.desht.pneumaticcraft.api.registry.PNCRegistries;
import me.desht.pneumaticcraft.api.semiblock.SemiblockEvent;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.block.entity.AbstractAirHandlingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IMinWorkingPressure;
import me.desht.pneumaticcraft.common.block.entity.ISideConfigurable;
import me.desht.pneumaticcraft.common.block.entity.PneumaticEnergyStorage;
import me.desht.pneumaticcraft.common.block.entity.SideConfigurator;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.debug.DroneDebugger;
import me.desht.pneumaticcraft.common.drone.IDroneBase;
import me.desht.pneumaticcraft.common.drone.LogisticsManager;
import me.desht.pneumaticcraft.common.drone.ProgWidgetUtils;
import me.desht.pneumaticcraft.common.drone.ai.DroneAIManager;
import me.desht.pneumaticcraft.common.drone.progwidgets.SavedDroneProgram;
import me.desht.pneumaticcraft.common.entity.drone.ProgrammableControllerEntity;
import me.desht.pneumaticcraft.common.entity.semiblock.AbstractLogisticsFrameEntity;
import me.desht.pneumaticcraft.common.inventory.ProgrammableControllerMenu;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.DronePacket;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.network.LazySynced;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSpawnParticle;
import me.desht.pneumaticcraft.common.network.PacketSyncDroneProgWidgets;
import me.desht.pneumaticcraft.common.registry.ModBlockEntityTypes;
import me.desht.pneumaticcraft.common.registry.ModDataComponents;
import me.desht.pneumaticcraft.common.registry.ModEntityTypes;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.registry.ModSounds;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.chunkloading.DynamicChunkLoader;
import me.desht.pneumaticcraft.common.util.chunkloading.PlayerLogoutTracker;
import me.desht.pneumaticcraft.common.util.fakeplayer.DroneFakePlayer;
import me.desht.pneumaticcraft.common.util.fakeplayer.DroneItemHandler;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.capabilities.BaseCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class ProgrammableControllerBlockEntity
extends AbstractAirHandlingBlockEntity
implements IMinWorkingPressure,
IDroneBase,
ISideConfigurable,
MenuProvider {
    private static final int INVENTORY_SIZE = 1;
    private static final String FALLBACK_NAME = "[ProgController]";
    private static final UUID FALLBACK_UUID = UUID.nameUUIDFromBytes("[ProgController]".getBytes());
    private static final int MAX_ENERGY = 100000;
    public static final Set<ResourceLocation> BLACKLISTED_WIDGETS = ImmutableSet.of((Object)PneumaticRegistry.RL("computer_control"), (Object)PneumaticRegistry.RL("entity_attack"), (Object)PneumaticRegistry.RL("drone_condition_entity"), (Object)PneumaticRegistry.RL("standby"), (Object)PneumaticRegistry.RL("teleport"), (Object)PneumaticRegistry.RL("entity_export"), (Object[])new ResourceLocation[]{PneumaticRegistry.RL("entity_import")});
    private static final double SPEED_PER_UPGRADE = 0.05;
    private static final double BASE_SPEED = 0.15;
    private final ProgrammableItemStackHandler inventory = new ProgrammableItemStackHandler(this);
    private final FluidTank tank = new FluidTank(16000);
    private final PneumaticEnergyStorage energy = new PneumaticEnergyStorage(100000);
    private final DroneItemHandler droneItemHandler = new DroneItemHandler(this, 1);
    private final ControllerNavigator controllerNavigator = new ControllerNavigator();
    private ProgrammableControllerEntity drone;
    private DroneAIManager aiManager;
    private DroneFakePlayer fakePlayer;
    private final List<IProgWidget> progWidgets = new ArrayList<IProgWidget>();
    private final int[] redstoneLevels = new int[6];
    private final SideConfigurator<IItemHandler> itemHandlerSideConfigurator;
    private CompoundTag variablesNBT = null;
    @DescSynced
    private double targetX;
    @DescSynced
    private double targetY;
    @DescSynced
    private double targetZ;
    @DescSynced
    @LazySynced
    private double curX;
    @DescSynced
    @LazySynced
    private double curY;
    @DescSynced
    @LazySynced
    private double curZ;
    @DescSynced
    private int diggingX;
    @DescSynced
    private int diggingY;
    @DescSynced
    private int diggingZ;
    @DescSynced
    private int speedUpgrades;
    @DescSynced
    public boolean isIdle;
    @DescSynced
    public ItemStack heldItem = ItemStack.EMPTY;
    @GuiSynced
    public boolean shouldChargeHeldItem;
    @DescSynced
    public String label = "";
    @DescSynced
    public String ownerNameClient = "";
    @GuiSynced
    private boolean chunkloadSelf = false;
    @GuiSynced
    private boolean chunkloadWorkingChunk = false;
    @GuiSynced
    private boolean chunkloadWorkingChunk3x3 = false;
    private ChunkPos prevChunkPos = null;
    private DynamicChunkLoader chunkLoader;
    private UUID ownerID;
    private Component ownerName;
    private boolean shouldUpdateNeighbours;
    private LogisticsManager logisticsManager;
    private final DroneDebugger debugger = new DroneDebugger(this);
    @DescSynced
    private int activeWidgetIndex;
    private BlockPos digSourcePos;

    public ProgrammableControllerBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntityTypes.PROGRAMMABLE_CONTROLLER.get(), pos, state, PressureTier.TIER_TWO, 10000, 4);
        NeoForge.EVENT_BUS.post((Event)new DroneConstructingEvent(this));
        NeoForge.EVENT_BUS.register((Object)this);
        this.itemHandlerSideConfigurator = new SideConfigurator("items", this);
        this.itemHandlerSideConfigurator.registerHandler("droneInv", new ItemStack((ItemLike)ModItems.DRONE.get()), (BaseCapability<IItemHandler, ?>)Capabilities.ItemHandler.BLOCK, () -> this.droneItemHandler, SideConfigurator.RelativeFace.TOP, SideConfigurator.RelativeFace.FRONT, SideConfigurator.RelativeFace.BACK, SideConfigurator.RelativeFace.LEFT, SideConfigurator.RelativeFace.RIGHT);
        this.itemHandlerSideConfigurator.registerHandler("programmableInv", new ItemStack((ItemLike)ModItems.NETWORK_API.get()), (BaseCapability<IItemHandler, ?>)Capabilities.ItemHandler.BLOCK, () -> this.inventory, SideConfigurator.RelativeFace.BOTTOM);
        this.itemHandlerSideConfigurator.setNullFaceHandler("programmableInv");
    }

    @Override
    public boolean hasFluidCapability() {
        return true;
    }

    @Override
    public boolean hasEnergyCapability() {
        return true;
    }

    @Override
    public IFluidHandler getFluidHandler(@Nullable Direction dir) {
        return this.tank;
    }

    @Override
    public IEnergyStorage getEnergyHandler(@Nullable Direction dir) {
        return this.energy;
    }

    @SubscribeEvent
    public void onSemiblockEvent(SemiblockEvent event) {
        if (!event.getWorld().isClientSide && event.getWorld() == this.getLevel() && event.getSemiblock() instanceof AbstractLogisticsFrameEntity) {
            this.logisticsManager = null;
        }
    }

    @Override
    public void tickCommonPre() {
        super.tickCommonPre();
        double speed = 0.15 + (double)this.speedUpgrades * 0.05;
        if (PneumaticCraftUtils.distBetweenSq(this.curX, this.curY, this.curZ, this.targetX, this.targetY, this.targetZ) > speed / 2.0) {
            Vec3 vec = new Vec3(this.targetX - this.curX, this.targetY - this.curY, this.targetZ - this.curZ).normalize().scale(speed);
            this.curX += vec.x;
            this.curY += vec.y;
            this.curZ += vec.z;
        } else {
            this.curX = this.targetX;
            this.curY = this.targetY;
            this.curZ = this.targetZ;
        }
    }

    @Override
    public void tickClient() {
        super.tickClient();
        if ((this.drone == null || !this.drone.isAlive()) && this.nonNullLevel().isLoaded(BlockPos.containing((double)this.curX, (double)this.curY, (double)this.curZ))) {
            this.drone = (ProgrammableControllerEntity)ModEntityTypes.PROGRAMMABLE_CONTROLLER.get().create(this.nonNullLevel());
            if (this.drone != null) {
                this.drone.setController(this);
                this.drone.setPos(this.curX, this.curY, this.curZ);
                ClientUtils.spawnEntityClientside((Entity)this.drone);
            }
        } else if (this.drone != null) {
            this.drone.setPos(this.curX, this.curY, this.curZ);
        }
    }

    @Override
    public void tickServer() {
        super.tickServer();
        if (this.shouldUpdateNeighbours) {
            this.updateNeighbours();
            this.shouldUpdateNeighbours = false;
        }
        DroneFakePlayer fp = this.getFakePlayer();
        this.tickFakePlayer(fp);
        ChunkPos newChunkPos = new ChunkPos((int)this.curX >> 4, (int)this.curZ >> 4);
        if (this.chunkLoader != null) {
            if (PlayerLogoutTracker.INSTANCE.isPlayerLoggedOutTooLong(this.level.getServer(), this.ownerID)) {
                this.chunkLoader.unloadAll((ServerLevel)this.level);
            } else if (this.prevChunkPos == null || !this.prevChunkPos.equals((Object)newChunkPos)) {
                this.chunkLoader.updateLoadedChunks((ServerLevel)this.level, newChunkPos);
            }
        }
        this.prevChunkPos = newChunkPos;
        ItemStack itemStack = this.heldItem = (Boolean)ConfigHelper.common().drones.dronesRenderHeldItem.get() != false ? fp.getMainHandItem() : ItemStack.EMPTY;
        if (this.getPressure() >= this.getMinWorkingPressure()) {
            if (!this.isIdle) {
                this.addAir(-10);
                if (this.chunkloadWorkingChunk3x3) {
                    this.addAir(-30);
                } else if (this.chunkloadWorkingChunk) {
                    this.addAir(-10);
                }
            }
            if (this.chunkloadSelf) {
                this.addAir(-10);
            }
            DroneAIManager prevActive = this.getActiveAIManager();
            this.aiManager.onUpdateTasks();
            if (this.getActiveAIManager() != prevActive) {
                this.getDebugger().getDebuggingPlayers().forEach(p -> NetworkHandler.sendToPlayer(PacketSyncDroneProgWidgets.create(this), p));
            }
            this.maybeChargeHeldItem();
        }
        if (this.nonNullLevel().getGameTime() % 20L == 0L) {
            this.debugger.updateDebuggingPlayers();
        }
    }

    private void tickFakePlayer(DroneFakePlayer fp) {
        fp.setPos(this.curX, this.curY, this.curZ);
        fp.tick();
        BlockPos dugPosition = this.getDugPosition();
        if (dugPosition != null) {
            fp.lookAt(EntityAnchorArgument.Anchor.EYES, Vec3.atCenterOf((Vec3i)dugPosition));
        }
        for (int i = 0; i < 4; ++i) {
            fp.gameMode.tick();
        }
    }

    public boolean shouldLoadChunk(ChunkPos cp) {
        if (this.getPressure() < this.getMinWorkingPressure()) {
            return false;
        }
        int cx = (int)this.curX >> 4;
        int cz = (int)this.curZ >> 4;
        return this.chunkloadSelf && cp.x == this.worldPosition.getX() >> 4 && cp.z == this.worldPosition.getZ() >> 4 || this.chunkloadWorkingChunk && !this.isIdle && cp.x == cx && cp.z == cz || this.chunkloadWorkingChunk3x3 && !this.isIdle && cp.x >= cx - 1 && cp.x <= cx + 1 && cp.z >= cz - 1 && cp.z <= cz + 1;
    }

    private void maybeChargeHeldItem() {
        if (!this.shouldChargeHeldItem) {
            return;
        }
        ItemStack held = this.droneItemHandler.getStackInSlot(0);
        if (this.energy.getEnergyStored() > 100) {
            IOHelper.getEnergyStorageForItem(held).ifPresent(handler -> {
                if (handler.getMaxEnergyStored() - handler.getEnergyStored() > 250) {
                    handler.receiveEnergy(this.energy.extractEnergy(250, false), false);
                }
            });
        }
        PNCCapabilities.getAirHandler(held).ifPresent(handler -> {
            if (this.getPressure() > handler.getPressure() && handler.getPressure() < handler.maxPressure()) {
                int maxAir = (int)(handler.maxPressure() * (float)handler.getVolume());
                int toAdd = Math.min(250, maxAir - handler.getAir());
                handler.addAir(toAdd);
                this.airHandler.addAir(-toAdd);
            }
        });
    }

    @Override
    public void onVariableChanged(String varname, boolean isCoordinate) {
        this.setChanged();
    }

    public void setRemoved() {
        super.setRemoved();
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.chunkLoader != null) {
                this.chunkLoader.unloadAll(serverLevel);
            }
        }
        NeoForge.EVENT_BUS.unregister((Object)this);
    }

    @Override
    public UUID getOwnerUUID() {
        if (this.ownerID == null) {
            this.ownerID = UUID.randomUUID();
            this.ownerName = Component.literal((String)"[Programmable Controller]");
            Log.warning("Programmable controller with owner '{}' has no UUID! Substituting a random UUID ({}).", this.ownerName, this.ownerID);
        }
        return this.ownerID;
    }

    @Override
    public BlockPos getDeployPos() {
        return this.getBlockPos();
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayer player) {
        boolean doChunkloadCheck = false;
        if (tag.equals("charging")) {
            this.shouldChargeHeldItem = !this.shouldChargeHeldItem;
        } else if (tag.equals("chunkload_self")) {
            this.chunkloadSelf = !this.chunkloadSelf;
            doChunkloadCheck = true;
        } else if (tag.equals("chunkload_work")) {
            this.chunkloadWorkingChunk = !this.chunkloadWorkingChunk;
            doChunkloadCheck = true;
        } else if (tag.equals("chunkload_work_3x3")) {
            this.chunkloadWorkingChunk3x3 = !this.chunkloadWorkingChunk3x3;
            doChunkloadCheck = true;
        } else if (this.itemHandlerSideConfigurator.handleButtonPress(tag, shiftHeld)) {
            this.shouldUpdateNeighbours = true;
        }
        if (doChunkloadCheck && this.chunkLoader != null) {
            this.chunkLoader.updateLoadedChunks((ServerLevel)this.level, new ChunkPos(this.worldPosition));
        }
        this.setChanged();
    }

    @Override
    public IItemHandler getItemHandler(@Nullable Direction dir) {
        return this.itemHandlerSideConfigurator.getHandler(dir);
    }

    public void setOwner(Player ownerID) {
        this.ownerID = ownerID.getUUID();
        this.ownerName = ownerID.getName();
        this.ownerNameClient = this.ownerName.getString();
    }

    @Override
    public List<SideConfigurator<?>> getSideConfigurators() {
        return Collections.singletonList(this.itemHandlerSideConfigurator);
    }

    @Override
    public Direction byIndex() {
        return this.getRotation();
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory playerInventory, Player playerEntity) {
        return new ProgrammableControllerMenu(i, playerInventory, this.getBlockPos());
    }

    @Override
    public void onUpgradesChanged() {
        super.onUpgradesChanged();
        if (this.getLevel() != null && !this.getLevel().isClientSide) {
            int newInvUpgrades;
            int oldInvUpgrades = this.droneItemHandler.getSlots() - 1;
            if (oldInvUpgrades != (newInvUpgrades = Math.min(35, this.getUpgrades(ModUpgrades.INVENTORY.get())))) {
                this.resizeDroneInventory(oldInvUpgrades + 1, newInvUpgrades + 1);
                this.tank.setCapacity((newInvUpgrades + 1) * 16000);
                if (this.tank.getFluidAmount() > this.tank.getCapacity()) {
                    this.tank.getFluid().setAmount(this.tank.getCapacity());
                }
            }
            this.speedUpgrades = this.getUpgrades(ModUpgrades.SPEED.get());
        }
    }

    private void resizeDroneInventory(int oldSize, int newSize) {
        for (int i = newSize; i < oldSize; ++i) {
            ItemStack stack = this.droneItemHandler.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            this.droneItemHandler.setStackInSlot(i, ItemStack.EMPTY);
            PneumaticCraftUtils.dropItemOnGround(stack, this.getLevel(), this.getBlockPos().above());
        }
        this.droneItemHandler.setUseableSlots(newSize);
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.inventory.deserializeNBT(provider, tag.getCompound("Items"));
        this.tank.readFromNBT(provider, tag.getCompound("tank"));
        this.ownerID = tag.contains("ownerID") ? UUID.fromString(tag.getString("ownerID")) : FALLBACK_UUID;
        this.ownerName = Component.literal((String)(tag.contains("ownerName") ? tag.getString("ownerName") : FALLBACK_NAME));
        this.ownerNameClient = this.ownerName.getString();
        ItemStackHandler tmpInv = new ItemStackHandler();
        tmpInv.deserializeNBT(provider, tag.getCompound("droneItems"));
        this.droneItemHandler.setUseableSlots(tmpInv.getSlots());
        PneumaticCraftUtils.copyItemHandler((IItemHandler)tmpInv, this.droneItemHandler);
        this.energy.readFromNBT(tag);
        this.itemHandlerSideConfigurator.updateHandler("droneInv", () -> this.droneItemHandler);
        this.shouldChargeHeldItem = tag.getBoolean("chargeHeld");
        this.variablesNBT = tag.getCompound("variables");
        this.chunkloadSelf = tag.getBoolean("chunkload_self");
        this.chunkloadWorkingChunk = tag.getBoolean("chunkload_work");
        this.chunkloadWorkingChunk3x3 = tag.getBoolean("chunkload_work_3x3");
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.put("Items", (Tag)this.inventory.serializeNBT(provider));
        CompoundTag tankTag = new CompoundTag();
        this.tank.writeToNBT(provider, tankTag);
        tag.put("tank", (Tag)tankTag);
        ItemStackHandler handler = new ItemStackHandler(this.droneItemHandler.getSlots());
        for (int i = 0; i < this.droneItemHandler.getSlots(); ++i) {
            handler.setStackInSlot(i, this.droneItemHandler.getStackInSlot(i));
        }
        tag.put("droneItems", (Tag)handler.serializeNBT(provider));
        if (this.ownerID != null) {
            tag.putString("ownerID", this.ownerID.toString());
        }
        if (this.ownerName != null) {
            tag.putString("ownerName", this.ownerName.getString());
        }
        this.energy.writeToNBT(tag);
        tag.putBoolean("chargeHeld", this.shouldChargeHeldItem);
        if (this.aiManager != null) {
            tag.put("variables", (Tag)this.aiManager.writeToNBT(new CompoundTag()));
        }
        tag.putBoolean("chunkload_self", this.chunkloadSelf);
        tag.putBoolean("chunkload_work", this.chunkloadWorkingChunk);
        tag.putBoolean("chunkload_work_3x3", this.chunkloadWorkingChunk3x3);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        this.droneItemHandler.setFakePlayerReady();
        this.inventory.onContentsChanged(0);
        this.curX = this.targetX = (double)this.getBlockPos().getX() + 0.5;
        this.curY = this.targetY = (double)this.getBlockPos().getY() + 1.0;
        this.curZ = this.targetZ = (double)this.getBlockPos().getZ() + 0.5;
        this.chunkLoader = DynamicChunkLoader.forProgrammableController(this);
        if (this.chunkloadSelf) {
            this.chunkLoader.updateLoadedChunks((ServerLevel)this.nonNullLevel(), new ChunkPos(this.worldPosition));
        }
    }

    private static boolean isProgrammableAndValidForDrone(IDroneBase drone, ItemStack programmable) {
        return SavedDroneProgram.fromItemStack(programmable).isValidForDrone(drone);
    }

    @Override
    public float getMinWorkingPressure() {
        return 10.0f;
    }

    @Override
    public Level getDroneLevel() {
        return this.getLevel();
    }

    @Override
    public FluidTank getFluidTank() {
        return this.tank;
    }

    @Override
    public IEnergyStorage getEnergyStorage() {
        return this.energy;
    }

    @Override
    public IItemHandlerModifiable getInv() {
        return this.droneItemHandler;
    }

    @Override
    public Vec3 getDronePos() {
        if (this.curX == 0.0 && this.curY == 0.0 && this.curZ == 0.0) {
            this.curX = (double)this.getBlockPos().getX() + 0.5;
            this.curY = (double)this.getBlockPos().getY() + 1.0;
            this.curZ = (double)this.getBlockPos().getZ() + 0.5;
            this.targetX = this.curX;
            this.targetY = this.curY;
            this.targetZ = this.curZ;
        }
        return new Vec3(this.curX, this.curY, this.curZ);
    }

    public BlockPos getTargetPos() {
        return BlockPos.containing((double)this.targetX, (double)this.targetY, (double)this.targetZ);
    }

    @Override
    public BlockPos getControllerPos() {
        return this.worldPosition;
    }

    @Override
    public IPathNavigator getPathNavigator() {
        return this.controllerNavigator;
    }

    @Override
    public void sendWireframeToClient(BlockPos pos) {
    }

    @Override
    public DroneFakePlayer getFakePlayer() {
        if (this.fakePlayer == null) {
            this.fakePlayer = new DroneFakePlayer((ServerLevel)this.nonNullLevel(), new GameProfile(this.getOwnerUUID(), this.ownerName.getString()), this);
        }
        return this.fakePlayer;
    }

    @Override
    public boolean isBlockValidPathfindBlock(BlockPos pos) {
        return !this.nonNullLevel().getBlockState(pos).getCollisionShape((BlockGetter)this.nonNullLevel(), pos, CollisionContext.empty()).equals(Shapes.block());
    }

    @Override
    public void dropItem(ItemStack stack) {
        Vec3 pos = this.getDronePos();
        this.nonNullLevel().addFreshEntity((Entity)new ItemEntity(this.nonNullLevel(), pos.x, pos.y, pos.z, stack));
    }

    @Override
    public void getContentsToDrop(NonNullList<ItemStack> drops) {
        super.getContentsToDrop(drops);
        for (int i = 0; i < this.droneItemHandler.getSlots(); ++i) {
            if (this.fakePlayer.getInventory().getItem(i).isEmpty()) continue;
            drops.add((Object)this.fakePlayer.getInventory().getItem(i).copy());
        }
    }

    @Override
    public void setDugBlock(BlockPos pos) {
        if (pos != null) {
            this.diggingX = pos.getX();
            this.diggingY = pos.getY();
            this.diggingZ = pos.getZ();
        } else {
            this.diggingZ = Integer.MIN_VALUE;
            this.diggingY = Integer.MIN_VALUE;
            this.diggingX = Integer.MIN_VALUE;
            this.digSourcePos = null;
        }
    }

    @Override
    public void setDugBlock(@NotNull BlockPos pos, Direction side) {
        this.setDugBlock(pos);
        this.digSourcePos = pos.relative(side);
    }

    @Override
    public Vec3 getFakePlayerPos() {
        if (this.getDugPosition() != null && this.digSourcePos != null) {
            return Vec3.atCenterOf((Vec3i)this.digSourcePos);
        }
        return this.getDronePos();
    }

    public BlockPos getDugPosition() {
        return this.level != null && this.diggingY >= this.level.getMinBuildHeight() ? new BlockPos(this.diggingX, this.diggingY, this.diggingZ) : null;
    }

    @Override
    public List<IProgWidget> getProgWidgets() {
        return this.progWidgets;
    }

    @Override
    public void setActiveProgram(IProgWidget widget) {
        this.activeWidgetIndex = this.progWidgets.indexOf(widget);
    }

    @Override
    public boolean isProgramApplicable(ProgWidgetType<?> widgetType) {
        return PneumaticCraftUtils.getRegistryName(PNCRegistries.PROG_WIDGETS_REGISTRY, widgetType).map(regName -> !BLACKLISTED_WIDGETS.contains(regName)).orElseThrow();
    }

    @Override
    public GoalSelector getTargetAI() {
        return null;
    }

    @Override
    public void setEmittingRedstone(Direction orientation, int emittingRedstone) {
        this.redstoneLevels[orientation.get3DDataValue()] = emittingRedstone;
        this.updateNeighbours();
    }

    @Override
    public int getEmittingRedstone(Direction direction) {
        return this.redstoneLevels[direction.get3DDataValue()];
    }

    @Override
    public void setName(Component name) {
        ItemStack stack;
        if (this.drone != null) {
            this.drone.setCustomName(name);
        }
        if (!(stack = this.inventory.getStackInSlot(0).copy()).isEmpty()) {
            stack.set(DataComponents.CUSTOM_NAME, (Object)name);
            this.inventory.setStackInSlot(0, stack);
        }
    }

    @Override
    public void setCarryingEntity(Entity entity) {
        Log.warning("Drone AI setting carrying entity. However a Programmable Controller can't carry entities!", new Object[0]);
        new Throwable().printStackTrace();
    }

    @Override
    public List<Entity> getCarryingEntities() {
        return Collections.emptyList();
    }

    @Override
    public boolean isAIOverridden() {
        return false;
    }

    @Override
    public void onItemPickupEvent(ItemEntity curPickingUpEntity, int stackSize) {
    }

    @Override
    public Player getOwner() {
        if (this.ownerID == null) {
            return null;
        }
        if (this.nonNullLevel().isClientSide) {
            return ClientUtils.getClientPlayer();
        }
        return PneumaticCraftUtils.getPlayerFromId(this.ownerID);
    }

    @Override
    public void overload(String msgKey, Object ... params) {
        ItemStack stack = this.inventory.extractItem(0, 1, false);
        if (stack.getCount() == 1) {
            boolean inserted = this.findEjectionDest().map(h -> ItemHandlerHelper.insertItem((IItemHandler)h, (ItemStack)stack, (boolean)false).isEmpty()).orElse(false);
            if (!inserted) {
                PneumaticCraftUtils.dropItemOnGround(stack, this.level, this.worldPosition.above());
            }
            this.nonNullLevel().playSound(null, this.worldPosition, (SoundEvent)ModSounds.DRONE_DEATH.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        NetworkHandler.sendToAllTracking((CustomPacketPayload)new PacketSpawnParticle((ParticleOptions)ParticleTypes.SMOKE, new Vector3f((float)this.getBlockPos().getX() - 0.5f, (float)(this.getBlockPos().getY() + 1), (float)this.getBlockPos().getZ() - 0.5f), new Vector3f(0.0f, 0.0f, 0.0f), 10, Optional.of(new Vector3f(1.0f, 1.0f, 1.0f))), this);
    }

    @Override
    public DroneAIManager getAIManager() {
        if (!this.nonNullLevel().isClientSide && this.aiManager == null) {
            this.aiManager = new DroneAIManager(this, new ArrayList<IProgWidget>());
            this.aiManager.dontStopWhenEndReached();
            if (this.variablesNBT != null) {
                this.aiManager.readFromNBT(this.variablesNBT);
                this.variablesNBT = null;
            }
        }
        return this.aiManager;
    }

    @Override
    public void updateLabel() {
        this.label = this.aiManager != null ? this.getAIManager().getLabel() : "Main";
    }

    @Override
    public LogisticsManager getLogisticsManager() {
        return this.logisticsManager;
    }

    @Override
    public void setLogisticsManager(LogisticsManager logisticsManager) {
        this.logisticsManager = logisticsManager;
    }

    @Override
    public void playSound(SoundEvent soundEvent, SoundSource category, float volume, float pitch) {
    }

    @Override
    public void addAirToDrone(int air) {
        this.airHandler.addAir(air);
    }

    @Override
    public boolean canMoveIntoFluid(Fluid fluid) {
        return true;
    }

    @Override
    public DroneItemHandler getDroneItemHandler() {
        return this.droneItemHandler;
    }

    @Override
    public float getDronePressure() {
        return this.getPressure();
    }

    @Override
    public DronePacket.DroneTarget getPacketTarget() {
        return DronePacket.DroneTarget.forPos(this.getBlockPos());
    }

    @Override
    public int getActiveWidgetIndex() {
        return this.activeWidgetIndex;
    }

    @Override
    public DroneDebugger getDebugger() {
        return this.debugger;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public Component getDroneName() {
        return this.getDisplayName();
    }

    @Override
    public void storeTrackerData(ItemStack stack) {
        stack.set(ModDataComponents.DRONE_DEBUG_TARGET, (Object)DronePacket.DroneTarget.forPos(this.getBlockPos()));
    }

    @Override
    public boolean isDroneStillValid() {
        return !this.remove;
    }

    public boolean chunkloadSelf() {
        return this.chunkloadSelf;
    }

    public boolean chunkloadWorkingChunk() {
        return this.chunkloadWorkingChunk;
    }

    public boolean chunkloadWorkingChunk3x3() {
        return this.chunkloadWorkingChunk3x3;
    }

    private Optional<IItemHandler> findEjectionDest() {
        Direction dir = null;
        for (Direction d : DirectionUtil.VALUES) {
            if (!IOHelper.getInventoryForBlock(this, d).map(h -> h == this.inventory).orElse(false).booleanValue()) continue;
            dir = d;
            break;
        }
        if (dir != null) {
            BlockEntity te = this.nonNullLevel().getBlockEntity(this.worldPosition.relative(dir));
            return IOHelper.getInventoryForBlock(te, dir.getOpposite());
        }
        return Optional.empty();
    }

    private class ProgrammableItemStackHandler
    extends BaseItemStackHandler {
        ProgrammableItemStackHandler(BlockEntity te) {
            super(te, 1);
        }

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            ItemStack stack = this.getStackInSlot(slot);
            ProgrammableControllerBlockEntity.this.progWidgets.clear();
            if (!stack.isEmpty() && ProgrammableControllerBlockEntity.isProgrammableAndValidForDrone(ProgrammableControllerBlockEntity.this, stack)) {
                ProgrammableControllerBlockEntity.this.progWidgets.addAll(SavedDroneProgram.loadProgWidgets(stack));
                ProgWidgetUtils.updatePuzzleConnections(ProgrammableControllerBlockEntity.this.progWidgets);
                ProgrammableControllerBlockEntity.this.isIdle = false;
            } else {
                ProgrammableControllerBlockEntity.this.setDugBlock(null);
                ProgrammableControllerBlockEntity.this.targetX = (double)ProgrammableControllerBlockEntity.this.getBlockPos().getX() + 0.5;
                ProgrammableControllerBlockEntity.this.targetY = (double)ProgrammableControllerBlockEntity.this.getBlockPos().getY() + 1.0;
                ProgrammableControllerBlockEntity.this.targetZ = (double)ProgrammableControllerBlockEntity.this.getBlockPos().getZ() + 0.5;
                boolean updateNeighbours = false;
                for (int i = 0; i < ProgrammableControllerBlockEntity.this.redstoneLevels.length; ++i) {
                    if (ProgrammableControllerBlockEntity.this.redstoneLevels[i] <= 0) continue;
                    ProgrammableControllerBlockEntity.this.redstoneLevels[i] = 0;
                    updateNeighbours = true;
                }
                if (updateNeighbours) {
                    ProgrammableControllerBlockEntity.this.updateNeighbours();
                }
                ProgrammableControllerBlockEntity.this.isIdle = true;
            }
            if (ProgrammableControllerBlockEntity.this.getLevel() != null && !ProgrammableControllerBlockEntity.this.getLevel().isClientSide) {
                ProgrammableControllerBlockEntity.this.aiManager = null;
                ProgrammableControllerBlockEntity.this.aiManager = ProgrammableControllerBlockEntity.this.getAIManager();
                ProgrammableControllerBlockEntity.this.aiManager.setWidgets(ProgrammableControllerBlockEntity.this.progWidgets);
            }
        }

        public boolean isItemValid(int slot, ItemStack itemStack) {
            return itemStack.isEmpty() || ProgrammableControllerBlockEntity.isProgrammableAndValidForDrone(ProgrammableControllerBlockEntity.this, itemStack);
        }
    }

    private class ControllerNavigator
    implements IPathNavigator {
        private ControllerNavigator() {
        }

        @Override
        public boolean moveToXYZ(double x, double y, double z) {
            if (ProgrammableControllerBlockEntity.this.isBlockValidPathfindBlock(BlockPos.containing((double)x, (double)y, (double)z))) {
                ProgrammableControllerBlockEntity.this.targetX = x + 0.5;
                ProgrammableControllerBlockEntity.this.targetY = y + 0.5;
                ProgrammableControllerBlockEntity.this.targetZ = z + 0.5;
                return true;
            }
            return false;
        }

        @Override
        public boolean moveToEntity(Entity entity) {
            return this.moveToXYZ(entity.getX(), entity.getY() + 0.3, entity.getZ());
        }

        @Override
        public boolean hasNoPath() {
            return PneumaticCraftUtils.distBetweenSq(ProgrammableControllerBlockEntity.this.curX, ProgrammableControllerBlockEntity.this.curY, ProgrammableControllerBlockEntity.this.curZ, ProgrammableControllerBlockEntity.this.targetX, ProgrammableControllerBlockEntity.this.targetY, ProgrammableControllerBlockEntity.this.targetZ) < 0.5;
        }

        @Override
        public boolean isGoingToTeleport() {
            return false;
        }
    }
}

