/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.tube_module;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import me.desht.pneumaticcraft.client.model.PNCModelLayers;
import me.desht.pneumaticcraft.client.render.tube_module.AbstractTubeModuleRenderer;
import me.desht.pneumaticcraft.common.tubemodules.SafetyValveModule;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;

public class SafetyValveRenderer
extends AbstractTubeModuleRenderer<SafetyValveModule> {
    private final ModelPart tubeConnector;
    private final ModelPart valve;
    private final ModelPart valveHandle;
    private final ModelPart valveLid;
    private static final String TUBECONNECTOR = "tubeConnector";
    private static final String VALVE = "valve";
    private static final String VALVEHANDLE = "valveHandle";
    private static final String VALVELID = "valveLid";

    public SafetyValveRenderer(BlockEntityRendererProvider.Context ctx) {
        ModelPart root = ctx.bakeLayer(PNCModelLayers.SAFETY_VALVE_MODULE);
        this.tubeConnector = root.getChild(TUBECONNECTOR);
        this.valve = root.getChild(VALVE);
        this.valveHandle = root.getChild(VALVEHANDLE);
        this.valveLid = root.getChild(VALVELID);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild(TUBECONNECTOR, CubeListBuilder.create().texOffs(0, 0).addBox("tubeConnector_0", -0.5f, -0.5f, 0.0f, 4.0f, 4.0f, 2.0f), PartPose.offset((float)-1.5f, (float)14.5f, (float)2.0f));
        partdefinition.addOrReplaceChild(VALVE, CubeListBuilder.create().texOffs(0, 6).addBox("valve_0", 0.0f, 0.0f, 0.0f, 2.0f, 2.0f, 4.0f), PartPose.offset((float)-1.0f, (float)15.0f, (float)4.0f));
        partdefinition.addOrReplaceChild(VALVEHANDLE, CubeListBuilder.create().texOffs(0, 16).addBox("valveHandle_0", 0.5592f, 0.0f, 0.829f, 1.0f, 1.0f, 3.0f), PartPose.offsetAndRotation((float)2.0f, (float)15.5f, (float)4.0f, (float)0.0f, (float)-0.5934f, (float)0.0f));
        partdefinition.addOrReplaceChild(VALVELID, CubeListBuilder.create().texOffs(0, 12).addBox("valveLid_0", -3.0f, -1.0f, 0.0f, 3, 3, 1, 0, 12), PartPose.offset((float)1.5f, (float)15.5f, (float)7.25f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    @Override
    protected void render(SafetyValveModule module, PoseStack matrixStack, VertexConsumer builder, float partialTicks, int combinedLight, int combinedOverlay, int alpha) {
        int baseColor = FastColor.ARGB32.color((int)alpha, (int)0xFFFFFF);
        this.tubeConnector.render(matrixStack, builder, combinedLight, combinedOverlay, baseColor);
        this.valve.render(matrixStack, builder, combinedLight, combinedOverlay, baseColor);
        this.valveHandle.render(matrixStack, builder, combinedLight, combinedOverlay, baseColor);
        this.valveLid.render(matrixStack, builder, combinedLight, combinedOverlay, baseColor);
    }

    @Override
    protected ResourceLocation getTexture(boolean isUpgraded) {
        return isUpgraded ? Textures.MODEL_SAFETY_VALVE_UPGRADED : Textures.MODEL_SAFETY_VALVE;
    }
}

