/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.entity.semiblock;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import me.desht.pneumaticcraft.common.entity.semiblock.AbstractSemiblockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

abstract class RenderSemiblockBase<T extends AbstractSemiblockEntity>
extends EntityRenderer<T> {
    private static final Direction[] LIGHTING_DIRS = new Direction[]{Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST, Direction.DOWN};

    RenderSemiblockBase(EntityRendererProvider.Context ctx) {
        super(ctx);
    }

    void wobble(T entityIn, float partialTicks, PoseStack matrixStack) {
        float f = (float)((AbstractSemiblockEntity)entityIn).getTimeSinceHit() - partialTicks;
        float f1 = ((AbstractSemiblockEntity)entityIn).getDamageTaken() - partialTicks;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f > 0.0f) {
            Vec3 look = Minecraft.getInstance().player.getViewVector(partialTicks);
            Vector3f wobble = new Vector3f((float)look.z(), 0.0f, -((float)look.x()));
            matrixStack.mulPose(Axis.of((Vector3f)wobble).rotationDegrees(Mth.sin((float)f) * f * f1 / 10.0f * 1.0f));
        }
    }

    int kludgeLightingLevel(T entityIn, int packedLight) {
        if (packedLight == 0) {
            BlockPos pos = ((AbstractSemiblockEntity)entityIn).getBlockPos();
            for (Direction d : LIGHTING_DIRS) {
                BlockPos pos2 = pos.relative(d);
                if (Block.canSupportCenter((LevelReader)entityIn.level(), (BlockPos)pos2, (Direction)d.getOpposite())) continue;
                int block = entityIn.level().getBrightness(LightLayer.BLOCK, pos2);
                int sky = entityIn.level().getBrightness(LightLayer.SKY, pos2);
                return LightTexture.pack((int)block, (int)sky);
            }
        }
        return packedLight;
    }
}

