/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.pneumatic_armor.upgrade_handler;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IArmorUpgradeClientHandler;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IGuiScreen;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IOptionPage;
import me.desht.pneumaticcraft.api.pneumatic_armor.ICommonArmorHandler;
import me.desht.pneumaticcraft.client.gui.pneumatic_armor.options.CoordinateTrackerOptions;
import me.desht.pneumaticcraft.client.pneumatic_armor.ClientArmorRegistry;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.HUDHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.RenderNavigator;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.config.ClientConfig;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.drone.EntityPathNavigateDrone;
import me.desht.pneumaticcraft.common.entity.drone.DroneEntity;
import me.desht.pneumaticcraft.common.item.PneumaticArmorItem;
import me.desht.pneumaticcraft.common.network.PacketUpdateArmorExtraData;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonUpgradeHandlers;
import me.desht.pneumaticcraft.common.pneumatic_armor.handlers.CoordTrackerHandler;
import me.desht.pneumaticcraft.common.registry.ModDataComponents;
import me.desht.pneumaticcraft.common.registry.ModEntityTypes;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import me.desht.pneumaticcraft.common.util.GlobalPosHelper;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

public class CoordTrackClientHandler
extends IArmorUpgradeClientHandler.AbstractHandler<CoordTrackerHandler> {
    private RenderNavigator navigator;
    private BlockPos trackedPos;
    private ResourceKey<Level> worldKey;
    public boolean isListeningToCoordTrackerSetting = false;
    public boolean pathEnabled;
    public boolean wirePath;
    public boolean xRayEnabled;
    public ClientConfig.PathUpdateSetting pathUpdateSetting = ClientConfig.PathUpdateSetting.NORMAL;
    private int pathCalculateCooldown;
    private int noPathCooldown;

    public CoordTrackClientHandler() {
        super(CommonUpgradeHandlers.coordTrackerHandler);
    }

    @Override
    public void initConfig() {
        this.pathEnabled = (Boolean)ConfigHelper.client().armor.pathEnabled.get();
        this.wirePath = (Boolean)ConfigHelper.client().armor.wirePath.get();
        this.xRayEnabled = (Boolean)ConfigHelper.client().armor.xRayEnabled.get();
        this.pathUpdateSetting = (ClientConfig.PathUpdateSetting)ConfigHelper.client().armor.pathUpdateSetting.get();
    }

    @Override
    public void saveToConfig() {
        ConfigHelper.updateCoordTracker(this.pathEnabled, this.wirePath, this.xRayEnabled, this.pathUpdateSetting);
    }

    @Override
    public void tickClient(ICommonArmorHandler armorHandler, boolean isEnabled) {
        if (!isEnabled) {
            return;
        }
        this.trackedPos = PneumaticArmorItem.getCoordTrackerPos(ClientUtils.getWornArmor(EquipmentSlot.HEAD), armorHandler.getPlayer().level());
        this.worldKey = armorHandler.getPlayer().level().dimension();
        if (this.trackedPos != null) {
            this.navigator = new RenderNavigator(this.trackedPos);
        }
        if (this.noPathCooldown > 0) {
            --this.noPathCooldown;
        }
        if (this.navigator != null && ((Boolean)ConfigHelper.client().armor.pathEnabled.get()).booleanValue() && this.noPathCooldown == 0 && --this.pathCalculateCooldown <= 0) {
            this.navigator.updatePath();
            if (!this.navigator.tracedToDestination()) {
                this.noPathCooldown = 100;
            }
            this.pathCalculateCooldown = ((ClientConfig.PathUpdateSetting)ConfigHelper.client().armor.pathUpdateSetting.get()).getTicks();
        }
    }

    @Override
    public void render3D(PoseStack matrixStack, MultiBufferSource buffer, float partialTicks) {
        if (this.trackedPos != null && ClientUtils.getClientLevel().dimension().location().equals((Object)this.worldKey.location()) && ((Boolean)ConfigHelper.client().armor.pathEnabled.get()).booleanValue() && this.navigator != null) {
            this.navigator.render(matrixStack, buffer, (Boolean)ConfigHelper.client().armor.wirePath.get(), (Boolean)ConfigHelper.client().armor.xRayEnabled.get(), partialTicks);
        }
    }

    @Override
    public void render2D(GuiGraphics graphics, float partialTicks, boolean armorPieceHasPressure) {
    }

    @Override
    public void reset() {
        this.trackedPos = null;
        this.navigator = null;
    }

    public EnumNavigationResult navigateToSurface(Player player) {
        BlockPos pathPos;
        Node pathPoint;
        int i;
        Level level = player.level();
        BlockPos navigatingPos = level.getHeightmapPos(Heightmap.Types.WORLD_SURFACE, player.blockPosition());
        Mob e = PneumaticCraftUtils.createDummyEntity(player);
        Path path = e.getNavigation().createPath(navigatingPos, 0);
        if (path != null) {
            for (i = 0; i < path.getNodeCount(); ++i) {
                pathPoint = path.getNode(i);
                pathPos = new BlockPos(pathPoint.x, pathPoint.y, pathPoint.z);
                if (!level.canSeeSkyFromBelowWater(pathPos)) continue;
                this.trackedPos = pathPos;
                this.navigator = new RenderNavigator(pathPos);
                return EnumNavigationResult.EASY_PATH;
            }
        }
        if ((path = CoordTrackClientHandler.getDronePath(player, navigatingPos)) != null) {
            for (i = 0; i < path.getNodeCount(); ++i) {
                pathPoint = path.getNode(i);
                pathPos = new BlockPos(pathPoint.x, pathPoint.y, pathPoint.z);
                if (!level.canSeeSkyFromBelowWater(pathPos)) continue;
                this.trackedPos = pathPos;
                this.navigator = new RenderNavigator(pathPos);
                return EnumNavigationResult.DRONE_PATH;
            }
        }
        return EnumNavigationResult.NO_PATH;
    }

    public static Path getDronePath(Player player, BlockPos pos) {
        Level level = player.level();
        DroneEntity drone = new DroneEntity((EntityType<? extends DroneEntity>)ModEntityTypes.DRONE.get(), level);
        drone.setPos(player.getX(), player.getY(), player.getZ());
        return new EntityPathNavigateDrone(drone, level).createPath(pos, 0);
    }

    public BlockPos getTrackedPos() {
        return this.trackedPos;
    }

    @Override
    public IOptionPage getGuiOptionsPage(IGuiScreen screen) {
        return new CoordinateTrackerOptions(screen, this);
    }

    public static enum EnumNavigationResult {
        NO_PATH,
        EASY_PATH,
        DRONE_PATH;

    }

    @EventBusSubscriber(value={Dist.CLIENT}, modid="pneumaticcraft")
    public static class Listener {
        @SubscribeEvent
        public static void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
            ItemStack helmetStack = event.getEntity().getItemBySlot(EquipmentSlot.HEAD);
            if (!event.getLevel().isClientSide || event.getEntity().getItemBySlot(EquipmentSlot.HEAD).getItem() != ModItems.PNEUMATIC_HELMET.get()) {
                return;
            }
            CommonArmorHandler commonArmorHandler = CommonArmorHandler.getHandlerForPlayer();
            if (commonArmorHandler.getUpgradeCount(EquipmentSlot.HEAD, ModUpgrades.COORDINATE_TRACKER.get()) == 0) {
                return;
            }
            CoordTrackClientHandler handler = ClientArmorRegistry.getInstance().getClientHandler(CommonUpgradeHandlers.coordTrackerHandler, CoordTrackClientHandler.class);
            if (handler.isListeningToCoordTrackerSetting) {
                handler.isListeningToCoordTrackerSetting = false;
                if (event.getFace() != null) {
                    handler.reset();
                    GlobalPos gPos = GlobalPosHelper.makeGlobalPos(event.getLevel(), event.getPos().relative(event.getFace()));
                    PneumaticArmorItem.setCoordTrackerPos(helmetStack, gPos);
                    PacketUpdateArmorExtraData.sendToServer(CommonUpgradeHandlers.coordTrackerHandler, ModDataComponents.COORD_TRACKER.get(), gPos);
                    HUDHandler.getInstance().addMessage((Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.gui.coordinateTracker.selectedTarget", PneumaticCraftUtils.posToString(gPos.pos())), Collections.emptyList(), 60, -2147440128);
                }
            }
        }
    }
}

