/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.widget;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IArmorUpgradeClientHandler;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.ICheckboxWidget;
import me.desht.pneumaticcraft.api.pneumatic_armor.IArmorUpgradeHandler;
import me.desht.pneumaticcraft.client.gui.widget.WidgetCheckBox;
import me.desht.pneumaticcraft.client.pneumatic_armor.ClientArmorRegistry;
import me.desht.pneumaticcraft.client.pneumatic_armor.upgrade_handler.CoreComponentsClientHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.HUDHandler;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.config.subconfig.ArmorFeatureStatus;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketToggleArmorFeature;
import me.desht.pneumaticcraft.common.network.PacketToggleArmorFeatureBulk;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonUpgradeHandlers;
import me.desht.pneumaticcraft.common.registry.ModSounds;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EquipmentSlot;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.settings.KeyModifier;

public class WidgetKeybindCheckBox
extends WidgetCheckBox {
    private static final Map<ResourceLocation, WidgetKeybindCheckBox> id2checkBox = new HashMap<ResourceLocation, WidgetKeybindCheckBox>();
    private static WidgetKeybindCheckBox coreComponents;
    private final ResourceLocation upgradeID;
    private ResourceLocation ownerUpgradeID = null;
    private boolean isListeningForBinding;
    private Component oldCheckboxText = this.getMessage();

    private WidgetKeybindCheckBox(ResourceLocation upgradeID, int x, int y, int color, Consumer<ICheckboxWidget> pressable) {
        super(x, y, color, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.enableModule", PneumaticCraftUtils.xlate(IArmorUpgradeHandler.getStringKey(upgradeID), new Object[0])), pressable);
        this.upgradeID = upgradeID;
        this.buildTooltip();
    }

    public static WidgetKeybindCheckBox getOrCreate(ResourceLocation upgradeID, int x, int y, int color, Consumer<ICheckboxWidget> pressable) {
        return id2checkBox.computeIfAbsent(upgradeID, id -> {
            WidgetKeybindCheckBox newCheckBox = new WidgetKeybindCheckBox((ResourceLocation)id, x, y, color, pressable);
            newCheckBox.checked = ArmorFeatureStatus.INSTANCE.isUpgradeEnabled((ResourceLocation)id);
            KeyMapping keyMapping = ClientArmorRegistry.getInstance().getKeybindingForUpgrade((ResourceLocation)id);
            if (keyMapping != null && !keyMapping.isUnbound()) {
                KeyDispatcher.in2checkbox.put(InputRecord.forKeyMapping(keyMapping), newCheckBox);
            }
            if (id.equals((Object)CommonUpgradeHandlers.coreComponentsHandler.getID())) {
                coreComponents = newCheckBox;
            }
            return newCheckBox;
        });
    }

    public static WidgetKeybindCheckBox get(ResourceLocation upgradeID) {
        return id2checkBox.get(upgradeID);
    }

    public static WidgetKeybindCheckBox forUpgrade(IArmorUpgradeHandler<?> handler) {
        return WidgetKeybindCheckBox.get(handler.getID());
    }

    public static WidgetKeybindCheckBox forUpgrade(IArmorUpgradeClientHandler<?> handler) {
        return WidgetKeybindCheckBox.get(handler.getID());
    }

    public static WidgetKeybindCheckBox getCoreComponents() {
        return coreComponents;
    }

    @Override
    public ICheckboxWidget withOwnerUpgradeID(ResourceLocation ownerUpgradeID) {
        this.ownerUpgradeID = ownerUpgradeID;
        return this;
    }

    public static boolean isHandlerEnabled(IArmorUpgradeHandler<?> handler) {
        return WidgetKeybindCheckBox.forUpgrade(handler).checked;
    }

    public boolean mouseClicked(double x, double y, int button) {
        if (this.clicked(x, y)) {
            this.playDownSound(Minecraft.getInstance().getSoundManager());
            if (this.handleClick(x, y, button)) {
                return true;
            }
            if (this.isListeningForBinding) {
                InputConstants.Key input = InputConstants.Type.MOUSE.getOrCreate(button);
                this.updateBinding(input);
                return true;
            }
        }
        return false;
    }

    public boolean handleClick() {
        return this.handleClick(0.0, 0.0, 0);
    }

    private boolean handleClick(double mouseX, double mouseY, int button) {
        if (button == 0) {
            byte idx;
            EquipmentSlot slot;
            if (!WidgetKeybindCheckBox.coreComponents.checked && this != coreComponents) {
                return true;
            }
            CommonArmorHandler commonArmorHandler = CommonArmorHandler.getHandlerForPlayer();
            IArmorUpgradeHandler<?> entry = ArmorUpgradeRegistry.getInstance().getUpgradeEntry(this.upgradeID);
            IArmorUpgradeHandler<?> ownerEntry = ArmorUpgradeRegistry.getInstance().getUpgradeEntry(this.ownerUpgradeID);
            if (!this.checked && (entry != null ? this != coreComponents && !commonArmorHandler.isArmorReady(entry.getEquipmentSlot()) : ownerEntry != null && !commonArmorHandler.isArmorReady(ownerEntry.getEquipmentSlot()))) {
                return true;
            }
            super.onClick(mouseX, mouseY, button);
            ArmorFeatureStatus.INSTANCE.setUpgradeEnabled(this.upgradeID, this.checked);
            ArmorFeatureStatus.INSTANCE.saveIfChanged();
            if (entry != null && commonArmorHandler.isUpgradeInserted(slot = entry.getEquipmentSlot(), idx = (byte)entry.getIndex())) {
                this.toggleUpgrade(commonArmorHandler, slot, idx);
            }
            if (this == coreComponents) {
                this.toggleAllUpgrades(commonArmorHandler);
            }
            return true;
        }
        if (button == 1) {
            if (Screen.hasShiftDown()) {
                this.updateBinding(InputConstants.UNKNOWN);
            } else {
                this.isListeningForBinding = !this.isListeningForBinding;
                this.buildTooltip();
                if (this.isListeningForBinding) {
                    this.oldCheckboxText = this.getMessage();
                    this.setMessage((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.setKeybind", new Object[0]).withStyle(ChatFormatting.YELLOW));
                } else {
                    this.setMessage(this.oldCheckboxText);
                }
            }
            return true;
        }
        return false;
    }

    private void toggleUpgrade(CommonArmorHandler commonArmorHandler, EquipmentSlot slot, byte idx) {
        NetworkHandler.sendToServer(new PacketToggleArmorFeature(new PacketToggleArmorFeature.FeatureSetting(slot, idx, WidgetKeybindCheckBox.coreComponents.checked && this.checked)));
        commonArmorHandler.setUpgradeEnabled(slot, idx, WidgetKeybindCheckBox.coreComponents.checked && this.checked);
        HUDHandler.getInstance().addFeatureToggleMessage(IArmorUpgradeHandler.getStringKey(this.upgradeID), this.checked);
    }

    private void toggleAllUpgrades(CommonArmorHandler commonArmorHandler) {
        ArrayList<PacketToggleArmorFeature.FeatureSetting> features = new ArrayList<PacketToggleArmorFeature.FeatureSetting>();
        ArmorUpgradeRegistry.getInstance().entries().forEach(entry -> {
            boolean state = WidgetKeybindCheckBox.coreComponents.checked && WidgetKeybindCheckBox.forUpgrade(entry).checked;
            byte idx = (byte)entry.getIndex();
            features.add(new PacketToggleArmorFeature.FeatureSetting(entry.getEquipmentSlot(), idx, state));
            commonArmorHandler.setUpgradeEnabled(entry.getEquipmentSlot(), idx, state);
        });
        NetworkHandler.sendToServer(new PacketToggleArmorFeatureBulk(features));
        if (this.checked) {
            ClientArmorRegistry.getInstance().getClientHandler(CommonUpgradeHandlers.coreComponentsHandler, CoreComponentsClientHandler.class).onResolutionChanged();
        } else {
            Minecraft.getInstance().player.playSound((SoundEvent)ModSounds.MINIGUN_STOP.get(), 1.0f, 0.5f);
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.isListeningForBinding) {
            InputConstants.Key input = InputConstants.Type.KEYSYM.getOrCreate(keyCode);
            if (!KeyModifier.isKeyCodeModifier((InputConstants.Key)input)) {
                this.updateBinding(input);
            }
            return true;
        }
        return false;
    }

    private void buildTooltip() {
        KeyMapping keyBinding = ClientArmorRegistry.getInstance().getKeybindingForUpgrade(this.upgradeID);
        String k = IArmorUpgradeHandler.getStringKey(this.upgradeID) + ".desc";
        if (keyBinding == null && !I18n.exists((String)k)) {
            this.setTooltip(null);
            return;
        }
        ArrayList<Component> l = new ArrayList<Component>();
        if (I18n.exists((String)k)) {
            l.addAll(GuiUtils.xlateAndSplit(k, new Object[0]));
        }
        if (keyBinding != null) {
            l.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.keybindBoundKey", ClientUtils.translateKeyBind(keyBinding)).withStyle(ChatFormatting.GOLD));
            if (!this.isListeningForBinding) {
                l.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.keybindRightClickToSet", new Object[0]).withStyle(ChatFormatting.GRAY));
                if (keyBinding.getKey().getValue() != -1) {
                    l.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.keybindShiftRightClickToClear", new Object[0]).withStyle(ChatFormatting.GRAY));
                }
            }
        }
        this.setTooltip(Tooltip.create((Component)PneumaticCraftUtils.combineComponents(l)));
    }

    private void updateBinding(InputConstants.Key input) {
        this.isListeningForBinding = false;
        KeyMapping mapping = ClientArmorRegistry.getInstance().getKeybindingForUpgrade(this.upgradeID);
        if (mapping != null) {
            KeyModifier mod = input == InputConstants.UNKNOWN ? KeyModifier.NONE : KeyModifier.getActiveModifier();
            mapping.setKeyModifierAndCode(mod, input);
            Minecraft.getInstance().options.setKey(mapping, input);
            KeyMapping.resetMapping();
            KeyDispatcher.updateBinding(mapping, this);
            Minecraft.getInstance().player.playSound((SoundEvent)SoundEvents.NOTE_BLOCK_CHIME.value(), 1.0f, input == InputConstants.UNKNOWN ? 0.5f : 1.0f);
        }
        this.setMessage(this.oldCheckboxText);
        this.buildTooltip();
    }

    @Override
    public ResourceLocation getUpgradeId() {
        return this.upgradeID;
    }

    @EventBusSubscriber(modid="pneumaticcraft", value={Dist.CLIENT})
    public static class KeyDispatcher {
        private static final Map<InputRecord, WidgetKeybindCheckBox> in2checkbox = new HashMap<InputRecord, WidgetKeybindCheckBox>();

        @SubscribeEvent
        public static void onKeyPress(InputEvent.Key event) {
            if (Minecraft.getInstance().screen == null && event.getAction() == 1) {
                KeyDispatcher.handleInput(InputConstants.Type.KEYSYM.getOrCreate(event.getKey()));
            }
        }

        @SubscribeEvent
        public static void onMouseClick(InputEvent.MouseButton.Post event) {
            if (Minecraft.getInstance().screen == null && event.getAction() == 1) {
                KeyDispatcher.handleInput(InputConstants.Type.MOUSE.getOrCreate(event.getButton()));
            }
        }

        private static void handleInput(InputConstants.Key key) {
            Optional.ofNullable(in2checkbox.get(InputRecord.forKey(key))).ifPresent(WidgetKeybindCheckBox::handleClick);
        }

        private static void updateBinding(KeyMapping mapping, WidgetKeybindCheckBox widget) {
            in2checkbox.values().remove(widget);
            in2checkbox.put(InputRecord.forKeyMapping(mapping), widget);
        }
    }

    private record InputRecord(int key, KeyModifier modifier, InputConstants.Type type) {
        private static InputRecord forKeyMapping(KeyMapping keyMapping) {
            return new InputRecord(keyMapping.getKey().getValue(), keyMapping.getKeyModifier(), keyMapping.getKey().getType());
        }

        private static InputRecord forKey(InputConstants.Key key) {
            return new InputRecord(key.getValue(), KeyModifier.getActiveModifier(), key.getType());
        }
    }
}

