/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import me.desht.pneumaticcraft.api.crafting.recipe.FluidMixerRecipe;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftContainerScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTank;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.block.entity.processing.FluidMixerBlockEntity;
import me.desht.pneumaticcraft.common.inventory.FluidMixerMenu;
import me.desht.pneumaticcraft.common.registry.ModRecipeTypes;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;

public class FluidMixerScreen
extends AbstractPneumaticCraftContainerScreen<FluidMixerMenu, FluidMixerBlockEntity> {
    private final WidgetButtonExtended[] dumpButtons = new WidgetButtonExtended[2];

    public FluidMixerScreen(FluidMixerMenu container, Inventory inv, Component displayString) {
        super(container, inv, displayString);
        this.imageHeight = 212;
    }

    @Override
    public void init() {
        super.init();
        this.addRenderableWidget((GuiEventListener)new WidgetTank(this.leftPos + 13, this.topPos + 19, ((FluidMixerBlockEntity)this.te).getInputTank1()));
        this.addRenderableWidget((GuiEventListener)new WidgetTank(this.leftPos + 33, this.topPos + 19, ((FluidMixerBlockEntity)this.te).getInputTank2()));
        this.addRenderableWidget((GuiEventListener)new WidgetTank(this.leftPos + 99, this.topPos + 19, ((FluidMixerBlockEntity)this.te).getOutputTank()));
        for (int i = 0; i < 2; ++i) {
            this.dumpButtons[i] = new WidgetButtonExtended(this.leftPos + 14 + i * 20, this.topPos + 86, 14, 14, (Component)Component.empty()).withTag("dump" + (i + 1)).withCustomTooltip(this::makeDumpButtonTooltip);
            this.addRenderableWidget((GuiEventListener)this.dumpButtons[i]);
        }
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_FLUID_MIXER;
    }

    @Override
    protected void renderBg(GuiGraphics graphics, float partialTicks, int x, int y) {
        super.renderBg(graphics, partialTicks, x, y);
        int progressWidth = (int)(((FluidMixerBlockEntity)this.te).getCraftingPercentage() * 48.0f);
        graphics.blit(this.getGuiTexture(), this.leftPos + 50, this.topPos + 36, this.imageWidth, 0, progressWidth, 30);
    }

    @Override
    protected PointXY getGaugeLocation() {
        int xStart = (this.width - this.imageWidth) / 2;
        int yStart = (this.height - this.imageHeight) / 2;
        return new PointXY(xStart + this.imageWidth * 3 / 4 + 14, yStart + this.imageHeight / 4 - 2);
    }

    @Override
    public void containerTick() {
        super.containerTick();
        for (int i = 0; i < 2; ++i) {
            this.dumpButtons[i].setMessage((Component)(FluidMixerScreen.hasShiftDown() ? Component.literal((String)"X").withStyle(ChatFormatting.RED) : Component.literal((String)"\u25b6").withStyle(ChatFormatting.DARK_AQUA)));
        }
    }

    @Override
    protected void addPressureStatInfo(List<Component> pressureStatText) {
        super.addPressureStatInfo(pressureStatText);
        if (((FluidMixerBlockEntity)this.te).didWork) {
            pressureStatText.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.airUsage", PneumaticCraftUtils.roundNumberTo(2.5f * ((FluidMixerBlockEntity)this.te).getPressure(), 2)));
        }
    }

    @Override
    protected void addProblems(List<Component> curInfo) {
        super.addProblems(curInfo);
        if (((FluidMixerBlockEntity)this.te).maxProgress == 0) {
            curInfo.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.missingIngredients", new Object[0]));
        }
    }

    @Override
    public Collection<ItemStack> getTargetItems() {
        return this.getCurrentRecipe(ModRecipeTypes.FLUID_MIXER.get()).map(recipe -> Collections.singletonList(((FluidMixerRecipe)recipe.value()).getOutputItem())).orElse(Collections.emptyList());
    }

    @Override
    public Collection<FluidStack> getTargetFluids() {
        return this.getCurrentRecipe(ModRecipeTypes.FLUID_MIXER.get()).map(recipe -> Collections.singletonList(((FluidMixerRecipe)recipe.value()).getOutputFluid())).orElse(Collections.emptyList());
    }

    private List<Component> makeDumpButtonTooltip() {
        return List.of(PneumaticCraftUtils.xlate("pneumaticcraft.gui.thermopneumatic." + (FluidMixerScreen.hasShiftDown() ? "dumpInput" : "moveInput"), new Object[0]));
    }
}

