/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.api.crafting.TemperatureRange;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftContainerScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTank;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTemperature;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.block.entity.processing.EtchingTankBlockEntity;
import me.desht.pneumaticcraft.common.inventory.EtchingTankMenu;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import org.jetbrains.annotations.NotNull;

public class EtchingTankScreen
extends AbstractPneumaticCraftContainerScreen<EtchingTankMenu, EtchingTankBlockEntity> {
    private WidgetTemperature tempWidget;

    public EtchingTankScreen(EtchingTankMenu container, Inventory inv, Component displayString) {
        super(container, inv, displayString);
        this.imageHeight = 206;
    }

    @Override
    public void init() {
        super.init();
        this.addRenderableWidget((GuiEventListener)new WidgetTank(this.leftPos + 149, this.topPos + 18, ((EtchingTankBlockEntity)this.te).getAcidTank()));
        this.tempWidget = new WidgetTemperature(this.leftPos + 134, this.topPos + 18, TemperatureRange.of(273, 773), 323, 50, this::makeTooltip);
        this.addRenderableWidget((GuiEventListener)this.tempWidget);
    }

    @NotNull
    private List<Component> makeTooltip() {
        int interval = ((EtchingTankBlockEntity)this.te).getTickInterval();
        int processTimeSecs = interval * 5;
        ArrayList<Component> res = new ArrayList<Component>();
        res.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.etching_tank.process_time", processTimeSecs).withStyle(ChatFormatting.GREEN));
        if (this.tempWidget.getTemperature() > 323) {
            float usage = (float)(30 - interval) / (5.0f * (float)interval);
            res.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.etching_tank.acid_usage", PneumaticCraftUtils.roundNumberTo(usage, 2)).withStyle(ChatFormatting.YELLOW));
        }
        return res;
    }

    @Override
    public void containerTick() {
        super.containerTick();
        this.tempWidget.setTemperature(((EtchingTankBlockEntity)this.te).getHeatExchanger().getTemperatureAsInt());
        this.tempWidget.autoScaleForTemperature();
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_ETCHING_TANK;
    }

    @Override
    protected void addProblems(List<Component> curInfo) {
        super.addProblems(curInfo);
        if (((EtchingTankBlockEntity)this.te).isOutputFull()) {
            curInfo.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.etching_tank.output_full", new Object[0]));
        }
        if (((EtchingTankBlockEntity)this.te).isFailedOutputFull()) {
            curInfo.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.etching_tank.failed_full", new Object[0]));
        }
        if (((EtchingTankBlockEntity)this.te).getAcidTank().getFluid().isEmpty()) {
            curInfo.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.etching_tank.no_acid", new Object[0]));
        }
    }
}

