/*
 * Decompiled with CFR 0.152.
 */
package fuzs.pickupnotifier.client.gui.entry;

import com.mojang.blaze3d.systems.RenderSystem;
import fuzs.pickupnotifier.client.gui.entry.DisplayEntry;
import fuzs.pickupnotifier.client.util.TransparencyBuffer;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Rarity;

public class ExperienceDisplayEntry
extends DisplayEntry {
    private static final ResourceLocation EXPERIENCE_ORB_TEXTURES = ResourceLocationHelper.withDefaultNamespace((String)"textures/entity/experience_orb.png");
    private final Component name;

    public ExperienceDisplayEntry(Component name, int amount) {
        super(amount, Rarity.UNCOMMON);
        this.name = name;
    }

    @Override
    protected Component getEntryName() {
        return this.name;
    }

    @Override
    public boolean mayMergeWith(DisplayEntry other, boolean excludeNamed) {
        return other instanceof ExperienceDisplayEntry;
    }

    @Override
    protected int getInventoryCount(Inventory inventory) {
        return 0;
    }

    @Override
    protected void renderSprite(Minecraft minecraft, GuiGraphics guiGraphics, int posX, int posY, float scale, float fadeTime) {
        int textureOffset = this.getXpTexture(this.getDisplayAmount());
        int x = textureOffset % 4 * 16;
        int y = textureOffset / 4 * 16;
        float color = (float)((int)((double)System.currentTimeMillis() % 1000000.0 / 50.0)) / 4.0f;
        float r = (Mth.sin((float)color) + 1.0f) * 0.5f;
        float g = 1.0f;
        float b = (Mth.sin((float)(color + 4.1887903f)) + 1.0f) * 0.1f;
        TransparencyBuffer.prepareExtraFramebuffer();
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)1.0f);
        guiGraphics.blit(EXPERIENCE_ORB_TEXTURES, posX, posY, (float)x, (float)y, 16, 16, 64, 64);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        TransparencyBuffer.preInject(fadeTime);
        guiGraphics.pose().pushPose();
        guiGraphics.pose().scale(1.0f / scale, 1.0f / scale, 1.0f);
        TransparencyBuffer.drawExtraFramebuffer(guiGraphics);
        guiGraphics.pose().popPose();
        TransparencyBuffer.postInject();
    }

    private int getXpTexture(int displayCount) {
        if (displayCount >= 2477) {
            return 10;
        }
        if (displayCount >= 1237) {
            return 9;
        }
        if (displayCount >= 617) {
            return 8;
        }
        if (displayCount >= 307) {
            return 7;
        }
        if (displayCount >= 149) {
            return 6;
        }
        if (displayCount >= 73) {
            return 5;
        }
        if (displayCount >= 37) {
            return 4;
        }
        if (displayCount >= 17) {
            return 3;
        }
        if (displayCount >= 7) {
            return 2;
        }
        return displayCount >= 3 ? 1 : 0;
    }
}

