/*
 * Decompiled with CFR 0.152.
 */
package com.lootintegrations.loot;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.lootintegrations.LootintegrationsMod;
import com.lootintegrations.config.CommonConfiguration;
import com.lootintegrations.loot.INoMapContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;

public class GlobalLootModifierIntegration {
    private final ResourceLocation location;
    public ResourceLocation lootTableId;
    public Map<ResourceLocation, Integer> integratedTables = new HashMap<ResourceLocation, Integer>();
    private int fillSize = 27;
    private static final String LOOT_TABLE_ID = "loot_table";
    private static final String INTEGRATED_LOOT_TABLES = "integrated_loot_tables";
    private static final String MAX_RESULT_ITEMCOUNT = "max_result_itemcount";

    private GlobalLootModifierIntegration(ResourceLocation location) {
        this.location = location;
    }

    public void doApply(List<ItemStack> generatedLoot, LootContext context) {
        Object extraItems = new ArrayList();
        try {
            if (context instanceof INoMapContext) {
                INoMapContext noMapContext = (INoMapContext)context;
                if (((CommonConfiguration)LootintegrationsMod.config.getCommonConfig()).skipMapItems) {
                    noMapContext.disabledMaps();
                }
            }
            extraItems = ((LootTable)((Registry)context.getLevel().getServer().reloadableRegistries().get().registry(Registries.LOOT_TABLE).get()).get(this.lootTableId)).getRandomItems(context);
        }
        catch (Exception e) {
            if (((CommonConfiguration)LootintegrationsMod.config.getCommonConfig()).debugOutput) {
                LootintegrationsMod.LOGGER.warn("Loot generation of modifier:" + String.valueOf(this.location) + " for context failed for:" + String.valueOf(this.lootTableId), (Throwable)e);
            }
            return;
        }
        if (((CommonConfiguration)LootintegrationsMod.config.getCommonConfig()).debugOutput) {
            LootintegrationsMod.LOGGER.info("Adding loot to: " + String.valueOf(context.getQueriedLootTableId()) + "from: " + String.valueOf(this.lootTableId) + " caused by:" + String.valueOf(this.location));
        }
        if (extraItems.isEmpty()) {
            if (((CommonConfiguration)LootintegrationsMod.config.getCommonConfig()).debugOutput) {
                LootintegrationsMod.LOGGER.info("Could not generate items for loottable: " + String.valueOf(this.lootTableId));
            }
            return;
        }
        int itemCount = this.integratedTables.getOrDefault(context.getQueriedLootTableId(), 1);
        if ((extraItems = this.aggregateStacks((List<ItemStack>)extraItems)).isEmpty()) {
            return;
        }
        if (!generatedLoot.isEmpty() && generatedLoot.size() + itemCount > this.fillSize) {
            List<ItemStack> newList = this.aggregateStacks(generatedLoot);
            generatedLoot.clear();
            generatedLoot.addAll(newList);
            if (generatedLoot.size() > this.fillSize) {
                int size = Math.min(generatedLoot.size(), generatedLoot.size() + itemCount - this.fillSize);
                for (int i = 0; i < size; ++i) {
                    generatedLoot.remove(LootintegrationsMod.rand.nextInt(generatedLoot.size()));
                }
            }
        }
        for (int i = 0; i < itemCount; ++i) {
            ItemStack stack = (ItemStack)extraItems.remove(LootintegrationsMod.rand.nextInt(extraItems.size()));
            generatedLoot.add(stack);
            if (((CommonConfiguration)LootintegrationsMod.config.getCommonConfig()).debugOutput) {
                LootintegrationsMod.LOGGER.info("Adding loot to: " + String.valueOf(context.getQueriedLootTableId()) + " item:" + stack.toString());
            }
            if (extraItems.isEmpty()) break;
        }
    }

    private List<ItemStack> aggregateStacks(List<ItemStack> stacksIn) {
        HashMap<Item, ItemStack> aggregated = new HashMap<Item, ItemStack>();
        for (ItemStack stack : stacksIn) {
            ItemStack contained = (ItemStack)aggregated.get(stack.getItem());
            if (stack.isEmpty()) continue;
            if (contained == null) {
                aggregated.put(stack.getItem(), stack);
                continue;
            }
            if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)contained)) continue;
            contained.setCount(Math.min(contained.getCount() + stack.getCount(), Math.max(1, contained.getMaxStackSize() / 2)));
        }
        return new ArrayList<ItemStack>(aggregated.values());
    }

    public static GlobalLootModifierIntegration read(ResourceLocation location, JsonElement data) {
        GlobalLootModifierIntegration modifier = new GlobalLootModifierIntegration(location);
        JsonObject jsonData = (JsonObject)data;
        modifier.lootTableId = ResourceLocation.tryParse((String)jsonData.get(LOOT_TABLE_ID).getAsString());
        LootintegrationsMod.LOGGER.info("Parsing loot modifiers for:" + String.valueOf(location) + " with loottable: " + String.valueOf(modifier.lootTableId));
        if (jsonData.has(MAX_RESULT_ITEMCOUNT)) {
            modifier.fillSize = jsonData.get(MAX_RESULT_ITEMCOUNT).getAsInt();
        }
        HashMap<ResourceLocation, Integer> integratedTables = new HashMap<ResourceLocation, Integer>();
        for (Map.Entry element : jsonData.get(INTEGRATED_LOOT_TABLES).getAsJsonObject().entrySet()) {
            ResourceLocation integratedTable = ResourceLocation.tryParse((String)((String)element.getKey()));
            integratedTables.put(integratedTable, ((JsonElement)element.getValue()).getAsInt());
        }
        modifier.integratedTables = integratedTables;
        return modifier;
    }
}

