/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.simpleweather;

import java.nio.file.Path;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.common.ModConfigSpec;

public class SimpleWeatherConfig {
    private final ModConfig.Type _type = ModConfig.Type.CLIENT;
    private final ModConfigSpec _configs;
    public final ModConfigSpec.BooleanValue OverrideWeather;
    public final ModConfigSpec.IntValue WeatherParticleAmount;
    public final ModConfigSpec.IntValue WeatherParticleThunderAmount;
    public final ModConfigSpec.BooleanValue UseCachedAABB;
    public final ModConfigSpec.BooleanValue FullBiomeLookup;
    public final ModConfigSpec.DoubleValue RainScale;
    public final ModConfigSpec.DoubleValue RainAlpha;
    public final ModConfigSpec.IntValue RainLifetime;
    public final ModConfigSpec.IntValue RainRange;
    public final ModConfigSpec.BooleanValue RainHasRandom;
    public final ModConfigSpec.IntValue RainColorBlendingFrequency;
    public final ModConfigSpec.IntValue RainCollisionPercent;
    public final ModConfigSpec.DoubleValue SnowScale;
    public final ModConfigSpec.DoubleValue SnowAlpha;
    public final ModConfigSpec.IntValue SnowLifetime;
    public final ModConfigSpec.IntValue SnowRange;
    public final ModConfigSpec.IntValue SnowOuterRange;

    public SimpleWeatherConfig() {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        String root = "config.client.simple_weather";
        this.OverrideWeather = builder.translation("%s.override_weather".formatted(root)).comment("An alternative render to weather").define("override_weather", true);
        this.WeatherParticleAmount = builder.translation("%s.weather_particle_count".formatted(root)).comment("The how many particles will have a chance to spawn in a given tick. This will be affected by in game Minecraft options as well, so be aware if changing. You may also ask, why is this not separate for rain and snow, and that is simply due to the way the loop works at the moment so we don't do 2 different large loops").defineInRange("weather_particle_count", 4500, 100, 20000);
        this.WeatherParticleThunderAmount = builder.translation("%s.weather_particle_thunder_count".formatted(root)).comment("The same as `weather_particle_count`, but during thunderstorms.").defineInRange("weather_particle_thunder_count", 7875, 100, 20000);
        String rain = "%s.rain".formatted(root);
        builder.translation(rain).push("Rain");
        this.RainAlpha = builder.translation("%s.rain_particle_alpha".formatted(rain)).comment("The opacity of the rain particle. (1 is fully opaque)").defineInRange("rain_particle_alpha", 0.8, 0.2, 1.0);
        this.RainScale = builder.translation("%s.rain_particle_scale".formatted(rain)).comment("Base scaling of the rain particle.").defineInRange("rain_particle_scale", 1.65, 0.1, 4.0);
        this.RainLifetime = builder.translation("%s.rain_lifetime".formatted(rain)).comment("How long can a single rain particle live for without hitting the ground.").defineInRange("rain_lifetime", 70, 10, 120);
        this.RainRange = builder.translation("%s.rain_range".formatted(rain)).comment("How far from the player should rain particles spawn. Lowering this number will increase the density if the weather amount is not changed").defineInRange("rain_range", 22, 5, 64);
        this.RainHasRandom = builder.translation("%s.rain_random".formatted(rain)).comment("Determines if the rain should fall deterministically down, or have a slight random appearance").define("rain_random", true);
        this.RainCollisionPercent = builder.translation("%s.rain_collision_percent".formatted(rain)).comment("How often can a rain particle \"collide\" with the ground").defineInRange("rain_collision_percent", 100, 0, 100);
        this.RainColorBlendingFrequency = builder.translation("%s.rain_color_blending_frequency".formatted(rain)).comment("How frequently should rain particles try to color towards the biome's color. (set to 0 to turn off)").defineInRange("rain_color_blending_frequency", 4, 0, 20);
        this.UseCachedAABB = builder.translation("%s.use_cached_aabb".formatted(rain)).comment("There is a calculation done at the start of a rain droplet that determines if the particle should render. This trades memory for performance. At the moment, neither option is known which is better by default.").define("use_cached_aabb", true);
        this.FullBiomeLookup = builder.translation("%s.full_biome_lookup".formatted(rain)).comment("Note, this is provided purely as an option and is HIGHLY likely not to change any noticeable performance.").define("full_biome_lookup", true);
        builder.pop();
        String snow = "%s.snow".formatted(root);
        builder.translation(snow).push("Snow");
        this.SnowAlpha = builder.translation("%s.snow_particle_alpha".formatted(snow)).comment("The opacity of the rain particle. (1 is fully opaque)").defineInRange("snow_particle_alpha", 1.0, 0.2, 1.0);
        this.SnowScale = builder.translation("%s.snow_particle_scale".formatted(snow)).comment("Changes the base scaling of the rain particle.").defineInRange("snow_particle_scale", 1.4, 0.1, 4.0);
        this.SnowLifetime = builder.translation("%s.snow_lifetime".formatted(snow)).comment("How long can a single snow particle live for without hitting the ground.").defineInRange("snow_lifetime", 30, 10, 100);
        this.SnowRange = builder.translation("%s.snow_range".formatted(snow)).comment("How far from the player should snow particles spawn. Lowering this number will increase the density if the weather amount is not changed").defineInRange("snow_range", 12, 5, 64);
        this.SnowOuterRange = builder.translation("%s.snow_outer_range".formatted(snow)).comment("How far from the player should the secondary layer of snow particles spawn. Lowering this number will increase the density if the weather amount is not changed").defineInRange("snow_outer_range", 16, 5, 64);
        builder.pop();
        this._configs = builder.build();
    }

    public void register(ModLoadingContext context) {
        FMLPaths.getOrCreateGameRelativePath((Path)FMLPaths.CONFIGDIR.get());
        ModContainer container = context.getActiveContainer();
        container.registerConfig(this._type, (IConfigSpec)this._configs, "%s-%s.toml".formatted("simple_weather", this._type.extension()));
    }
}

