/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftboceanmobs.mobai;

import dev.ftb.mods.ftboceanmobs.entity.BaseRiftMob;
import java.util.ArrayDeque;
import java.util.Deque;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;

public class DelayedMeleeAttackGoal
extends MeleeAttackGoal {
    private final int delayTicks;
    private final Deque<QueuedAttack> queuedAttacks = new ArrayDeque<QueuedAttack>();

    public DelayedMeleeAttackGoal(PathfinderMob mob, double speedModifier, boolean followingTargetEvenIfNotSeen, int delayTicks) {
        super(mob, speedModifier, followingTargetEvenIfNotSeen);
        this.delayTicks = delayTicks;
    }

    public boolean canContinueToUse() {
        return super.canContinueToUse() || !this.queuedAttacks.isEmpty();
    }

    public void tick() {
        super.tick();
        if (!this.queuedAttacks.isEmpty()) {
            QueuedAttack next = this.queuedAttacks.peekFirst();
            if (next.when <= (long)this.mob.tickCount) {
                this.queuedAttacks.removeFirst();
                PathfinderMob pathfinderMob = this.mob;
                if (pathfinderMob instanceof BaseRiftMob) {
                    BaseRiftMob b = (BaseRiftMob)pathfinderMob;
                    b.playDelayedAttackSound();
                }
                if (next.target.isAlive() && this.mob.isWithinMeleeAttackRange(next.target)) {
                    this.mob.doHurtTarget((Entity)next.target);
                }
            }
        }
    }

    protected void checkAndPerformAttack(LivingEntity target) {
        if (this.canPerformAttack(target)) {
            this.resetAttackCooldown();
            this.mob.swing(InteractionHand.MAIN_HAND);
            this.queuedAttacks.addLast(new QueuedAttack(this.mob.tickCount + this.delayTicks, target));
        }
    }

    private record QueuedAttack(long when, LivingEntity target) {
    }
}

