/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftboceanmobs.entity.riftweaver;

import dev.ftb.mods.ftboceanmobs.FTBOceanMobsTags;
import dev.ftb.mods.ftboceanmobs.block.EnergyGeyserBlock;
import dev.ftb.mods.ftboceanmobs.registry.ModBlocks;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;

public class SeismicSmasher {
    private static final int MAX_WORKERS = 15;
    private final Level level;
    private final Predicate<BlockPos> validator;
    private final BlockPos origin;
    private final int maxRadiusSq;
    private final List<SmashWorker> workers = new ArrayList<SmashWorker>();

    public SeismicSmasher(Level level, BlockPos origin, int maxRadius, int nInitialWorkers, Predicate<BlockPos> validator) {
        this.level = level;
        this.validator = validator;
        this.origin = level.getHeightmapPos(Heightmap.Types.WORLD_SURFACE, origin).below();
        this.maxRadiusSq = maxRadius * maxRadius;
        float incr = (float)Math.PI * 2 / (float)nInitialWorkers;
        float rot = incr * level.random.nextFloat();
        int i = 0;
        while (i < nInitialWorkers) {
            float fudge = level.random.nextFloat() * 0.6f - 0.3f;
            this.workers.add(new SmashWorker(Vec3.atCenterOf((Vec3i)origin), new Vec3(1.0, 0.0, 0.0).yRot(rot + fudge)));
            ++i;
            rot += incr;
        }
    }

    public boolean tick() {
        ArrayList<SmashWorker> newWorkers = new ArrayList<SmashWorker>();
        Iterator<SmashWorker> iterator = this.workers.iterator();
        while (iterator.hasNext()) {
            SmashWorker worker = iterator.next();
            if (!worker.tick()) {
                iterator.remove();
                continue;
            }
            if (this.workers.size() >= 15 || this.level.random.nextInt(8) != 0) continue;
            newWorkers.add(worker.createBranch());
        }
        this.workers.addAll(newWorkers);
        return !this.workers.isEmpty();
    }

    class SmashWorker {
        private Vec3 pos;
        private final Vec3 direction;

        private SmashWorker(Vec3 pos, Vec3 direction) {
            this.pos = pos;
            this.direction = direction;
        }

        boolean tick() {
            this.pos = this.pos.add(this.direction);
            BlockPos blockPos = BlockPos.containing((Position)this.pos);
            if (SeismicSmasher.this.origin.distToCenterSqr((Position)this.pos) <= (double)SeismicSmasher.this.maxRadiusSq && SeismicSmasher.this.validator.test(blockPos)) {
                BlockPos workPos = SeismicSmasher.this.level.getHeightmapPos(Heightmap.Types.OCEAN_FLOOR, blockPos).below();
                BlockState state = SeismicSmasher.this.level.getBlockState(workPos);
                Registry blockReg = SeismicSmasher.this.level.registryAccess().registryOrThrow(Registries.BLOCK);
                if (state.is(FTBOceanMobsTags.Blocks.SEISMIC_SMASHABLE)) {
                    blockReg.getRandomElementOf(FTBOceanMobsTags.Blocks.SEISMIC_CRACKED, SeismicSmasher.this.level.random).ifPresent(h -> {
                        BlockState newState = SeismicSmasher.this.level.random.nextInt(20) == 0 ? ((EnergyGeyserBlock)((Object)((Object)ModBlocks.ENERGY_GEYSER.get()))).defaultBlockState() : ((Block)h.value()).defaultBlockState();
                        SeismicSmasher.this.level.setBlock(SeismicSmasher.this.level.random.nextInt(4) == 0 ? workPos.above() : workPos, newState, 3);
                    });
                } else if (state.is(FTBOceanMobsTags.Blocks.SEISMIC_CRACKED)) {
                    blockReg.getRandomElementOf(FTBOceanMobsTags.Blocks.SEISMIC_SMASHED, SeismicSmasher.this.level.random).ifPresent(h -> {
                        SeismicSmasher.this.level.setBlock(workPos, ((Block)h.value()).defaultBlockState(), 3);
                        SeismicSmasher.this.level.removeBlock(workPos.below(), false);
                    });
                }
                if (SeismicSmasher.this.level.random.nextInt(5) == 0) {
                    SeismicSmasher.this.level.levelEvent(2001, workPos.above(), Block.getId((BlockState)state));
                }
                return true;
            }
            return false;
        }

        public SmashWorker createBranch() {
            float yaw = SeismicSmasher.this.level.random.nextFloat() * 0.5f + 0.35f;
            Vec3 newDir = this.direction.yRot(SeismicSmasher.this.level.random.nextBoolean() ? yaw : -yaw);
            return new SmashWorker(this.pos.add(newDir), newDir);
        }
    }
}

