/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftboceanmobs.entity;

import dev.ftb.mods.ftboceanmobs.entity.BaseRiftMob;
import dev.ftb.mods.ftboceanmobs.registry.ModSounds;
import dev.ftb.mods.ftboceanmobs.util.MiscUtil;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.Tags;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.util.GeckoLibUtil;

public class RiftlingObserver
extends BaseRiftMob {
    public static final double GAZE_MIN_ANGLE = 0.4;
    private static final int TELEPORT_TIME = 32;
    private static final RawAnimation TELEPORT_ANIMATION = RawAnimation.begin().thenPlay("move.teleport");
    public static final RawAnimation ATTACK_GAZE = RawAnimation.begin().thenPlay("attack.gaze");
    protected static final EntityDataAccessor<Boolean> DATA_GAZE_WARMING_UP = SynchedEntityData.defineId(RiftlingObserver.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected static final EntityDataAccessor<Boolean> DATA_TELEPORTING = SynchedEntityData.defineId(RiftlingObserver.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> DATA_ATTACK_TARGET = SynchedEntityData.defineId(RiftlingObserver.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private long lastGazeTime = 0L;
    @Nullable
    private LivingEntity clientSideCachedAttackTarget;
    private int clientSideGazeWarmupTime;
    private Vec3 pendingTeleportDest;
    private int teleportTimer;

    public RiftlingObserver(EntityType<? extends RiftlingObserver> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 14.0).add(Attributes.FOLLOW_RANGE, 42.0).add(Attributes.MOVEMENT_SPEED, (double)0.19f).add(Attributes.WATER_MOVEMENT_EFFICIENCY, 0.3333333432674408).add(Attributes.ATTACK_DAMAGE, 2.0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new ObserverGazeAttackGoal(this));
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.goalSelector.addGoal(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Warden.class, true));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_GAZE_WARMING_UP, (Object)false);
        builder.define(DATA_TELEPORTING, (Object)false);
        builder.define(DATA_ATTACK_TARGET, (Object)0);
    }

    public void aiStep() {
        super.aiStep();
        if (this.level().isClientSide) {
            if (this.isGazeWarmingUp() && this.clientSideGazeWarmupTime < ObserverGazeAttackGoal.TOTAL_TIME) {
                ++this.clientSideGazeWarmupTime;
            }
        } else if (this.isTeleporting()) {
            ++this.teleportTimer;
            if (this.teleportTimer == 16) {
                this.teleportTo(this.pendingTeleportDest.x, this.pendingTeleportDest.y, this.pendingTeleportDest.z);
                this.level().playSound(null, this.xo, this.yo, this.zo, SoundEvents.ENDERMAN_TELEPORT, this.getSoundSource(), 1.0f, 1.0f);
                this.playSound(SoundEvents.ENDERMAN_TELEPORT, 1.0f, 1.0f);
            } else if (this.teleportTimer >= 32) {
                this.setTeleporting(false);
            }
        }
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)ModSounds.RIFTLING_OBSERVER_AMBIENT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)ModSounds.RIFTLING_OBSERVER_DEATH.get();
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        if (DATA_ATTACK_TARGET.equals(key)) {
            this.clientSideGazeWarmupTime = 0;
            this.clientSideCachedAttackTarget = null;
        }
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        if (source.is(Tags.DamageTypes.IS_TECHNICAL)) {
            return super.hurt(source, amount);
        }
        boolean potion = source.getDirectEntity() instanceof ThrownPotion;
        if (!source.is(DamageTypeTags.IS_PROJECTILE) && !potion) {
            if (!this.level().isClientSide() && this.random.nextInt(3) == 0) {
                this.teleport();
                return false;
            }
            return super.hurt(source, amount);
        }
        for (int i = 0; i < 64; ++i) {
            if (!this.teleport()) continue;
            return true;
        }
        return potion;
    }

    private void startTeleporting(Vec3 dest) {
        this.pendingTeleportDest = dest;
        this.teleportTimer = 0;
        this.setTeleporting(true);
    }

    private Vec3 findValidTeleportDest(double x, double y, double z) {
        boolean okToTeleport = false;
        BlockPos blockpos = BlockPos.containing((double)x, (double)y, (double)z);
        Vec3 dest = null;
        if (this.level().hasChunkAt(blockpos)) {
            boolean foundValidBlock = false;
            while (!foundValidBlock && blockpos.getY() > this.level().getMinBuildHeight()) {
                BlockPos blockpos1 = blockpos.below();
                BlockState blockstate = this.level().getBlockState(blockpos1);
                if (blockstate.blocksMotion() || blockstate.getBlock() instanceof LiquidBlock) {
                    foundValidBlock = true;
                    continue;
                }
                y -= 1.0;
                blockpos = blockpos1;
            }
            if (foundValidBlock && this.level().noCollision((Entity)this, this.getBoundingBox().move(x - this.getX(), y - this.getY(), z - this.getZ()))) {
                dest = new Vec3(x, y, z);
                okToTeleport = true;
            }
        }
        if (okToTeleport) {
            this.getNavigation().stop();
            return dest;
        }
        return null;
    }

    protected boolean teleport() {
        double z;
        double y;
        double x;
        Vec3 dest;
        if (!this.level().isClientSide() && this.isAlive() && (dest = this.findValidTeleportDest(x = this.getX() + (this.random.nextDouble() - 0.5) * 16.0, y = this.getY() + (double)(this.random.nextInt(16) - 8), z = this.getZ() + (this.random.nextDouble() - 0.5) * 16.0)) != null) {
            this.startTeleporting(dest);
            return true;
        }
        return false;
    }

    private void setTeleporting(boolean isTeleporting) {
        this.entityData.set(DATA_TELEPORTING, (Object)isTeleporting);
    }

    public boolean isTeleporting() {
        return (Boolean)this.entityData.get(DATA_TELEPORTING);
    }

    private void setGazeWarmingUp(boolean warmingUp) {
        this.getEntityData().set(DATA_GAZE_WARMING_UP, (Object)warmingUp);
    }

    public boolean isGazeWarmingUp() {
        return (Boolean)this.getEntityData().get(DATA_GAZE_WARMING_UP);
    }

    public boolean hasSyncedGazeTarget() {
        return (Integer)this.entityData.get(DATA_ATTACK_TARGET) != 0;
    }

    public void setSyncedGazeTarget(@Nullable LivingEntity target) {
        this.entityData.set(DATA_ATTACK_TARGET, (Object)(target == null ? 0 : target.getId()));
    }

    @Nullable
    public LivingEntity getSyncedGazeTarget() {
        if (!this.hasSyncedGazeTarget()) {
            return null;
        }
        if (this.level().isClientSide) {
            if (this.clientSideCachedAttackTarget != null) {
                return this.clientSideCachedAttackTarget;
            }
            Entity entity = this.level().getEntity(((Integer)this.entityData.get(DATA_ATTACK_TARGET)).intValue());
            if (entity instanceof LivingEntity) {
                this.clientSideCachedAttackTarget = (LivingEntity)entity;
                return this.clientSideCachedAttackTarget;
            }
            return null;
        }
        return this.getTarget();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(DefaultAnimations.genericWalkIdleController((GeoAnimatable)this));
        controllers.add(DefaultAnimations.genericAttackAnimation((LivingEntity)this, (RawAnimation)ATTACK_GAZE));
        controllers.add(new AnimationController((GeoAnimatable)this, "Teleport", 32, this::teleportAnimationState));
        controllers.add(new AnimationController((GeoAnimatable)this, "Gaze", 32, this::gazeAnimationState));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public int getCurrentSwingDuration() {
        return 30;
    }

    public float getAttackAnimationScale(float partialTick) {
        return ((float)this.clientSideGazeWarmupTime + partialTick) / (float)ObserverGazeAttackGoal.TOTAL_TIME;
    }

    public float getClientSideAttackTime() {
        return this.clientSideGazeWarmupTime;
    }

    private PlayState teleportAnimationState(AnimationState<RiftlingObserver> state) {
        if (this.isTeleporting()) {
            state.setAnimation(TELEPORT_ANIMATION);
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private PlayState gazeAnimationState(AnimationState<RiftlingObserver> state) {
        if (this.isGazeWarmingUp()) {
            state.setAnimation(ATTACK_GAZE);
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private static class ObserverGazeAttackGoal
    extends Goal {
        public static final int TOTAL_TIME = ObserverGazeAttackGoal.reducedTickDelay((int)30);
        public static final int ATTACK_TIME = ObserverGazeAttackGoal.reducedTickDelay((int)20);
        private final RiftlingObserver observer;
        private int chargeTime;
        private LivingEntity target;

        public ObserverGazeAttackGoal(RiftlingObserver observer) {
            this.observer = observer;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            if (this.chargeTime > 0 || this.observer.level().getGameTime() - this.observer.lastGazeTime < 60L) {
                return false;
            }
            this.target = this.observer.getTarget();
            return this.target != null && this.target.isAlive() && this.observer.canAttack(this.target) && MiscUtil.isLookingAtMe((LivingEntity)this.observer, this.target, 0.4);
        }

        public boolean canContinueToUse() {
            return this.chargeTime < TOTAL_TIME && this.target.isAlive() && this.observer.canAttack(this.target) && this.observer.getSensing().hasLineOfSight((Entity)this.target);
        }

        public void start() {
            this.chargeTime = -5;
            this.observer.getNavigation().stop();
            this.observer.getLookControl().setLookAt((Entity)this.target, 45.0f, 10.0f);
            this.observer.setSyncedGazeTarget(this.observer.getTarget());
        }

        public void stop() {
            this.chargeTime = 0;
            this.observer.setGazeWarmingUp(false);
            this.observer.setSyncedGazeTarget(null);
            this.target = null;
        }

        public void tick() {
            this.observer.setSyncedGazeTarget(this.chargeTime >= 3 && this.chargeTime <= 10 ? this.target : null);
            this.observer.getLookControl().setLookAt((Entity)this.target);
            ++this.chargeTime;
            if (this.chargeTime == 0) {
                this.observer.setGazeWarmingUp(true);
            } else if (this.chargeTime == ATTACK_TIME) {
                this.observer.lastGazeTime = this.observer.level().getGameTime();
                this.observer.playSound(SoundEvents.EVOKER_CAST_SPELL, 1.0f, 1.0f);
                if (this.target != null && this.target.isAlive() && MiscUtil.isLookingAtMe((LivingEntity)this.observer, this.target, 0.4)) {
                    this.observer.level().playSound(null, this.target.blockPosition(), SoundEvents.EVOKER_CAST_SPELL, SoundSource.HOSTILE, 1.0f, 1.0f);
                    this.target.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 60, 3));
                    this.target.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 150, 10));
                }
            }
        }
    }
}

