/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftboceanmobs.entity;

import dev.ftb.mods.ftboceanmobs.entity.BaseRiftMob;
import dev.ftb.mods.ftboceanmobs.mobai.DelayedMeleeAttackGoal;
import dev.ftb.mods.ftboceanmobs.registry.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.ai.util.HoverRandomPos;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.util.GeckoLibUtil;

public class AbyssalWinged
extends BaseRiftMob {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public AbyssalWinged(EntityType<? extends AbyssalWinged> entityType, Level level) {
        super(entityType, level);
        this.moveControl = new FlyingMoveControl((Mob)this, 10, true);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 75.0).add(Attributes.FLYING_SPEED, (double)0.6f).add(Attributes.MOVEMENT_SPEED, (double)0.23f).add(Attributes.ATTACK_KNOCKBACK, 2.5).add(Attributes.ARMOR, 16.0).add(Attributes.ARMOR_TOUGHNESS, 6.0).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.GRAVITY, 0.015).add(Attributes.ATTACK_DAMAGE, 9.0);
    }

    @Override
    protected PathNavigation createNavigation(Level level) {
        FlyingPathNavigation nav = new FlyingPathNavigation((Mob)this, level);
        nav.setCanOpenDoors(false);
        nav.setCanFloat(true);
        nav.setCanPassDoors(true);
        return nav;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new DelayedMeleeAttackGoal((PathfinderMob)this, 3.0, true, 15));
        this.goalSelector.addGoal(2, (Goal)new AbyssalWingedWanderGoal((PathfinderMob)this));
        this.goalSelector.addGoal(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Warden.class, true));
    }

    protected AABB getAttackBoundingBox() {
        return super.getAttackBoundingBox().inflate(1.4);
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return (SoundEvent)ModSounds.ABYSSAL_WINGED_AMBIENT.get();
    }

    @Override
    public int getAmbientSoundInterval() {
        return 180;
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)ModSounds.ABYSSAL_WINGED_DEATH.get();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "Default", 5, this::determineAnimationState));
    }

    private PlayState determineAnimationState(AnimationState<AbyssalWinged> state) {
        state.setControllerSpeed(1.0f);
        if (this.swinging) {
            state.setAnimation(DefaultAnimations.ATTACK_STRIKE);
            state.setControllerSpeed(2.5f);
        } else if (this.onGround()) {
            state.setAnimation(DefaultAnimations.REST);
        } else if (state.isMoving()) {
            state.setAnimation(DefaultAnimations.FLY);
        } else {
            state.setAnimation(DefaultAnimations.IDLE);
        }
        return PlayState.CONTINUE;
    }

    public int getCurrentSwingDuration() {
        return 17;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    protected void checkFallDamage(double y, boolean onGround, BlockState state, BlockPos pos) {
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        if (spawnType == MobSpawnType.NATURAL && level.getFluidState(this.blockPosition()).is(Tags.Fluids.WATER)) {
            BlockPos pos = this.blockPosition();
            int y = level.getHeight(Heightmap.Types.WORLD_SURFACE, pos.getX(), pos.getZ()) + 4;
            this.moveTo(Vec3.atCenterOf((Vec3i)pos.above(y - pos.getY())));
        }
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    public static class AbyssalWingedWanderGoal
    extends WaterAvoidingRandomFlyingGoal {
        public AbyssalWingedWanderGoal(PathfinderMob mob) {
            super(mob, (double)1.2f);
            this.interval = 30;
        }

        protected Vec3 getPosition() {
            Vec3 viewVec = this.mob.getViewVector(0.0f);
            Vec3 pos = HoverRandomPos.getPos((PathfinderMob)this.mob, (int)8, (int)3, (double)viewVec.x, (double)viewVec.z, (float)1.5707964f, (int)3, (int)1);
            return pos != null ? pos : AirAndWaterRandomPos.getPos((PathfinderMob)this.mob, (int)8, (int)3, (int)-2, (double)viewVec.x, (double)viewVec.z, (double)1.5707963705062866);
        }
    }
}

