/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftboceanmobs.datagen;

import dev.ftb.mods.ftboceanmobs.datagen.ModBlockStateProvider;
import dev.ftb.mods.ftboceanmobs.datagen.ModEnchantmentProvider;
import dev.ftb.mods.ftboceanmobs.datagen.ModItemModelProvider;
import dev.ftb.mods.ftboceanmobs.datagen.ModLangProvider;
import dev.ftb.mods.ftboceanmobs.datagen.ModLootTableProvider;
import dev.ftb.mods.ftboceanmobs.datagen.ModSoundProvider;
import dev.ftb.mods.ftboceanmobs.datagen.ModTagsProvider;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

public class DataGenerators {
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = ((DatapackBuiltinEntriesProvider)event.getGenerator().addProvider(event.includeServer(), output -> new DatapackBuiltinEntriesProvider(output, event.getLookupProvider(), new RegistrySetBuilder().add(Registries.ENCHANTMENT, ModEnchantmentProvider::bootstrap), Set.of("ftboceanmobs")))).getRegistryProvider();
        generator.addProvider(event.includeClient(), (DataProvider)new ModItemModelProvider(generator, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ModBlockStateProvider(generator.getPackOutput(), existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ModLangProvider(generator.getPackOutput()));
        generator.addProvider(event.includeClient(), (DataProvider)new ModSoundProvider(generator.getPackOutput(), existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModTagsProvider.EntityType(generator.getPackOutput(), lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModTagsProvider.Block(generator.getPackOutput(), lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModTagsProvider.Enchantment(generator.getPackOutput(), lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModLootTableProvider(generator.getPackOutput(), lookupProvider));
    }

    public static List<DataProvider> makeProviders(PackOutput output, CompletableFuture<HolderLookup.Provider> vanillaRegistries, ExistingFileHelper efh) {
        RegistrySetBuilder builder = new RegistrySetBuilder().add(Registries.ENCHANTMENT, ModEnchantmentProvider::bootstrap);
        return List.of(new DatapackBuiltinEntriesProvider(output, vanillaRegistries, builder, Set.of("ftboceanmobs")));
    }
}

