/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftboceanmobs.client;

import com.mojang.blaze3d.shaders.FogShape;
import dev.ftb.mods.ftboceanmobs.client.particle.ItemParticleProvider;
import dev.ftb.mods.ftboceanmobs.client.render.AbyssalSludgeRenderer;
import dev.ftb.mods.ftboceanmobs.client.render.AbyssalWingedRenderer;
import dev.ftb.mods.ftboceanmobs.client.render.CorrosiveCraigRenderer;
import dev.ftb.mods.ftboceanmobs.client.render.MossbackGoliathRenderer;
import dev.ftb.mods.ftboceanmobs.client.render.RiftDemonRenderer;
import dev.ftb.mods.ftboceanmobs.client.render.RiftMinotaurRenderer;
import dev.ftb.mods.ftboceanmobs.client.render.RiftWeaverBossRenderer;
import dev.ftb.mods.ftboceanmobs.client.render.RiftlingObserverRenderer;
import dev.ftb.mods.ftboceanmobs.client.render.ShadowBeastRenderer;
import dev.ftb.mods.ftboceanmobs.client.render.SludgelingRenderer;
import dev.ftb.mods.ftboceanmobs.client.render.TentacledHorrorRenderer;
import dev.ftb.mods.ftboceanmobs.client.render.TumblingBlockRenderer;
import dev.ftb.mods.ftboceanmobs.entity.TentacledHorror;
import dev.ftb.mods.ftboceanmobs.fluid.AbyssalWaterFluid;
import dev.ftb.mods.ftboceanmobs.network.PlayerAttackTentaclePacket;
import dev.ftb.mods.ftboceanmobs.registry.ModEntityTypes;
import dev.ftb.mods.ftboceanmobs.registry.ModFluids;
import dev.ftb.mods.ftboceanmobs.registry.ModItems;
import dev.ftb.mods.ftboceanmobs.registry.ModMobEffects;
import dev.ftb.mods.ftboceanmobs.registry.ModParticleTypes;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.network.PacketDistributor;

public class ClientSetup {
    public static void onModConstruction(ModContainer modContainer, IEventBus modEventBus) {
        modEventBus.addListener(ClientSetup::onClientSetup);
        modEventBus.addListener(ClientSetup::registerRenderers);
        modEventBus.addListener(ClientSetup::registerParticleProviders);
        modEventBus.addListener(ClientSetup::registerClientExtensions);
        NeoForge.EVENT_BUS.addListener(ClientSetup::onPlayerLeftClickEmpty);
        NeoForge.EVENT_BUS.addListener(ClientSetup::onFogDensity);
        NeoForge.EVENT_BUS.addListener(ClientSetup::onFogColor);
    }

    private static void onFogColor(ViewportEvent.ComputeFogColor event) {
        Player player;
        Entity entity = event.getCamera().getEntity();
        if (entity instanceof Player && (player = (Player)entity).hasEffect(ModMobEffects.DROWNING_SHADOWS_EFFECT)) {
            event.setRed(0.26f);
            event.setGreen(0.05f);
            event.setBlue(0.3f);
        }
    }

    private static void onFogDensity(ViewportEvent.RenderFog event) {
        Player player;
        Entity entity = event.getCamera().getEntity();
        if (entity instanceof Player && (player = (Player)entity).hasEffect(ModMobEffects.DROWNING_SHADOWS_EFFECT)) {
            int ticks = player.getEffect(ModMobEffects.DROWNING_SHADOWS_EFFECT).getDuration();
            event.setNearPlaneDistance(0.2f);
            event.setFarPlaneDistance(20.0f + (ticks < 100 ? (float)(100 - ticks) * 1.2f : 0.0f));
            event.setFogShape(FogShape.SPHERE);
            event.setCanceled(true);
        }
    }

    public static void onClientSetup(FMLClientSetupEvent event) {
    }

    public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer(ModEntityTypes.RIFTLING_OBSERVER.get(), RiftlingObserverRenderer::new);
        event.registerEntityRenderer(ModEntityTypes.ABYSSAL_WINGED.get(), ctx -> AbyssalWingedRenderer.scaled(ctx, 1.0f));
        event.registerEntityRenderer(ModEntityTypes.CORROSIVE_CRAIG.get(), ctx -> CorrosiveCraigRenderer.scaled(ctx, 0.9f));
        event.registerEntityRenderer(ModEntityTypes.MOSSBACK_GOLIATH.get(), ctx -> MossbackGoliathRenderer.scaled(ctx, 0.75f));
        event.registerEntityRenderer(ModEntityTypes.ABYSSAL_SLUDGE.get(), ctx -> AbyssalSludgeRenderer.scaled(ctx, 1.0f));
        event.registerEntityRenderer(ModEntityTypes.SHADOW_BEAST.get(), ctx -> ShadowBeastRenderer.scaled(ctx, 0.25f));
        event.registerEntityRenderer(ModEntityTypes.RIFT_MINOTAUR.get(), ctx -> RiftMinotaurRenderer.scaled(ctx, 1.17f));
        event.registerEntityRenderer(ModEntityTypes.TENTACLED_HORROR.get(), ctx -> TentacledHorrorRenderer.scaled(ctx, 2.9f));
        event.registerEntityRenderer(ModEntityTypes.RIFT_DEMON.get(), ctx -> RiftDemonRenderer.scaled(ctx, 1.18f));
        event.registerEntityRenderer(ModEntityTypes.RIFT_WEAVER.get(), ctx -> RiftWeaverBossRenderer.scaled(ctx, 2.9f));
        event.registerEntityRenderer(ModEntityTypes.SLUDGELING.get(), SludgelingRenderer::new);
        event.registerEntityRenderer(ModEntityTypes.TUMBLING_BLOCK.get(), TumblingBlockRenderer::new);
    }

    private static void registerClientExtensions(RegisterClientExtensionsEvent event) {
        event.registerFluidType((IClientFluidTypeExtensions)AbyssalWaterFluid.RENDER_PROPS, new FluidType[]{ModFluids.ABYSSAL_WATER_TYPE.get()});
    }

    public static void registerParticleProviders(RegisterParticleProvidersEvent event) {
        event.registerSpecial((ParticleType)ModParticleTypes.SLUDGE.get(), (ParticleProvider)new ItemParticleProvider(ModItems.SLUDGE_BALL.toStack()));
        event.registerSpecial((ParticleType)ModParticleTypes.MOSSBACK_SHARD.get(), (ParticleProvider)new ItemParticleProvider(Items.AMETHYST_SHARD.getDefaultInstance()));
        event.registerSpecial((ParticleType)ModParticleTypes.HORROR_INK.get(), (ParticleProvider)new ItemParticleProvider(Items.BLACK_DYE.getDefaultInstance()));
    }

    private static void onPlayerLeftClickEmpty(PlayerInteractEvent.LeftClickEmpty event) {
        if (event.getEntity().getVehicle() instanceof TentacledHorror) {
            PacketDistributor.sendToServer((CustomPacketPayload)PlayerAttackTentaclePacket.INSTANCE, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

